/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.client;

import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.apache.wink.client.ClientConfigException;
import org.apache.wink.client.handlers.ClientHandler;
import org.apache.wink.client.handlers.ConnectionHandler;
import org.apache.wink.client.internal.handlers.AcceptHeaderHandler;
import org.apache.wink.client.internal.handlers.HttpURLConnectionHandler;
import org.apache.wink.common.WinkApplication;
import org.apache.wink.common.internal.application.ApplicationFileLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientConfig
implements Cloneable {
    private String proxyHost = null;
    private int proxyPort = 80;
    private int connectTimeout = 60000;
    private int readTimeout = 60000;
    private boolean followRedirects = true;
    private LinkedList<ClientHandler> handlers = new LinkedList();
    private LinkedList<Application> applications;
    private boolean modifiable = true;
    private boolean isAcceptHeaderAutoSet = true;
    private boolean loadWinkApplications = true;

    private void initDefaultApplication() {
        if (this.applications != null) {
            return;
        }
        this.applications = new LinkedList();
        try {
            final Set classes = new ApplicationFileLoader(this.loadWinkApplications).getClasses();
            this.applications(new Application[]{new WinkApplication(){

                public Set<Class<?>> getClasses() {
                    return classes;
                }

                public double getPriority() {
                    return 0.1;
                }
            }});
        }
        catch (FileNotFoundException e) {
            throw new ClientConfigException(e);
        }
    }

    public final String getProxyHost() {
        return this.proxyHost;
    }

    public final ClientConfig proxyHost(String proxyHost) {
        if (!this.modifiable) {
            throw new ClientConfigException("configuration is unmodifiable");
        }
        this.proxyHost = proxyHost;
        return this;
    }

    public final int getProxyPort() {
        return this.proxyPort;
    }

    public final ClientConfig proxyPort(int proxyPort) {
        if (!this.modifiable) {
            throw new ClientConfigException("configuration is unmodifiable");
        }
        if (proxyPort <= 0) {
            proxyPort = 80;
        }
        this.proxyPort = proxyPort;
        return this;
    }

    public final int getConnectTimeout() {
        return this.connectTimeout;
    }

    public final ClientConfig connectTimeout(int connectTimeout) {
        if (!this.modifiable) {
            throw new ClientConfigException("configuration is unmodifiable");
        }
        this.connectTimeout = connectTimeout;
        return this;
    }

    public final int getReadTimeout() {
        return this.readTimeout;
    }

    public final ClientConfig readTimeout(int readTimeout) {
        if (!this.modifiable) {
            throw new ClientConfigException("configuration is unmodifiable");
        }
        this.readTimeout = readTimeout;
        return this;
    }

    public final boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public final ClientConfig followRedirects(boolean followRedirects) {
        if (!this.modifiable) {
            throw new ClientConfigException("configuration is unmodifiable");
        }
        this.followRedirects = followRedirects;
        return this;
    }

    public final boolean isAcceptHeaderAutoSet() {
        return this.isAcceptHeaderAutoSet;
    }

    public final ClientConfig acceptHeaderAutoSet(boolean isAcceptHeaderAutoSet) {
        if (!this.modifiable) {
            throw new ClientConfigException("configuration is unmodifiable");
        }
        this.isAcceptHeaderAutoSet = isAcceptHeaderAutoSet;
        return this;
    }

    public final List<ClientHandler> getHandlers() {
        return Collections.unmodifiableList(this.handlers);
    }

    public final ClientConfig handlers(ClientHandler ... handlers) {
        if (!this.modifiable) {
            throw new ClientConfigException("configuration is unmodifiable");
        }
        for (ClientHandler handler : handlers) {
            this.handlers.add(handler);
        }
        return this;
    }

    ClientConfig build() {
        if (this.isAcceptHeaderAutoSet) {
            this.handlers.add(new AcceptHeaderHandler());
        }
        this.handlers.add(this.getConnectionHandler());
        this.modifiable = false;
        return this;
    }

    protected ConnectionHandler getConnectionHandler() {
        return new HttpURLConnectionHandler();
    }

    public final List<Application> getApplications() {
        if (this.applications == null) {
            this.initDefaultApplication();
        }
        return Collections.unmodifiableList(this.applications);
    }

    public final ClientConfig applications(Application ... applications) {
        if (!this.modifiable) {
            throw new ClientConfigException("configuration is unmodifiable");
        }
        if (this.applications == null) {
            this.initDefaultApplication();
        }
        for (Application application : applications) {
            this.applications.add(application);
        }
        return this;
    }

    protected ClientConfig clone() {
        if (this.applications == null) {
            this.initDefaultApplication();
        }
        try {
            ClientConfig clone = (ClientConfig)super.clone();
            clone.handlers = new LinkedList<ClientHandler>(this.handlers);
            clone.applications = new LinkedList<Application>(this.applications);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void setLoadWinkApplications(boolean loadWinkApplications) {
        this.loadWinkApplications = loadWinkApplications;
    }

    public boolean isLoadWinkApplications() {
        return this.loadWinkApplications;
    }
}

