/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.model.atom;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.wink.common.RestException;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.model.AnyContentHandler;
import org.apache.wink.common.internal.model.ModelUtils;
import org.apache.wink.common.model.atom.AtomCommonAttributes;
import org.apache.wink.common.model.synd.SyndContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="atomContent", propOrder={"any"})
public class AtomContent
extends AtomCommonAttributes {
    @XmlTransient
    private List<Object> any;
    @XmlAttribute
    protected String type;
    @XmlAttribute
    protected String src;
    @XmlTransient
    private Object savedValue = null;
    @XmlTransient
    private Providers providers;

    public AtomContent() {
    }

    public AtomContent(SyndContent value) {
        super(value);
        if (value == null) {
            return;
        }
        this.setSrc(value.getSrc());
        this.setType(value.getType());
        this.setValue(value.getValue(Object.class));
    }

    public SyndContent toSynd(SyndContent value) {
        if (value == null) {
            return value;
        }
        super.toSynd(value);
        value.setSrc(this.getSrc());
        value.setType(this.getType());
        value.setValue(this.getValue(Object.class));
        return value;
    }

    public void setProviders(Providers _providers) {
        this.providers = _providers;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String value) {
        this.type = value;
        this.checkValidity();
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String value) {
        this.src = value;
        this.checkValidity();
    }

    public void setValue(Object value) {
        this.any = value != null ? Arrays.asList(value) : null;
        this.checkValidity();
    }

    public String getValue() {
        return this.getValue(String.class);
    }

    public <T> T getValue(Class<T> cls) {
        try {
            return this.getValue(cls, cls, this.providers, ModelUtils.EMPTY_ARRAY, ModelUtils.EMPTY_STRING_MAP, ModelUtils.determineMediaType(this.type));
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    public <T> T getValue(Class<T> cls, Type genericType, Providers providers, Annotation[] annotations, MultivaluedMap<String, String> httpHeaders, MediaType mediaType) throws IOException {
        return ModelUtils.readValue(this.getAny(), cls, providers, genericType, annotations, httpHeaders, mediaType);
    }

    @XmlMixed
    @XmlAnyElement(lax=true, value=AnyContentHandler.class)
    List<Object> getAny() {
        ModelUtils.fixAnyContent(this.any, this.type);
        return this.any;
    }

    void setAny(List<Object> any) {
        this.any = any;
    }

    public void checkValidity() {
        if (this.src != null && this.any != null) {
            throw new RestException(Messages.getMessage("contentMayHaveInlineOrOutContent"));
        }
        if (this.src != null && this.type != null && (this.type.equals("text") || this.type.equals("html") || this.type.equals("xhtml"))) {
            throw new RestException(Messages.getMessage("typeAttribMustHaveValidMimeType"));
        }
    }

    void revertValue() {
        this.setValue(this.savedValue);
        this.savedValue = null;
    }

    Object saveValue() {
        this.savedValue = this.getValue();
        this.setValue(null);
        return this.savedValue;
    }
}

