/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.sap.universe;

import java.util.OptionalInt;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.sap.universe.UniverseInfo;

public class UniverseQuery {
    private String select;
    private String where;
    private UniverseInfo universeInfo;
    private boolean duplicatedRows = false;
    private OptionalInt maxRowsRetrieved;

    public UniverseQuery(String select, String where, UniverseInfo universeInfo, boolean duplicatedRows, OptionalInt maxRowsRetrieved) {
        this.select = select;
        this.where = where;
        this.universeInfo = universeInfo;
        this.duplicatedRows = duplicatedRows;
        this.maxRowsRetrieved = maxRowsRetrieved;
    }

    public boolean isCorrect() {
        return StringUtils.isNotBlank((CharSequence)this.select) && this.universeInfo != null && StringUtils.isNotBlank((CharSequence)this.universeInfo.getId()) && StringUtils.isNotBlank((CharSequence)this.universeInfo.getName());
    }

    public String getSelect() {
        return this.select;
    }

    public String getWhere() {
        return this.where;
    }

    public UniverseInfo getUniverseInfo() {
        return this.universeInfo;
    }

    public boolean getDuplicatedRows() {
        return this.duplicatedRows;
    }

    public OptionalInt getMaxRowsRetrieved() {
        return this.maxRowsRetrieved;
    }
}

