/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.sap.universe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Stack;
import java.util.StringTokenizer;
import jline.console.completer.ArgumentCompleter;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.sap.universe.UniverseClient;
import org.apache.zeppelin.sap.universe.UniverseException;
import org.apache.zeppelin.sap.universe.UniverseInfo;
import org.apache.zeppelin.sap.universe.UniverseNodeInfo;
import org.apache.zeppelin.sap.universe.UniverseQuery;

public class UniverseUtil {
    private static final String COMPRASION_START_TEMPLATE = "<comparisonFilter path=\"%s\" operator=\"%s\" id=\"%s\">\n";
    private static final String COMPRASION_END_TEMPLATE = "</comparisonFilter>\n";
    private static final String COMPARISON_FILTER = "<comparisonFilter id=\"%s\" path=\"%s\" operator=\"%s\"/>\n";
    private static final String CONST_OPERAND_START_TEMPLATE = "<constantOperand>\n";
    private static final String CONST_OPERAND_END_TEMPLATE = "</constantOperand>\n";
    private static final String CONST_OPERAND_VALUE_TEMPLATE = "<value>\n<caption type=\"%s\">%s</caption>\n</value>\n";
    private static final String PREDEFINED_FILTER_TEMPLATE = "<predefinedFilter path=\"%s\" id=\"%s\"/>\n";
    private static final String OBJECT_OPERAND_TEMPLATE = "<objectOperand id=\"%s\" path=\"%s\"/>\n";
    private static final String RESULT_START_TEMPLATE = "<resultObjects>\n";
    private static final String RESULT_END_TEMPLATE = "</resultObjects>\n";
    private static final String RESULT_OBJ_TEMPLATE = "<resultObject path=\"%s\" id=\"%s\"/>\n";
    private static final String MARKER_EQUAL = "#EqualTo#";
    private static final String MARKER_LESS_EQUAL = "#LessThanOrEqualTo#";
    private static final String MARKER_NOT_EQUAL = "#NotEqualTo#";
    private static final String MARKER_LESS = "#LessThan#";
    private static final String MARKER_GREATER_EQUALS = "#GreaterThanOrEqualTo#";
    private static final String MARKER_GREATER = "#GreaterThan#";
    private static final String MARKER_IN = "#InList#";
    private static final String MARKER_NOT_IN = "#NotInList#";
    private static final String MARKER_NULL = "#IsNull#";
    private static final String MARKER_NOT_NULL = "#IsNotNull#";
    private static final String MARKER_FILTER = "#filter#";
    private static final String MARKER_AND = "#and#";
    private static final String MARKER_OR = "#or#";
    private static final String MARKER_BACKSPACE = "#backspace#";
    private static final String MARKER_LEFT_BRACE = "#left_brace#";
    private static final String MARKER_RIGHT_BRACE = "#right_brace#";
    private static final String LEFT_BRACE = "(";
    private static final String RIGHT_BRACE = ")";
    public static final Map<String, Integer> OPERATIONS;
    private static final ArgumentCompleter.WhitespaceArgumentDelimiter delimiter;

    public static OptionalInt parseInt(String toParse) {
        try {
            return OptionalInt.of(Integer.parseInt(toParse));
        }
        catch (NumberFormatException e) {
            return OptionalInt.empty();
        }
    }

    public UniverseQuery convertQuery(String text, UniverseClient client, String token) throws UniverseException {
        StringBuilder select = new StringBuilder();
        StringBuilder universe = new StringBuilder();
        StringBuilder buf = new StringBuilder();
        StringBuilder resultObj = new StringBuilder();
        StringBuilder whereBuf = new StringBuilder();
        UniverseInfo universeInfo = null;
        String where = null;
        boolean singleQuoteClosed = true;
        boolean pathClosed = true;
        boolean universePart = false;
        boolean selectPart = false;
        boolean wherePart = false;
        boolean listOperator = false;
        boolean operatorPosition = false;
        boolean duplicatedRows = true;
        Map<String, UniverseNodeInfo> nodeInfos = null;
        OptionalInt limit = OptionalInt.empty();
        int limitIndex = text.lastIndexOf("limit");
        if (limitIndex != -1) {
            int length;
            String[] arguments = delimiter.delimit((CharSequence)text, 0).getArguments();
            if (arguments[(length = arguments.length) - 3].equals("limit")) {
                limit = UniverseUtil.parseInt(arguments[length - 2]);
            } else if (arguments[length - 2].equals("limit")) {
                String toParse = arguments[length - 1];
                limit = UniverseUtil.parseInt(toParse.endsWith(";") ? toParse.substring(0, toParse.length() - 1) : toParse);
            }
            text = text.substring(0, limitIndex);
        }
        if (!text.endsWith(";")) {
            text = text + ";";
        }
        char[] array = text.toCharArray();
        block12: for (int i = 0; i < array.length; ++i) {
            char c = array[i];
            buf.append(c);
            if (c == '\'' && (i == 0 || array[i - 1] != '\\')) {
                boolean bl = singleQuoteClosed = !singleQuoteClosed;
            }
            if (c == '[' && pathClosed && singleQuoteClosed) {
                pathClosed = false;
                if (wherePart) {
                    operatorPosition = false;
                }
            }
            if (c == ']' && !pathClosed && singleQuoteClosed) {
                pathClosed = true;
                if (wherePart) {
                    operatorPosition = true;
                    if (i + 1 == array.length || array[i + 1] != '.' && this.isFilter(String.format("%s]", whereBuf.toString()), text.substring(i + 1))) {
                        whereBuf.append(c);
                        whereBuf.append(MARKER_FILTER);
                        if (i + 1 != array.length) continue;
                        wherePart = false;
                        where = this.parseWhere(whereBuf.toString(), nodeInfos);
                        continue;
                    }
                }
            }
            if (c == '(' && wherePart && pathClosed && singleQuoteClosed) {
                if (listOperator) {
                    whereBuf.append(MARKER_LEFT_BRACE);
                    continue;
                }
                whereBuf.append(c);
                continue;
            }
            if (c == ')' && wherePart && pathClosed && singleQuoteClosed) {
                if (listOperator) {
                    whereBuf.append(MARKER_RIGHT_BRACE);
                    listOperator = false;
                    continue;
                }
                whereBuf.append(c);
                continue;
            }
            if (!universePart && singleQuoteClosed && buf.toString().toLowerCase().endsWith("universe")) {
                universePart = true;
                continue;
            }
            if (universePart) {
                if (c == ';' && singleQuoteClosed) {
                    universePart = false;
                    if (universe.toString().trim().length() <= 2) continue;
                    String universeName = universe.toString().trim().substring(1, universe.toString().trim().length() - 1);
                    universeInfo = client.getUniverseInfo(universeName);
                    nodeInfos = client.getUniverseNodesInfo(token, universeName);
                    continue;
                }
                universe.append(c);
                continue;
            }
            if (!selectPart && pathClosed && singleQuoteClosed && buf.toString().toLowerCase().endsWith("select")) {
                if (StringUtils.isBlank((CharSequence)universe.toString())) {
                    throw new UniverseException("Not found universe name");
                }
                selectPart = true;
                select.append(RESULT_START_TEMPLATE);
                continue;
            }
            if (!wherePart && pathClosed && singleQuoteClosed) {
                if (buf.toString().toLowerCase().endsWith("where")) {
                    wherePart = true;
                }
                if (buf.toString().toLowerCase().endsWith("where") || i == array.length - 1) {
                    selectPart = false;
                    select.append(this.parseResultObj(resultObj.toString().replaceAll("(?i)wher$", "").replaceAll("(?i)distinc", ""), nodeInfos));
                    select.append(RESULT_END_TEMPLATE);
                    continue;
                }
            }
            if (selectPart) {
                if (pathClosed && singleQuoteClosed && buf.toString().toLowerCase().endsWith("distinct")) {
                    duplicatedRows = false;
                    continue;
                }
                if (pathClosed && singleQuoteClosed && c == ',') {
                    select.append(this.parseResultObj(resultObj.toString().replaceAll("(?i)distinc", ""), nodeInfos));
                    resultObj = new StringBuilder();
                    continue;
                }
                resultObj.append(c);
                continue;
            }
            if (!wherePart) continue;
            if (c == ';' && pathClosed && singleQuoteClosed) {
                wherePart = false;
                where = this.parseWhere(whereBuf.toString(), nodeInfos);
                continue;
            }
            if (!singleQuoteClosed || !pathClosed) {
                switch (c) {
                    case '\n': 
                    case ' ': {
                        whereBuf.append(MARKER_BACKSPACE);
                        break;
                    }
                    case '(': {
                        whereBuf.append(MARKER_LEFT_BRACE);
                        break;
                    }
                    case ')': {
                        whereBuf.append(MARKER_RIGHT_BRACE);
                        break;
                    }
                    default: {
                        whereBuf.append(c);
                        break;
                    }
                }
                continue;
            }
            if (pathClosed) {
                if ((c == 'a' || c == 'A') && i < array.length - 2 && text.substring(i, i + 3).equalsIgnoreCase("and")) {
                    i += 2;
                    whereBuf.append(MARKER_AND);
                    operatorPosition = false;
                    continue;
                }
                if ((c == 'o' || c == 'O') && i < array.length - 1 && text.substring(i, i + 2).equalsIgnoreCase("or")) {
                    ++i;
                    whereBuf.append(MARKER_OR);
                    operatorPosition = false;
                    continue;
                }
                if (operatorPosition) {
                    switch (c) {
                        case '=': {
                            whereBuf.append(MARKER_EQUAL);
                            operatorPosition = false;
                            break;
                        }
                        case '<': {
                            if (i + 1 < array.length) {
                                if (array[i + 1] == '=') {
                                    whereBuf.append(MARKER_LESS_EQUAL);
                                    operatorPosition = false;
                                    ++i;
                                    break;
                                }
                                if (array[i + 1] == '>') {
                                    whereBuf.append(MARKER_NOT_EQUAL);
                                    operatorPosition = false;
                                    ++i;
                                    break;
                                }
                            }
                            operatorPosition = false;
                            whereBuf.append(MARKER_LESS);
                            break;
                        }
                        case '>': {
                            if (i + 1 < array.length && array[i + 1] == '=') {
                                whereBuf.append(MARKER_GREATER_EQUALS);
                                operatorPosition = false;
                                ++i;
                                break;
                            }
                            operatorPosition = false;
                            whereBuf.append(MARKER_GREATER);
                            break;
                        }
                        case 'I': 
                        case 'i': {
                            boolean whileI = true;
                            StringBuilder operI = new StringBuilder();
                            operI.append(c);
                            while (whileI) {
                                if (++i >= array.length) {
                                    whileI = false;
                                }
                                if (array[i] == ' ' || array[i] == '\n') continue;
                                operI.append(array[i]);
                                String tmp = operI.toString().toLowerCase();
                                if (tmp.equals("in")) {
                                    whereBuf.append(MARKER_IN);
                                    listOperator = true;
                                    whileI = false;
                                    operatorPosition = false;
                                } else if (tmp.equals("isnull")) {
                                    whereBuf.append(MARKER_NULL);
                                    whileI = false;
                                    operatorPosition = false;
                                } else if (tmp.equals("isnotnull")) {
                                    whereBuf.append(MARKER_NOT_NULL);
                                    whileI = false;
                                    operatorPosition = false;
                                }
                                if (tmp.length() <= 8) continue;
                                whileI = false;
                            }
                            continue block12;
                        }
                        case 'N': 
                        case 'n': {
                            boolean whileN = true;
                            StringBuilder operN = new StringBuilder();
                            operN.append(c);
                            while (whileN) {
                                if (++i >= array.length) {
                                    whileN = false;
                                }
                                if (array[i] == ' ' || array[i] == '\n') continue;
                                operN.append(array[i]);
                                String tmp = operN.toString().toLowerCase();
                                if (tmp.equals("notin")) {
                                    whereBuf.append(MARKER_NOT_IN);
                                    listOperator = true;
                                    whileN = false;
                                    operatorPosition = false;
                                }
                                if (tmp.length() <= 4) continue;
                                whileN = false;
                            }
                            continue block12;
                        }
                        default: {
                            whereBuf.append(c);
                            break;
                        }
                    }
                    continue;
                }
                whereBuf.append(c);
                continue;
            }
            whereBuf.append(c);
        }
        if (wherePart && StringUtils.isBlank(where)) {
            throw new UniverseException("Incorrect block where");
        }
        UniverseQuery universeQuery = new UniverseQuery(select.toString().trim(), where, universeInfo, duplicatedRows, limit);
        if (!universeQuery.isCorrect()) {
            throw new UniverseException("Incorrect query");
        }
        return universeQuery;
    }

    private String parseWhere(String where, Map<String, UniverseNodeInfo> nodeInfos) throws UniverseException {
        ArrayList<String> out = new ArrayList<String>();
        Stack<String> stack = new Stack<String>();
        where = where.replaceAll("\\s*", "");
        HashSet<String> operationSymbols = new HashSet<String>(OPERATIONS.keySet());
        operationSymbols.add(LEFT_BRACE);
        operationSymbols.add(RIGHT_BRACE);
        int index = 0;
        boolean findNext = true;
        while (findNext) {
            int nextOperationIndex = where.length();
            String nextOperation = "";
            for (String operation : operationSymbols) {
                int i = where.indexOf(operation, index);
                if (i < 0 || i >= nextOperationIndex) continue;
                nextOperation = operation;
                nextOperationIndex = i;
            }
            if (nextOperationIndex == where.length()) {
                findNext = false;
                continue;
            }
            if (index != nextOperationIndex) {
                out.add(where.substring(index, nextOperationIndex));
            }
            if (nextOperation.equals(LEFT_BRACE)) {
                stack.push(nextOperation);
            } else if (nextOperation.equals(RIGHT_BRACE)) {
                while (!((String)stack.peek()).equals(LEFT_BRACE)) {
                    out.add((String)stack.pop());
                    if (!stack.empty()) continue;
                    throw new UniverseException("Unmatched brackets");
                }
                stack.pop();
            } else {
                while (!stack.empty() && !((String)stack.peek()).equals(LEFT_BRACE) && OPERATIONS.get(nextOperation) >= OPERATIONS.get(stack.peek())) {
                    out.add((String)stack.pop());
                }
                stack.push(nextOperation);
            }
            index = nextOperationIndex + nextOperation.length();
        }
        if (index != where.length()) {
            out.add(where.substring(index));
        }
        while (!stack.empty()) {
            out.add((String)stack.pop());
        }
        StringBuffer result = new StringBuffer();
        if (!out.isEmpty()) {
            result.append((String)out.remove(0));
        }
        while (!out.isEmpty()) {
            result.append(" ").append((String)out.remove(0));
        }
        return this.convertWhereToXml(result.toString(), nodeInfos);
    }

    private String parseResultObj(String resultObj, Map<String, UniverseNodeInfo> nodeInfos) throws UniverseException {
        if (StringUtils.isNotBlank((CharSequence)resultObj)) {
            UniverseNodeInfo nodeInfo = nodeInfos.get(resultObj.trim());
            if (nodeInfo != null) {
                return String.format(RESULT_OBJ_TEMPLATE, nodeInfo.getNodePath(), nodeInfo.getId());
            }
            throw new UniverseException(String.format("Not found information about: \"%s\"", resultObj.trim()));
        }
        return "";
    }

    private String convertWhereToXml(String rpn, Map<String, UniverseNodeInfo> nodeInfos) throws UniverseException {
        StringTokenizer tokenizer = new StringTokenizer(rpn, " ");
        Stack<String> stack = new Stack<String>();
        while (tokenizer.hasMoreTokens()) {
            UniverseNodeInfo leftOperandInfo;
            String leftOperand;
            UniverseNodeInfo rightOperandInfo;
            StringBuilder tmp = new StringBuilder();
            String token = tokenizer.nextToken();
            if (!OPERATIONS.keySet().contains(token)) {
                stack.push(token.trim());
                continue;
            }
            String rightOperand = this.revertReplace((String)stack.pop());
            String operator = token.replaceAll("^#|#$", "");
            if (token.equalsIgnoreCase(MARKER_NOT_NULL) || token.equalsIgnoreCase(MARKER_NULL)) {
                rightOperandInfo = nodeInfos.get(rightOperand);
                stack.push(String.format(COMPARISON_FILTER, rightOperandInfo.getId(), rightOperandInfo.getNodePath(), operator));
                continue;
            }
            if (token.equalsIgnoreCase(MARKER_FILTER)) {
                rightOperandInfo = nodeInfos.get(rightOperand);
                stack.push(String.format(PREDEFINED_FILTER_TEMPLATE, rightOperandInfo.getNodePath(), rightOperandInfo.getId()));
                continue;
            }
            String string = leftOperand = stack.empty() ? null : this.revertReplace((String)stack.pop());
            if (token.equalsIgnoreCase(MARKER_AND) || token.equalsIgnoreCase(MARKER_OR)) {
                if (rightOperand.matches("^\\[.*\\]$")) {
                    UniverseNodeInfo rightOperandInfo2 = nodeInfos.get(rightOperand);
                    if (rightOperandInfo2 == null) {
                        throw new UniverseException(String.format("Not found information about: \"%s\"", rightOperand));
                    }
                    rightOperand = String.format(PREDEFINED_FILTER_TEMPLATE, rightOperandInfo2.getNodePath(), rightOperandInfo2.getId());
                }
                if (leftOperand.matches("^\\[.*\\]$")) {
                    leftOperandInfo = nodeInfos.get(leftOperand);
                    if (leftOperandInfo == null) {
                        throw new UniverseException(String.format("Not found information about: \"%s\"", leftOperand));
                    }
                    leftOperand = String.format(PREDEFINED_FILTER_TEMPLATE, leftOperandInfo.getNodePath(), leftOperandInfo.getId());
                }
                tmp.append(String.format("<%s>\n", operator));
                tmp.append(leftOperand);
                tmp.append("\n");
                tmp.append(rightOperand);
                tmp.append("\n");
                tmp.append(String.format("</%s>\n", operator));
                stack.push(tmp.toString());
                continue;
            }
            leftOperandInfo = nodeInfos.get(leftOperand);
            if (leftOperandInfo == null) {
                throw new UniverseException(String.format("Not found information about: \"%s\"", leftOperand));
            }
            if (token.equalsIgnoreCase(MARKER_IN) || token.equalsIgnoreCase(MARKER_NOT_IN)) {
                String listValues = rightOperand.replaceAll("^\\(|\\)$", "").trim();
                boolean startItem = false;
                ArrayList<String> values = new ArrayList<String>();
                StringBuilder value = new StringBuilder();
                boolean isNumericList = false;
                if (listValues.charAt(0) != '\'') {
                    isNumericList = true;
                }
                if (isNumericList) {
                    String[] nums = listValues.split(",");
                    for (String num : nums) {
                        values.add(num.trim());
                    }
                } else {
                    for (int i = 0; i < listValues.length(); ++i) {
                        char c = listValues.charAt(i);
                        if (c == '\'' && (i == 0 || listValues.charAt(i - 1) != '\\')) {
                            boolean bl = startItem = !startItem;
                            if (startItem) continue;
                            values.add(value.toString());
                            value = new StringBuilder();
                            continue;
                        }
                        if (!startItem) continue;
                        value.append(c);
                    }
                }
                if (values.isEmpty()) continue;
                tmp.append(String.format(COMPRASION_START_TEMPLATE, leftOperandInfo.getNodePath(), operator, leftOperandInfo.getId()));
                tmp.append(CONST_OPERAND_START_TEMPLATE);
                String type = isNumericList ? "Numeric" : "String";
                for (String v : values) {
                    tmp.append(String.format(CONST_OPERAND_VALUE_TEMPLATE, type, v));
                }
                tmp.append(CONST_OPERAND_END_TEMPLATE);
                tmp.append(COMPRASION_END_TEMPLATE);
                stack.push(tmp.toString());
                continue;
            }
            UniverseNodeInfo rightOperandInfo3 = null;
            if (rightOperand.startsWith("[") && rightOperand.endsWith("]") && (rightOperandInfo3 = nodeInfos.get(rightOperand)) == null) {
                throw new UniverseException(String.format("Not found information about: \"%s\"", rightOperand));
            }
            if (OPERATIONS.containsKey(token)) {
                if (rightOperandInfo3 != null) {
                    tmp.append(String.format(COMPRASION_START_TEMPLATE, leftOperandInfo.getNodePath(), operator, leftOperandInfo.getId()));
                    tmp.append(String.format(OBJECT_OPERAND_TEMPLATE, rightOperandInfo3.getId(), rightOperandInfo3.getNodePath()));
                    tmp.append(COMPRASION_END_TEMPLATE);
                } else {
                    String type = rightOperand.startsWith("'") ? "String" : "Numeric";
                    String value = rightOperand.replaceAll("^'|'$", "");
                    tmp.append(String.format(COMPRASION_START_TEMPLATE, leftOperandInfo.getNodePath(), operator, leftOperandInfo.getId()));
                    tmp.append(CONST_OPERAND_START_TEMPLATE);
                    tmp.append(String.format(CONST_OPERAND_VALUE_TEMPLATE, type, value));
                    tmp.append(CONST_OPERAND_END_TEMPLATE);
                    tmp.append(COMPRASION_END_TEMPLATE);
                }
                stack.push(tmp.toString());
                continue;
            }
            throw new UniverseException(String.format("Incorrect syntax after: \"%s\"", leftOperand));
        }
        return (String)stack.pop();
    }

    private String revertReplace(String s) {
        return s.replaceAll(MARKER_BACKSPACE, " ").replaceAll(MARKER_LEFT_BRACE, LEFT_BRACE).replaceAll(MARKER_RIGHT_BRACE, RIGHT_BRACE);
    }

    private boolean isFilter(String buf, String after) {
        boolean result = false;
        String[] parts = buf.trim().split("\\s");
        if (parts[parts.length - 1].matches("^\\[.*\\]$")) {
            if (parts.length == 1) {
                result = true;
            } else {
                HashSet<String> operations = new HashSet<String>(OPERATIONS.keySet());
                operations.remove(MARKER_AND);
                operations.remove(MARKER_OR);
                for (int count = parts.length - 2; count >= 0; --count) {
                    String p = parts[count];
                    if (!StringUtils.isNotBlank((CharSequence)p)) continue;
                    if (!operations.contains(p)) {
                        result = true;
                        break;
                    }
                    return false;
                }
            }
            after = after.trim();
            if (result && !after.startsWith("and") && !after.startsWith("or") && !after.startsWith(";") && StringUtils.isNotBlank((CharSequence)after)) {
                result = false;
            }
        }
        return result;
    }

    static {
        delimiter = new ArgumentCompleter.WhitespaceArgumentDelimiter();
        OPERATIONS = new HashMap<String, Integer>();
        OPERATIONS.put(MARKER_EQUAL, 1);
        OPERATIONS.put(MARKER_LESS_EQUAL, 1);
        OPERATIONS.put(MARKER_NOT_EQUAL, 1);
        OPERATIONS.put(MARKER_LESS, 1);
        OPERATIONS.put(MARKER_GREATER_EQUALS, 1);
        OPERATIONS.put(MARKER_GREATER, 1);
        OPERATIONS.put(MARKER_IN, 1);
        OPERATIONS.put(MARKER_NOT_IN, 1);
        OPERATIONS.put(MARKER_NULL, 1);
        OPERATIONS.put(MARKER_NOT_NULL, 1);
        OPERATIONS.put(MARKER_FILTER, 1);
        OPERATIONS.put(MARKER_AND, 2);
        OPERATIONS.put(MARKER_OR, 3);
    }
}

