/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jdbc;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverManagerConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDriver;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.KerberosInterpreter;
import org.apache.zeppelin.interpreter.ResultMessages;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.jdbc.JDBCUserConfigurations;
import org.apache.zeppelin.jdbc.SqlCompleter;
import org.apache.zeppelin.jdbc.security.JDBCSecurityImpl;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.apache.zeppelin.user.UserCredentials;
import org.apache.zeppelin.user.UsernamePassword;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCInterpreter
extends KerberosInterpreter {
    private Logger logger = LoggerFactory.getLogger(JDBCInterpreter.class);
    static final String INTERPRETER_NAME = "jdbc";
    static final String COMMON_KEY = "common";
    static final String MAX_LINE_KEY = "max_count";
    static final int MAX_LINE_DEFAULT = 1000;
    static final String DEFAULT_KEY = "default";
    static final String DRIVER_KEY = "driver";
    static final String URL_KEY = "url";
    static final String USER_KEY = "user";
    static final String PASSWORD_KEY = "password";
    static final String PRECODE_KEY = "precode";
    static final String STATEMENT_PRECODE_KEY = "statementPrecode";
    static final String COMPLETER_SCHEMA_FILTERS_KEY = "completer.schemaFilters";
    static final String COMPLETER_TTL_KEY = "completer.ttlInSeconds";
    static final String DEFAULT_COMPLETER_TTL = "120";
    static final String SPLIT_QURIES_KEY = "splitQueries";
    static final String JDBC_JCEKS_FILE = "jceks.file";
    static final String JDBC_JCEKS_CREDENTIAL_KEY = "jceks.credentialKey";
    static final String PRECODE_KEY_TEMPLATE = "%s.precode";
    static final String STATEMENT_PRECODE_KEY_TEMPLATE = "%s.statementPrecode";
    static final String DOT = ".";
    private static final char WHITESPACE = ' ';
    private static final char NEWLINE = '\n';
    private static final char TAB = '\t';
    private static final String TABLE_MAGIC_TAG = "%table ";
    private static final String EXPLAIN_PREDICATE = "EXPLAIN ";
    static final String COMMON_MAX_LINE = "common.max_count";
    static final String DEFAULT_DRIVER = "default.driver";
    static final String DEFAULT_URL = "default.url";
    static final String DEFAULT_USER = "default.user";
    static final String DEFAULT_PASSWORD = "default.password";
    static final String DEFAULT_PRECODE = "default.precode";
    static final String DEFAULT_STATEMENT_PRECODE = "default.statementPrecode";
    static final String EMPTY_COLUMN_VALUE = "";
    private final String CONCURRENT_EXECUTION_KEY = "zeppelin.jdbc.concurrent.use";
    private final String CONCURRENT_EXECUTION_COUNT = "zeppelin.jdbc.concurrent.max_connection";
    private final String DBCP_STRING = "jdbc:apache:commons:dbcp:";
    private static final String MAX_ROWS_KEY = "zeppelin.jdbc.maxRows";
    private final HashMap<String, Properties> basePropretiesMap;
    private final HashMap<String, JDBCUserConfigurations> jdbcUserConfigurationsMap = new HashMap();
    private final HashMap<String, SqlCompleter> sqlCompletersMap;
    private int maxLineResults = 1000;
    private int maxRows;

    public JDBCInterpreter(Properties property) {
        super(property);
        this.basePropretiesMap = new HashMap();
        this.sqlCompletersMap = new HashMap();
    }

    protected boolean runKerberosLogin() {
        try {
            if (UserGroupInformation.isLoginKeytabBased()) {
                UserGroupInformation.getLoginUser().reloginFromKeytab();
                return true;
            }
            if (UserGroupInformation.isLoginTicketBased()) {
                UserGroupInformation.getLoginUser().reloginFromTicketCache();
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to run kinit for zeppelin", (Throwable)e);
        }
        return false;
    }

    public HashMap<String, Properties> getPropertiesMap() {
        return this.basePropretiesMap;
    }

    public void open() {
        super.open();
        for (String propertyKey : this.properties.stringPropertyNames()) {
            Properties prefixProperties;
            this.logger.debug("propertyKey: {}", (Object)propertyKey);
            String[] keyValue = propertyKey.split("\\.", 2);
            if (2 != keyValue.length) continue;
            this.logger.debug("key: {}, value: {}", (Object)keyValue[0], (Object)keyValue[1]);
            if (this.basePropretiesMap.containsKey(keyValue[0])) {
                prefixProperties = this.basePropretiesMap.get(keyValue[0]);
            } else {
                prefixProperties = new Properties();
                this.basePropretiesMap.put(keyValue[0].trim(), prefixProperties);
            }
            prefixProperties.put(keyValue[1].trim(), this.getProperty(propertyKey));
        }
        HashSet<String> removeKeySet = new HashSet<String>();
        for (String key : this.basePropretiesMap.keySet()) {
            Properties properties;
            if (COMMON_KEY.equals(key) || (properties = this.basePropretiesMap.get(key)).containsKey(DRIVER_KEY) && properties.containsKey(URL_KEY)) continue;
            this.logger.error("{} will be ignored. {}.{} and {}.{} is mandatory.", new Object[]{key, DRIVER_KEY, key, key, URL_KEY});
            removeKeySet.add(key);
        }
        for (String key : removeKeySet) {
            this.basePropretiesMap.remove(key);
        }
        this.logger.debug("JDBC PropretiesMap: {}", this.basePropretiesMap);
        this.setMaxLineResults();
        this.setMaxRows();
    }

    protected boolean isKerboseEnabled() {
        UserGroupInformation.AuthenticationMethod authType;
        return !StringUtils.isEmpty((String)this.getProperty("zeppelin.jdbc.auth.type")) && (authType = JDBCSecurityImpl.getAuthtype(this.properties)).equals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS);
    }

    private void setMaxLineResults() {
        if (this.basePropretiesMap.containsKey(COMMON_KEY) && this.basePropretiesMap.get(COMMON_KEY).containsKey(MAX_LINE_KEY)) {
            this.maxLineResults = Integer.valueOf(this.basePropretiesMap.get(COMMON_KEY).getProperty(MAX_LINE_KEY));
        }
    }

    private void setMaxRows() {
        this.maxRows = Integer.valueOf(this.getProperty(MAX_ROWS_KEY, "1000"));
    }

    private SqlCompleter createOrUpdateSqlCompleter(SqlCompleter sqlCompleter, final Connection connection, String propertyKey, final String buf, final int cursor) {
        SqlCompleter completer;
        block4: {
            String schemaFiltersKey = String.format("%s.%s", propertyKey, COMPLETER_SCHEMA_FILTERS_KEY);
            String sqlCompleterTtlKey = String.format("%s.%s", propertyKey, COMPLETER_TTL_KEY);
            final String schemaFiltersString = this.getProperty(schemaFiltersKey);
            int ttlInSeconds = Integer.valueOf(StringUtils.defaultIfEmpty((String)this.getProperty(sqlCompleterTtlKey), (String)DEFAULT_COMPLETER_TTL));
            completer = sqlCompleter == null ? new SqlCompleter(ttlInSeconds) : sqlCompleter;
            ExecutorService executorService = Executors.newFixedThreadPool(1);
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    completer.createOrUpdateFromConnection(connection, schemaFiltersString, buf, cursor);
                }
            });
            executorService.shutdown();
            try {
                executorService.awaitTermination(3L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                this.logger.warn("Completion timeout", (Throwable)e);
                if (connection == null) break block4;
                try {
                    connection.close();
                }
                catch (SQLException e1) {
                    this.logger.warn("Error close connection", (Throwable)e1);
                }
            }
        }
        return completer;
    }

    private void initStatementMap() {
        for (JDBCUserConfigurations configurations : this.jdbcUserConfigurationsMap.values()) {
            try {
                configurations.initStatementMap();
            }
            catch (Exception e) {
                this.logger.error("Error while closing paragraphIdStatementMap statement...", (Throwable)e);
            }
        }
    }

    private void initConnectionPoolMap() {
        for (String key : this.jdbcUserConfigurationsMap.keySet()) {
            try {
                this.closeDBPool(key, DEFAULT_KEY);
            }
            catch (SQLException e) {
                this.logger.error("Error while closing database pool.", (Throwable)e);
            }
            try {
                JDBCUserConfigurations configurations = this.jdbcUserConfigurationsMap.get(key);
                configurations.initConnectionPoolMap();
            }
            catch (SQLException e) {
                this.logger.error("Error while closing initConnectionPoolMap.", (Throwable)e);
            }
        }
    }

    public void close() {
        super.close();
        try {
            this.initStatementMap();
            this.initConnectionPoolMap();
        }
        catch (Exception e) {
            this.logger.error("Error while closing...", (Throwable)e);
        }
    }

    private String getEntityName(String replName) {
        StringBuffer entityName = new StringBuffer();
        entityName.append(INTERPRETER_NAME);
        entityName.append(DOT);
        entityName.append(replName);
        return entityName.toString();
    }

    private String getJDBCDriverName(String user, String propertyKey) {
        StringBuffer driverName = new StringBuffer();
        driverName.append("jdbc:apache:commons:dbcp:");
        driverName.append(propertyKey);
        driverName.append(user);
        return driverName.toString();
    }

    private boolean existAccountInBaseProperty(String propertyKey) {
        return this.basePropretiesMap.get(propertyKey).containsKey(USER_KEY) && !StringUtils.isEmpty((String)((String)this.basePropretiesMap.get(propertyKey).get(USER_KEY))) && this.basePropretiesMap.get(propertyKey).containsKey(PASSWORD_KEY);
    }

    private UsernamePassword getUsernamePassword(InterpreterContext interpreterContext, String replName) {
        UserCredentials uc = interpreterContext.getAuthenticationInfo().getUserCredentials();
        if (uc != null) {
            return uc.getUsernamePassword(replName);
        }
        return null;
    }

    public JDBCUserConfigurations getJDBCConfiguration(String user) {
        JDBCUserConfigurations jdbcUserConfigurations = this.jdbcUserConfigurationsMap.get(user);
        if (jdbcUserConfigurations == null) {
            jdbcUserConfigurations = new JDBCUserConfigurations();
            this.jdbcUserConfigurationsMap.put(user, jdbcUserConfigurations);
        }
        return jdbcUserConfigurations;
    }

    private void closeDBPool(String user, String propertyKey) throws SQLException {
        PoolingDriver poolingDriver = this.getJDBCConfiguration(user).removeDBDriverPool(propertyKey);
        if (poolingDriver != null) {
            poolingDriver.closePool(propertyKey + user);
        }
    }

    private void setUserProperty(String propertyKey, InterpreterContext interpreterContext) throws SQLException, IOException, InterpreterException {
        String password;
        String user = interpreterContext.getAuthenticationInfo().getUser();
        JDBCUserConfigurations jdbcUserConfigurations = this.getJDBCConfiguration(user);
        if (this.basePropretiesMap.get(propertyKey).containsKey(USER_KEY) && !this.basePropretiesMap.get(propertyKey).getProperty(USER_KEY).isEmpty() && !StringUtils.isEmpty((String)(password = this.getPassword(this.basePropretiesMap.get(propertyKey))))) {
            this.basePropretiesMap.get(propertyKey).setProperty(PASSWORD_KEY, password);
        }
        jdbcUserConfigurations.setPropertyMap(propertyKey, this.basePropretiesMap.get(propertyKey));
        if (this.existAccountInBaseProperty(propertyKey)) {
            return;
        }
        jdbcUserConfigurations.cleanUserProperty(propertyKey);
        UsernamePassword usernamePassword = this.getUsernamePassword(interpreterContext, this.getEntityName(interpreterContext.getReplName()));
        if (usernamePassword != null) {
            jdbcUserConfigurations.setUserProperty(propertyKey, usernamePassword);
        } else {
            this.closeDBPool(user, propertyKey);
        }
    }

    private void createConnectionPool(String url, String user, String propertyKey, Properties properties) throws SQLException, ClassNotFoundException {
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(url, properties);
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, null);
        String maxConnectionLifetime = StringUtils.defaultIfEmpty((String)this.getProperty("zeppelin.jdbc.maxConnLifetime"), (String)"-1");
        poolableConnectionFactory.setMaxConnLifetimeMillis(Long.parseLong(maxConnectionLifetime));
        poolableConnectionFactory.setValidationQuery("show databases");
        GenericObjectPool connectionPool = new GenericObjectPool((PooledObjectFactory)poolableConnectionFactory);
        poolableConnectionFactory.setPool((ObjectPool)connectionPool);
        Class.forName(properties.getProperty(DRIVER_KEY));
        PoolingDriver driver = new PoolingDriver();
        driver.registerPool(propertyKey + user, (ObjectPool)connectionPool);
        this.getJDBCConfiguration(user).saveDBDriverPool(propertyKey, driver);
    }

    private Connection getConnectionFromPool(String url, String user, String propertyKey, Properties properties) throws SQLException, ClassNotFoundException {
        String jdbcDriver = this.getJDBCDriverName(user, propertyKey);
        if (!this.getJDBCConfiguration(user).isConnectionInDBDriverPool(propertyKey)) {
            this.createConnectionPool(url, user, propertyKey, properties);
        }
        return DriverManager.getConnection(jdbcDriver);
    }

    public Connection getConnection(String propertyKey, InterpreterContext interpreterContext) throws ClassNotFoundException, SQLException, InterpreterException, IOException {
        Connection connection;
        final String user = interpreterContext.getAuthenticationInfo().getUser();
        if (propertyKey == null || this.basePropretiesMap.get(propertyKey) == null) {
            return null;
        }
        JDBCUserConfigurations jdbcUserConfigurations = this.getJDBCConfiguration(user);
        this.setUserProperty(propertyKey, interpreterContext);
        final Properties properties = jdbcUserConfigurations.getPropertyMap(propertyKey);
        String url = properties.getProperty(URL_KEY);
        if (StringUtils.isEmpty((String)this.getProperty("zeppelin.jdbc.auth.type"))) {
            connection = this.getConnectionFromPool(url, user, propertyKey, properties);
        } else {
            UserGroupInformation.AuthenticationMethod authType = JDBCSecurityImpl.getAuthtype(this.getProperties());
            final String connectionUrl = this.appendProxyUserToURL(url, user, propertyKey);
            JDBCSecurityImpl.createSecureConfiguration(this.getProperties(), authType);
            switch (authType) {
                case KERBEROS: {
                    if (user == null || "false".equalsIgnoreCase(this.getProperty("zeppelin.jdbc.auth.kerberos.proxy.enable"))) {
                        connection = this.getConnectionFromPool(connectionUrl, user, propertyKey, properties);
                        break;
                    }
                    if (this.basePropretiesMap.get(propertyKey).containsKey("proxy.user.property")) {
                        connection = this.getConnectionFromPool(connectionUrl, user, propertyKey, properties);
                        break;
                    }
                    UserGroupInformation ugi = null;
                    try {
                        ugi = UserGroupInformation.createProxyUser((String)user, (UserGroupInformation)UserGroupInformation.getCurrentUser());
                    }
                    catch (Exception e) {
                        this.logger.error("Error in getCurrentUser", (Throwable)e);
                        throw new InterpreterException("Error in getCurrentUser", (Throwable)e);
                    }
                    final String poolKey = propertyKey;
                    try {
                        connection = (Connection)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Connection>(){

                            @Override
                            public Connection run() throws Exception {
                                return JDBCInterpreter.this.getConnectionFromPool(connectionUrl, user, poolKey, properties);
                            }
                        });
                        break;
                    }
                    catch (Exception e) {
                        this.logger.error("Error in doAs", (Throwable)e);
                        throw new InterpreterException("Error in doAs", (Throwable)e);
                    }
                }
                default: {
                    connection = this.getConnectionFromPool(connectionUrl, user, propertyKey, properties);
                }
            }
        }
        return connection;
    }

    private String appendProxyUserToURL(String url, String user, String propertyKey) {
        StringBuilder connectionUrl = new StringBuilder(url);
        if (user != null && !user.equals("anonymous") && this.basePropretiesMap.get(propertyKey).containsKey("proxy.user.property")) {
            Integer lastIndexOfUrl = connectionUrl.indexOf("?");
            if (lastIndexOfUrl == -1) {
                lastIndexOfUrl = connectionUrl.length();
            }
            this.logger.info("Using proxy user as :" + user);
            this.logger.info("Using proxy property for user as :" + this.basePropretiesMap.get(propertyKey).getProperty("proxy.user.property"));
            connectionUrl.insert((int)lastIndexOfUrl, ";" + this.basePropretiesMap.get(propertyKey).getProperty("proxy.user.property") + "=" + user + ";");
        } else if (user != null && !user.equals("anonymous") && url.contains("hive")) {
            this.logger.warn("User impersonation for hive has changed please refer: http://zeppelin.apache.org/docs/latest/interpreter/jdbc.html#apache-hive");
        }
        return connectionUrl.toString();
    }

    private String getPassword(Properties properties) throws IOException, InterpreterException {
        if (StringUtils.isNotEmpty((String)properties.getProperty(PASSWORD_KEY))) {
            return properties.getProperty(PASSWORD_KEY);
        }
        if (StringUtils.isNotEmpty((String)properties.getProperty(JDBC_JCEKS_FILE)) && StringUtils.isNotEmpty((String)properties.getProperty(JDBC_JCEKS_CREDENTIAL_KEY))) {
            try {
                Configuration configuration = new Configuration();
                configuration.set("hadoop.security.credential.provider.path", properties.getProperty(JDBC_JCEKS_FILE));
                CredentialProvider provider = (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)configuration).get(0);
                CredentialProvider.CredentialEntry credEntry = provider.getCredentialEntry(properties.getProperty(JDBC_JCEKS_CREDENTIAL_KEY));
                if (credEntry != null) {
                    return new String(credEntry.getCredential());
                }
                throw new InterpreterException("Failed to retrieve password from JCEKS from key: " + properties.getProperty(JDBC_JCEKS_CREDENTIAL_KEY));
            }
            catch (Exception e) {
                this.logger.error("Failed to retrieve password from JCEKS \nFor file: " + properties.getProperty(JDBC_JCEKS_FILE) + "\nFor key: " + properties.getProperty(JDBC_JCEKS_CREDENTIAL_KEY), (Throwable)e);
                throw e;
            }
        }
        return null;
    }

    private String getResults(ResultSet resultSet, boolean isTableType, MutableBoolean isComplete) throws SQLException {
        ResultSetMetaData md = resultSet.getMetaData();
        StringBuilder msg = isTableType ? new StringBuilder(TABLE_MAGIC_TAG) : new StringBuilder();
        for (int i = 1; i < md.getColumnCount() + 1; ++i) {
            if (i > 1) {
                msg.append('\t');
            }
            if (StringUtils.isNotEmpty((String)md.getColumnLabel(i))) {
                msg.append(this.replaceReservedChars(md.getColumnLabel(i)));
                continue;
            }
            msg.append(this.replaceReservedChars(md.getColumnName(i)));
        }
        msg.append('\n');
        int displayRowCount = 0;
        while (resultSet.next()) {
            if (displayRowCount >= this.getMaxResult()) {
                isComplete.setValue(false);
                break;
            }
            for (int i = 1; i < md.getColumnCount() + 1; ++i) {
                Object resultObject = resultSet.getObject(i);
                String resultValue = resultObject == null ? "null" : resultSet.getString(i);
                msg.append(this.replaceReservedChars(resultValue));
                if (i == md.getColumnCount()) continue;
                msg.append('\t');
            }
            msg.append('\n');
            ++displayRowCount;
        }
        return msg.toString();
    }

    private boolean isDDLCommand(int updatedCount, int columnCount) throws SQLException {
        return updatedCount < 0 && columnCount <= 0;
    }

    protected ArrayList<String> splitSqlQueries(String sql) {
        ArrayList<String> queries = new ArrayList<String>();
        StringBuilder query = new StringBuilder();
        Boolean multiLineComment = false;
        Boolean singleLineComment = false;
        Boolean quoteString = false;
        Boolean doubleQuoteString = false;
        for (int item = 0; item < sql.length(); ++item) {
            char character = sql.charAt(item);
            if (singleLineComment.booleanValue() && (character == '\n' || item == sql.length() - 1)) {
                singleLineComment = false;
            }
            if (multiLineComment.booleanValue() && character == '/' && sql.charAt(item - 1) == '*') {
                multiLineComment = false;
            }
            if (character == '\'') {
                if (quoteString.booleanValue()) {
                    quoteString = false;
                } else if (!doubleQuoteString.booleanValue()) {
                    quoteString = true;
                }
            }
            if (character == '\"') {
                if (doubleQuoteString.booleanValue() && item > 0) {
                    doubleQuoteString = false;
                } else if (!quoteString.booleanValue()) {
                    doubleQuoteString = true;
                }
            }
            if (!(quoteString.booleanValue() || doubleQuoteString.booleanValue() || multiLineComment.booleanValue() || singleLineComment.booleanValue() || sql.length() <= item + 1)) {
                if (character == '-' && sql.charAt(item + 1) == '-') {
                    singleLineComment = true;
                } else if (character == '/' && sql.charAt(item + 1) == '*') {
                    multiLineComment = true;
                }
            }
            if (!(character != ';' || quoteString.booleanValue() || doubleQuoteString.booleanValue() || multiLineComment.booleanValue() || singleLineComment.booleanValue())) {
                queries.add(StringUtils.trim((String)query.toString()));
                query = new StringBuilder();
                continue;
            }
            if (item == sql.length() - 1) {
                query.append(character);
                queries.add(StringUtils.trim((String)query.toString()));
                continue;
            }
            query.append(character);
        }
        return queries;
    }

    public InterpreterResult executePrecode(InterpreterContext interpreterContext) {
        String propertyKey;
        String precode;
        InterpreterResult interpreterResult = null;
        Iterator<String> iterator = this.basePropretiesMap.keySet().iterator();
        while (iterator.hasNext() && (!StringUtils.isNotBlank((String)(precode = this.getProperty(String.format(PRECODE_KEY_TEMPLATE, propertyKey = iterator.next())))) || (interpreterResult = this.executeSql(propertyKey, precode, interpreterContext)).code() == InterpreterResult.Code.SUCCESS)) {
        }
        return interpreterResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InterpreterResult executeSql(String propertyKey, String sql, InterpreterContext interpreterContext) {
        Connection connection = null;
        ResultSet resultSet = null;
        String paragraphId = interpreterContext.getParagraphId();
        String user = interpreterContext.getAuthenticationInfo().getUser();
        boolean splitQuery = false;
        String splitQueryProperty = this.getProperty(String.format("%s.%s", propertyKey, SPLIT_QURIES_KEY));
        if (StringUtils.isNotBlank((String)splitQueryProperty) && splitQueryProperty.equalsIgnoreCase("true")) {
            splitQuery = true;
        }
        InterpreterResult interpreterResult = new InterpreterResult(InterpreterResult.Code.SUCCESS);
        try {
            connection = this.getConnection(propertyKey, interpreterContext);
        }
        catch (Exception e) {
            String errorMsg = ExceptionUtils.getStackTrace((Throwable)e);
            try {
                this.closeDBPool(user, propertyKey);
            }
            catch (SQLException e1) {
                this.logger.error("Cannot close DBPool for user, propertyKey: " + user + propertyKey, (Throwable)e1);
            }
            interpreterResult.add(errorMsg);
            return new InterpreterResult(InterpreterResult.Code.ERROR, interpreterResult.message());
        }
        if (connection == null) {
            return new InterpreterResult(InterpreterResult.Code.ERROR, "Prefix not found.");
        }
        try {
            List<String> sqlArray = splitQuery ? this.splitSqlQueries(sql) : Arrays.asList(sql);
            for (int i = 0; i < sqlArray.size(); ++i) {
                String sqlToExecute = sqlArray.get(i);
                Statement statement = connection.createStatement();
                statement.setFetchSize(this.getMaxResult());
                statement.setMaxRows(this.maxRows);
                if (statement == null) {
                    InterpreterResult interpreterResult2 = new InterpreterResult(InterpreterResult.Code.ERROR, "Prefix not found.");
                    return interpreterResult2;
                }
                try {
                    this.getJDBCConfiguration(user).saveStatement(paragraphId, statement);
                    String statementPrecode = this.getProperty(String.format(STATEMENT_PRECODE_KEY_TEMPLATE, propertyKey));
                    if (StringUtils.isNotBlank((String)statementPrecode)) {
                        statement.execute(statementPrecode);
                    }
                    boolean isResultSetAvailable = statement.execute(sqlToExecute);
                    this.getJDBCConfiguration(user).setConnectionInDBDriverPoolSuccessful(propertyKey);
                    if (isResultSetAvailable) {
                        resultSet = statement.getResultSet();
                        if (this.isDDLCommand(statement.getUpdateCount(), resultSet.getMetaData().getColumnCount())) {
                            interpreterResult.add(InterpreterResult.Type.TEXT, "Query executed successfully.");
                            continue;
                        }
                        MutableBoolean isComplete = new MutableBoolean(true);
                        String results = this.getResults(resultSet, !StringUtils.containsIgnoreCase((String)sqlToExecute, (String)EXPLAIN_PREDICATE), isComplete);
                        interpreterResult.add(results);
                        if (isComplete.booleanValue()) continue;
                        interpreterResult.add(ResultMessages.getExceedsLimitRowsMessage((int)this.getMaxResult(), (String)String.format("%s.%s", COMMON_KEY, MAX_LINE_KEY)));
                        continue;
                    }
                    int updateCount = statement.getUpdateCount();
                    interpreterResult.add(InterpreterResult.Type.TEXT, "Query executed successfully. Affected rows : " + updateCount);
                    continue;
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
        }
        catch (Throwable e) {
            this.logger.error("Cannot run " + sql, e);
            String errorMsg = ExceptionUtils.getStackTrace((Throwable)e);
            interpreterResult.add(errorMsg);
            InterpreterResult interpreterResult3 = new InterpreterResult(InterpreterResult.Code.ERROR, interpreterResult.message());
            return interpreterResult3;
        }
        finally {
            if (connection != null) {
                try {
                    if (!connection.getAutoCommit()) {
                        connection.commit();
                    }
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
            this.getJDBCConfiguration(user).removeStatement(paragraphId);
        }
        return interpreterResult;
    }

    private String replaceReservedChars(String str) {
        if (str == null) {
            return EMPTY_COLUMN_VALUE;
        }
        return str.replace('\t', ' ').replace('\n', ' ');
    }

    public InterpreterResult interpret(String originalCmd, InterpreterContext contextInterpreter) {
        String cmd = Boolean.parseBoolean(this.getProperty("zeppelin.jdbc.interpolation")) ? this.interpolate(originalCmd, contextInterpreter.getResourcePool()) : originalCmd;
        this.logger.debug("Run SQL command '{}'", (Object)cmd);
        String propertyKey = this.getPropertyKey(cmd);
        if (null != propertyKey && !propertyKey.equals(DEFAULT_KEY)) {
            cmd = cmd.substring(propertyKey.length() + 2);
        }
        cmd = cmd.trim();
        this.logger.debug("PropertyKey: {}, SQL command: '{}'", (Object)propertyKey, (Object)cmd);
        return this.executeSql(propertyKey, cmd, contextInterpreter);
    }

    public void cancel(InterpreterContext context) {
        this.logger.info("Cancel current query statement.");
        String paragraphId = context.getParagraphId();
        JDBCUserConfigurations jdbcUserConfigurations = this.getJDBCConfiguration(context.getAuthenticationInfo().getUser());
        try {
            jdbcUserConfigurations.cancelStatement(paragraphId);
        }
        catch (SQLException e) {
            this.logger.error("Error while cancelling...", (Throwable)e);
        }
    }

    public String getPropertyKey(String cmd) {
        boolean firstLineIndex = cmd.startsWith("(");
        if (firstLineIndex) {
            int configStartIndex = cmd.indexOf("(");
            int configLastIndex = cmd.indexOf(")");
            if (configStartIndex != -1 && configLastIndex != -1) {
                return cmd.substring(configStartIndex + 1, configLastIndex);
            }
            return null;
        }
        return DEFAULT_KEY;
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.SIMPLE;
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }

    public Scheduler getScheduler() {
        String schedulerName = JDBCInterpreter.class.getName() + ((Object)((Object)this)).hashCode();
        return this.isConcurrentExecution() ? SchedulerFactory.singleton().createOrGetParallelScheduler(schedulerName, this.getMaxConcurrentConnection()) : SchedulerFactory.singleton().createOrGetFIFOScheduler(schedulerName);
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) throws InterpreterException {
        ArrayList<InterpreterCompletion> candidates = new ArrayList<InterpreterCompletion>();
        String propertyKey = this.getPropertyKey(buf);
        String sqlCompleterKey = String.format("%s.%s", interpreterContext.getAuthenticationInfo().getUser(), propertyKey);
        SqlCompleter sqlCompleter = this.sqlCompletersMap.get(sqlCompleterKey);
        Connection connection = null;
        try {
            if (interpreterContext != null) {
                connection = this.getConnection(propertyKey, interpreterContext);
            }
        }
        catch (IOException | ClassNotFoundException | SQLException e) {
            this.logger.warn("SQLCompleter will created without use connection");
        }
        sqlCompleter = this.createOrUpdateSqlCompleter(sqlCompleter, connection, propertyKey, buf, cursor);
        this.sqlCompletersMap.put(sqlCompleterKey, sqlCompleter);
        sqlCompleter.complete(buf, cursor, candidates);
        return candidates;
    }

    public int getMaxResult() {
        return this.maxLineResults;
    }

    boolean isConcurrentExecution() {
        return Boolean.valueOf(this.getProperty("zeppelin.jdbc.concurrent.use"));
    }

    int getMaxConcurrentConnection() {
        try {
            return Integer.valueOf(this.getProperty("zeppelin.jdbc.concurrent.max_connection"));
        }
        catch (Exception e) {
            return 10;
        }
    }
}

