/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.server;

import com.codahale.metrics.servlets.HealthCheckServlet;
import com.codahale.metrics.servlets.PingServlet;
import com.google.gson.Gson;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.jetty.InstrumentedQueuedThreadPool;
import io.micrometer.core.instrument.binder.jetty.JettyConnectionMetrics;
import io.micrometer.core.instrument.binder.jetty.JettySslHandshakeMetrics;
import io.micrometer.core.instrument.binder.jetty.TimedHandler;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.FileDescriptorMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import io.micrometer.jmx.JmxConfig;
import io.micrometer.jmx.JmxMeterRegistry;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.management.remote.JMXServiceURL;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.web.env.EnvironmentLoaderListener;
import org.apache.shiro.web.servlet.ShiroFilter;
import org.apache.zeppelin.cluster.ClusterManagerServer;
import org.apache.zeppelin.cluster.event.ClusterEventListener;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.display.AngularObjectRegistryListener;
import org.apache.zeppelin.healthcheck.HealthChecks;
import org.apache.zeppelin.helium.ApplicationEventListener;
import org.apache.zeppelin.helium.Helium;
import org.apache.zeppelin.helium.HeliumApplicationFactory;
import org.apache.zeppelin.helium.HeliumBundleFactory;
import org.apache.zeppelin.interpreter.InterpreterFactory;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.interpreter.InterpreterSettingManager;
import org.apache.zeppelin.interpreter.recovery.RecoveryStorage;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcessListener;
import org.apache.zeppelin.metric.JVMInfoBinder;
import org.apache.zeppelin.metric.PrometheusServlet;
import org.apache.zeppelin.notebook.AuthorizationService;
import org.apache.zeppelin.notebook.NoteEventListener;
import org.apache.zeppelin.notebook.NoteManager;
import org.apache.zeppelin.notebook.Notebook;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.notebook.repo.NotebookRepo;
import org.apache.zeppelin.notebook.repo.NotebookRepoSync;
import org.apache.zeppelin.notebook.scheduler.NoSchedulerService;
import org.apache.zeppelin.notebook.scheduler.QuartzSchedulerService;
import org.apache.zeppelin.notebook.scheduler.SchedulerService;
import org.apache.zeppelin.plugin.PluginManager;
import org.apache.zeppelin.rest.exception.WebApplicationExceptionMapper;
import org.apache.zeppelin.search.LuceneSearch;
import org.apache.zeppelin.search.NoSearchService;
import org.apache.zeppelin.search.SearchService;
import org.apache.zeppelin.server.CorsFilter;
import org.apache.zeppelin.server.ErrorData;
import org.apache.zeppelin.server.GsonProvider;
import org.apache.zeppelin.server.ImmediateErrorHandlerImpl;
import org.apache.zeppelin.server.IndexHtmlServlet;
import org.apache.zeppelin.server.RestApiApplication;
import org.apache.zeppelin.service.AdminService;
import org.apache.zeppelin.service.AuthenticationService;
import org.apache.zeppelin.service.ConfigurationService;
import org.apache.zeppelin.service.InterpreterService;
import org.apache.zeppelin.service.JobManagerService;
import org.apache.zeppelin.service.NoAuthenticationService;
import org.apache.zeppelin.service.NotebookService;
import org.apache.zeppelin.service.ServiceCallback;
import org.apache.zeppelin.service.ServiceContext;
import org.apache.zeppelin.service.ShiroAuthenticationService;
import org.apache.zeppelin.socket.ConnectionManager;
import org.apache.zeppelin.socket.NotebookServer;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.apache.zeppelin.user.Credentials;
import org.apache.zeppelin.util.ReflectionUtils;
import org.apache.zeppelin.utils.PEMImporter;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.jmx.ConnectorServer;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.glassfish.hk2.api.Immediate;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeppelinServer {
    private static final Logger LOG = LoggerFactory.getLogger(ZeppelinServer.class);
    private static final String WEB_APP_CONTEXT_NEXT = "/next";
    public static final String SERVICE_LOCATOR_NAME = "shared-locator";

    @Inject
    public ZeppelinServer(ZeppelinConfiguration conf) {
        LOG.info("Instantiated ZeppelinServer");
        InterpreterOutput.LIMIT = conf.getInt(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_OUTPUT_LIMIT);
    }

    public static void main(String[] args) throws IOException {
        final ZeppelinConfiguration conf = ZeppelinConfiguration.create();
        Server jettyWebServer = ZeppelinServer.setupJettyServer(conf);
        PrometheusMeterRegistry promMetricRegistry = null;
        if (conf.isPrometheusMetricEnabled()) {
            promMetricRegistry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
            Metrics.addRegistry((MeterRegistry)promMetricRegistry);
        }
        ZeppelinServer.initMetrics(conf);
        TimedHandler timedHandler = new TimedHandler((MeterRegistry)Metrics.globalRegistry, (Iterable)Tags.empty());
        jettyWebServer.setHandler((Handler)timedHandler);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        timedHandler.setHandler((Handler)contexts);
        ServiceLocator sharedServiceLocator = ServiceLocatorFactory.getInstance().create(SERVICE_LOCATOR_NAME);
        ServiceLocatorUtilities.enableImmediateScope((ServiceLocator)sharedServiceLocator);
        ServiceLocatorUtilities.addClasses((ServiceLocator)sharedServiceLocator, (Class[])new Class[]{NotebookRepoSync.class, ImmediateErrorHandlerImpl.class});
        ImmediateErrorHandlerImpl handler = (ImmediateErrorHandlerImpl)sharedServiceLocator.getService(ImmediateErrorHandlerImpl.class, new Annotation[0]);
        ServiceLocatorUtilities.bind((ServiceLocator)sharedServiceLocator, (Binder[])new Binder[]{new AbstractBinder(){

            protected void configure() {
                Credentials credentials = new Credentials(conf);
                this.bindAsContract(InterpreterFactory.class).in(Singleton.class);
                this.bindAsContract(NotebookRepoSync.class).to(NotebookRepo.class).in(Immediate.class);
                this.bindAsContract(Helium.class).in(Singleton.class);
                this.bind(conf).to(ZeppelinConfiguration.class);
                this.bindAsContract(InterpreterSettingManager.class).in(Singleton.class);
                this.bindAsContract(InterpreterService.class).in(Singleton.class);
                this.bind(credentials).to(Credentials.class);
                this.bindAsContract(GsonProvider.class).in(Singleton.class);
                this.bindAsContract(WebApplicationExceptionMapper.class).in(Singleton.class);
                this.bindAsContract(AdminService.class).in(Singleton.class);
                this.bindAsContract(AuthorizationService.class).in(Singleton.class);
                this.bindAsContract(ConnectionManager.class).in(Singleton.class);
                this.bindAsContract(NoteManager.class).in(Singleton.class);
                if (!StringUtils.isBlank((CharSequence)conf.getShiroPath())) {
                    this.bind(ShiroAuthenticationService.class).to(AuthenticationService.class).in(Singleton.class);
                } else {
                    this.bind(NoAuthenticationService.class).to(AuthenticationService.class).in(Singleton.class);
                }
                this.bindAsContract(HeliumBundleFactory.class).in(Singleton.class);
                this.bindAsContract(HeliumApplicationFactory.class).in(Singleton.class);
                this.bindAsContract(ConfigurationService.class).in(Singleton.class);
                this.bindAsContract(NotebookService.class).in(Singleton.class);
                this.bindAsContract(JobManagerService.class).in(Singleton.class);
                this.bindAsContract(Notebook.class).in(Singleton.class);
                this.bindAsContract(NotebookServer.class).to(AngularObjectRegistryListener.class).to(RemoteInterpreterProcessListener.class).to(ApplicationEventListener.class).to(NoteEventListener.class).to(WebSocketServlet.class).in(Singleton.class);
                if (conf.isZeppelinNotebookCronEnable()) {
                    this.bind(QuartzSchedulerService.class).to(SchedulerService.class).in(Singleton.class);
                } else {
                    this.bind(NoSchedulerService.class).to(SchedulerService.class).in(Singleton.class);
                }
                if (conf.getBoolean(ZeppelinConfiguration.ConfVars.ZEPPELIN_SEARCH_ENABLE)) {
                    this.bind(LuceneSearch.class).to(SearchService.class).in(Singleton.class);
                } else {
                    this.bind(NoSearchService.class).to(SearchService.class).in(Singleton.class);
                }
            }
        }});
        WebAppContext defaultWebApp = ZeppelinServer.setupWebAppContext(contexts, conf, conf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_WAR), conf.getServerContextPath());
        WebAppContext nextWebApp = ZeppelinServer.setupWebAppContext(contexts, conf, conf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_ANGULAR_WAR), WEB_APP_CONTEXT_NEXT);
        ZeppelinServer.initWebApp(defaultWebApp, conf, sharedServiceLocator, promMetricRegistry);
        ZeppelinServer.initWebApp(nextWebApp, conf, sharedServiceLocator, promMetricRegistry);
        ZeppelinServer.setupClusterManagerServer(sharedServiceLocator, conf);
        if (conf.isJMXEnabled()) {
            int port = conf.getJMXPort();
            MBeanContainer mbeanContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
            jettyWebServer.addBean((Object)mbeanContainer);
            JMXServiceURL jmxURL = new JMXServiceURL(String.format("service:jmx:rmi://0.0.0.0:%d/jndi/rmi://0.0.0.0:%d/jmxrmi", port, port));
            ConnectorServer jmxServer = new ConnectorServer(jmxURL, "org.eclipse.jetty.jmx:name=rmiconnectorserver");
            jettyWebServer.addBean((Object)jmxServer);
            LOG.info("JMX Enabled with port: {}", (Object)port);
        }
        ZeppelinServer.runNoteOnStart(conf, jettyWebServer, sharedServiceLocator);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ZeppelinServer.shutdown(conf, jettyWebServer, sharedServiceLocator)));
        Notebook notebook = (Notebook)ServiceLocatorUtilities.getService((ServiceLocator)sharedServiceLocator, (String)Notebook.class.getName());
        ServiceLocatorUtilities.getService((ServiceLocator)sharedServiceLocator, (String)SearchService.class.getName());
        ServiceLocatorUtilities.getService((ServiceLocator)sharedServiceLocator, (String)SchedulerService.class.getName());
        notebook.initNotebook();
        notebook.recoveryIfNecessary();
        LOG.info("Starting zeppelin server");
        try {
            jettyWebServer.start();
            if (conf.getJettyName() != null) {
                HttpGenerator.setJettyVersion((String)conf.getJettyName());
            }
        }
        catch (Exception e) {
            LOG.error("Error while running jettyServer", (Throwable)e);
            System.exit(-1);
        }
        LOG.info("Done, zeppelin server started");
        try {
            List<ErrorData> errorDatas = handler.waitForAtLeastOneConstructionError(5000L);
            for (ErrorData errorData : errorDatas) {
                LOG.error("Error in Construction", errorData.getThrowable());
            }
            if (!errorDatas.isEmpty()) {
                LOG.error("{} error(s) while starting - Termination", (Object)errorDatas.size());
                System.exit(-1);
            }
        }
        catch (InterruptedException e) {
            LOG.error("Interrupt while waiting for construction errors - init shutdown", (Throwable)e);
            ZeppelinServer.shutdown(conf, jettyWebServer, sharedServiceLocator);
            Thread.currentThread().interrupt();
        }
        if (jettyWebServer.isStopped() || jettyWebServer.isStopping()) {
            LOG.debug("jetty server is stopped {} - is stopping {}", (Object)jettyWebServer.isStopped(), (Object)jettyWebServer.isStopping());
        } else {
            try {
                jettyWebServer.join();
            }
            catch (InterruptedException e) {
                LOG.error("Interrupt while waiting for jetty threads - init shutdown", (Throwable)e);
                ZeppelinServer.shutdown(conf, jettyWebServer, sharedServiceLocator);
                Thread.currentThread().interrupt();
            }
        }
        if (!conf.isRecoveryEnabled()) {
            ((InterpreterSettingManager)sharedServiceLocator.getService(InterpreterSettingManager.class, new Annotation[0])).close();
        }
    }

    private static void initMetrics(ZeppelinConfiguration conf) {
        if (conf.isJMXEnabled()) {
            Metrics.addRegistry((MeterRegistry)new JmxMeterRegistry(JmxConfig.DEFAULT, Clock.SYSTEM));
        }
        new ClassLoaderMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new JvmMemoryMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new JvmThreadMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new FileDescriptorMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new ProcessorMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new UptimeMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new JVMInfoBinder().bindTo((MeterRegistry)Metrics.globalRegistry);
    }

    private static void shutdown(ZeppelinConfiguration conf, Server jettyWebServer, ServiceLocator sharedServiceLocator) {
        LOG.info("Shutting down Zeppelin Server ... ");
        try {
            if (jettyWebServer != null) {
                jettyWebServer.stop();
            }
            if (sharedServiceLocator != null) {
                if (!conf.isRecoveryEnabled()) {
                    ((InterpreterSettingManager)sharedServiceLocator.getService(InterpreterSettingManager.class, new Annotation[0])).close();
                }
                ((Notebook)sharedServiceLocator.getService(Notebook.class, new Annotation[0])).close();
            }
        }
        catch (Exception e) {
            LOG.error("Error while stopping servlet container", (Throwable)e);
        }
        LOG.info("Bye");
    }

    private static Server setupJettyServer(ZeppelinConfiguration conf) {
        InstrumentedQueuedThreadPool threadPool = new InstrumentedQueuedThreadPool((MeterRegistry)Metrics.globalRegistry, (Iterable)Tags.empty(), conf.getInt(ZeppelinConfiguration.ConfVars.ZEPPELIN_SERVER_JETTY_THREAD_POOL_MAX), conf.getInt(ZeppelinConfiguration.ConfVars.ZEPPELIN_SERVER_JETTY_THREAD_POOL_MIN), conf.getInt(ZeppelinConfiguration.ConfVars.ZEPPELIN_SERVER_JETTY_THREAD_POOL_TIMEOUT));
        Server server = new Server((ThreadPool)threadPool);
        ZeppelinServer.initServerConnector(server, conf);
        return server;
    }

    private static void initServerConnector(Server server, ZeppelinConfiguration conf) {
        ServerConnector connector;
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
        httpConfig.setSendServerVersion(conf.sendJettyName());
        httpConfig.setRequestHeaderSize(conf.getJettyRequestHeaderSize().intValue());
        if (conf.useSsl()) {
            LOG.debug("Enabling SSL for Zeppelin Server on port {}", (Object)conf.getServerSslPort());
            httpConfig.setSecureScheme(HttpScheme.HTTPS.asString());
            httpConfig.setSecurePort(conf.getServerSslPort());
            HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
            httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(ZeppelinServer.getSslContextFactory(conf), HttpVersion.HTTP_1_1.asString());
            HttpConnectionFactory httpsConnectionFactory = new HttpConnectionFactory(httpsConfig);
            connector = new ServerConnector(server, new ConnectionFactory[]{sslConnectionFactory, httpsConnectionFactory});
            connector.setPort(conf.getServerSslPort());
            connector.addBean((Object)new JettySslHandshakeMetrics((MeterRegistry)Metrics.globalRegistry, (Iterable)Tags.empty()));
        } else {
            HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpConfig);
            connector = new ServerConnector(server, new ConnectionFactory[]{httpConnectionFactory});
            connector.setPort(conf.getServerPort());
        }
        int timeout = 30000;
        connector.setIdleTimeout((long)timeout);
        connector.setHost(conf.getServerAddress());
        connector.addBean((Object)new JettyConnectionMetrics((MeterRegistry)Metrics.globalRegistry, (Iterable)Tags.empty()));
        server.addConnector((Connector)connector);
    }

    private static void runNoteOnStart(ZeppelinConfiguration conf, Server jettyWebServer, ServiceLocator sharedServiceLocator) throws IOException {
        String noteIdToRun = conf.getNotebookRunId();
        if (!StringUtils.isEmpty((CharSequence)noteIdToRun)) {
            ServiceContext serviceContext;
            LOG.info("Running note {} on start", (Object)noteIdToRun);
            NotebookService notebookService = (NotebookService)ServiceLocatorUtilities.getService((ServiceLocator)sharedServiceLocator, (String)NotebookService.class.getName());
            String base64EncodedJsonSerializedServiceContext = conf.getNotebookRunServiceContext();
            if (StringUtils.isEmpty((CharSequence)base64EncodedJsonSerializedServiceContext)) {
                LOG.info("No service context provided. use ANONYMOUS");
                serviceContext = new ServiceContext(AuthenticationInfo.ANONYMOUS, (Set<String>)new HashSet<String>(){});
            } else {
                serviceContext = (ServiceContext)new Gson().fromJson(new String(Base64.getDecoder().decode(base64EncodedJsonSerializedServiceContext)), ServiceContext.class);
            }
            boolean success = notebookService.runAllParagraphs(noteIdToRun, null, serviceContext, new ServiceCallback<Paragraph>(){

                @Override
                public void onStart(String message, ServiceContext context) throws IOException {
                }

                @Override
                public void onSuccess(Paragraph result, ServiceContext context) throws IOException {
                }

                @Override
                public void onFailure(Exception ex, ServiceContext context) throws IOException {
                }
            });
            if (conf.getNotebookRunAutoShutdown()) {
                ZeppelinServer.shutdown(conf, jettyWebServer, sharedServiceLocator);
                System.exit(success ? 0 : 1);
            }
        }
    }

    private static void setupNotebookServer(WebAppContext webapp, ZeppelinConfiguration conf) {
        String maxTextMessageSize = conf.getWebsocketMaxTextMessageSize();
        WebSocketServerContainerInitializer.configure((ServletContextHandler)webapp, (servletContext, wsContainer) -> {
            wsContainer.setDefaultMaxTextMessageBufferSize(Integer.parseInt(maxTextMessageSize));
            wsContainer.addEndpoint(NotebookServer.class);
        });
    }

    private static void setupClusterManagerServer(ServiceLocator serviceLocator, ZeppelinConfiguration conf) {
        if (conf.isClusterMode()) {
            LOG.info("Cluster mode is enabled, starting ClusterManagerServer");
            ClusterManagerServer clusterManagerServer = ClusterManagerServer.getInstance((ZeppelinConfiguration)conf);
            NotebookServer notebookServer = (NotebookServer)serviceLocator.getService(NotebookServer.class, new Annotation[0]);
            clusterManagerServer.addClusterEventListeners(ClusterManagerServer.CLUSTER_NOTE_EVENT_TOPIC, (ClusterEventListener)notebookServer);
            AuthorizationService authorizationService = (AuthorizationService)serviceLocator.getService(AuthorizationService.class, new Annotation[0]);
            clusterManagerServer.addClusterEventListeners(ClusterManagerServer.CLUSTER_AUTH_EVENT_TOPIC, (ClusterEventListener)authorizationService);
            InterpreterSettingManager interpreterSettingManager = (InterpreterSettingManager)serviceLocator.getService(InterpreterSettingManager.class, new Annotation[0]);
            clusterManagerServer.addClusterEventListeners(ClusterManagerServer.CLUSTER_INTP_SETTING_EVENT_TOPIC, (ClusterEventListener)interpreterSettingManager);
            try {
                InterpreterSettingManager intpSettingManager = (InterpreterSettingManager)serviceLocator.getService(InterpreterSettingManager.class, new Annotation[0]);
                RecoveryStorage recoveryStorage = (RecoveryStorage)ReflectionUtils.createClazzInstance((String)conf.getRecoveryStorageClass(), (Class[])new Class[]{ZeppelinConfiguration.class, InterpreterSettingManager.class}, (Object[])new Object[]{conf, intpSettingManager});
                recoveryStorage.init();
                PluginManager.get().loadInterpreterLauncher("ClusterInterpreterLauncher", recoveryStorage);
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            clusterManagerServer.start();
        } else {
            LOG.info("Cluster mode is disabled");
        }
    }

    private static SslContextFactory getSslContextFactory(ZeppelinConfiguration conf) {
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{conf.getPemKeyFile(), conf.getPemCertFile()})) {
            ZeppelinServer.setupKeystoreWithPemFiles(sslContextFactory, conf);
        } else {
            sslContextFactory.setKeyStorePath(conf.getKeyStorePath());
            sslContextFactory.setKeyStoreType(conf.getKeyStoreType());
            sslContextFactory.setKeyStorePassword(conf.getKeyStorePassword());
            sslContextFactory.setKeyManagerPassword(conf.getKeyManagerPassword());
        }
        if (conf.useClientAuth()) {
            if (StringUtils.isNotBlank((CharSequence)conf.getPemCAFile())) {
                ZeppelinServer.setupTruststoreWithPemFiles(sslContextFactory, conf);
            } else {
                sslContextFactory.setNeedClientAuth(conf.useClientAuth());
                sslContextFactory.setTrustStorePath(conf.getTrustStorePath());
                sslContextFactory.setTrustStoreType(conf.getTrustStoreType());
                sslContextFactory.setTrustStorePassword(conf.getTrustStorePassword());
            }
        }
        return sslContextFactory;
    }

    private static void setupKeystoreWithPemFiles(SslContextFactory.Server sslContextFactory, ZeppelinConfiguration conf) {
        File pemKey = new File(conf.getPemKeyFile());
        File pemCert = new File(conf.getPemCertFile());
        boolean isPemKeyFileReadable = Files.isReadable(pemKey.toPath());
        boolean isPemCertFileReadable = Files.isReadable(pemCert.toPath());
        if (!isPemKeyFileReadable) {
            LOG.warn("PEM key file {} is not readable", (Object)pemKey);
        }
        if (!isPemCertFileReadable) {
            LOG.warn("PEM cert file {} is not readable", (Object)pemCert);
        }
        if (isPemKeyFileReadable && isPemCertFileReadable) {
            try {
                String password = conf.getPemKeyPassword();
                sslContextFactory.setKeyStore(PEMImporter.loadKeyStore(pemCert, pemKey, password));
                sslContextFactory.setKeyStoreType("JKS");
                sslContextFactory.setKeyStorePassword(password);
            }
            catch (IOException | GeneralSecurityException e) {
                LOG.error("Failed to initialize KeyStore from PEM files", (Throwable)e);
            }
        } else {
            LOG.error("Failed to read PEM files");
        }
    }

    private static void setupTruststoreWithPemFiles(SslContextFactory.Server sslContextFactory, ZeppelinConfiguration conf) {
        File pemCa = new File(conf.getPemCAFile());
        if (Files.isReadable(pemCa.toPath())) {
            try {
                sslContextFactory.setTrustStore(PEMImporter.loadTrustStore(pemCa));
                sslContextFactory.setTrustStoreType("JKS");
                sslContextFactory.setTrustStorePassword("");
                sslContextFactory.setNeedClientAuth(conf.useClientAuth());
            }
            catch (IOException | GeneralSecurityException e) {
                LOG.error("Failed to initialize TrustStore from PEM CA file", (Throwable)e);
            }
        } else {
            LOG.error("PEM CA file {} is not readable", (Object)pemCa);
        }
    }

    private static void setupRestApiContextHandler(WebAppContext webapp, ZeppelinConfiguration conf) {
        ServletHolder servletHolder = new ServletHolder((Servlet)new ServletContainer());
        servletHolder.setInitParameter("javax.ws.rs.Application", RestApiApplication.class.getName());
        servletHolder.setName("rest");
        webapp.addServlet(servletHolder, "/api/*");
        String shiroIniPath = conf.getShiroPath();
        if (!StringUtils.isBlank((CharSequence)shiroIniPath)) {
            webapp.setInitParameter("shiroConfigLocations", new File(shiroIniPath).toURI().toString());
            webapp.addFilter(ShiroFilter.class, "/api/*", EnumSet.allOf(DispatcherType.class)).setInitParameter("staticSecurityManagerEnabled", "true");
            webapp.addEventListener((EventListener)new EnvironmentLoaderListener());
        }
    }

    private static void setupPrometheusContextHandler(WebAppContext webapp, PrometheusMeterRegistry promMetricRegistry) {
        webapp.addServlet(new ServletHolder((Servlet)new PrometheusServlet(promMetricRegistry)), "/metrics");
    }

    private static void setupHealthCheckContextHandler(WebAppContext webapp) {
        webapp.addServlet(new ServletHolder((Servlet)new HealthCheckServlet(HealthChecks.getHealthCheckReadinessRegistry())), "/health/readiness");
        webapp.addServlet(new ServletHolder((Servlet)new HealthCheckServlet(HealthChecks.getHealthCheckLivenessRegistry())), "/health/liveness");
        webapp.addServlet(new ServletHolder((Servlet)new PingServlet()), "/ping");
    }

    private static WebAppContext setupWebAppContext(ContextHandlerCollection contexts, ZeppelinConfiguration conf, String warPath, String contextPath) {
        WebAppContext webApp = new WebAppContext();
        webApp.setContextPath(contextPath);
        LOG.info("warPath is: {}", (Object)warPath);
        File warFile = new File(warPath);
        if (warFile.isDirectory()) {
            webApp.setResourceBase(warFile.getPath());
        } else {
            webApp.setWar(warFile.getAbsolutePath());
            webApp.setExtractWAR(false);
            File warTempDirectory = new File(conf.getAbsoluteDir(ZeppelinConfiguration.ConfVars.ZEPPELIN_WAR_TEMPDIR) + contextPath);
            warTempDirectory.mkdir();
            LOG.info("ZeppelinServer Webapp path: {}", (Object)warTempDirectory.getPath());
            webApp.setTempDirectory(warTempDirectory);
        }
        webApp.addServlet(new ServletHolder((Servlet)new IndexHtmlServlet(conf)), "/index.html");
        contexts.addHandler((Handler)webApp);
        webApp.addFilter(new FilterHolder(CorsFilter.class), "/*", EnumSet.allOf(DispatcherType.class));
        webApp.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", Boolean.toString(conf.getBoolean(ZeppelinConfiguration.ConfVars.ZEPPELIN_SERVER_DEFAULT_DIR_ALLOWED)));
        return webApp;
    }

    private static void initWebApp(WebAppContext webApp, ZeppelinConfiguration conf, final ServiceLocator sharedServiceLocator, PrometheusMeterRegistry promMetricRegistry) {
        webApp.addEventListener((EventListener)new ServletContextListener(){

            public void contextInitialized(ServletContextEvent servletContextEvent) {
                servletContextEvent.getServletContext().setAttribute("jersey.config.servlet.context.serviceLocator", (Object)sharedServiceLocator);
            }

            public void contextDestroyed(ServletContextEvent servletContextEvent) {
            }
        });
        ZeppelinServer.setupRestApiContextHandler(webApp, conf);
        if (promMetricRegistry != null) {
            ZeppelinServer.setupPrometheusContextHandler(webApp, promMetricRegistry);
        }
        ZeppelinServer.setupHealthCheckContextHandler(webApp);
        ZeppelinServer.setupNotebookServer(webApp, conf);
    }
}

