/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.socket;

import java.io.IOException;
import java.util.Map;
import javax.websocket.Session;
import org.apache.zeppelin.utils.ServerUtils;

public class NotebookSocket {
    private Session session;
    private Map<String, Object> headers;
    private String user;

    public NotebookSocket(Session session, Map<String, Object> headers) {
        this.session = session;
        this.headers = headers;
        this.user = "";
    }

    public String getHeader(String key) {
        return String.valueOf(this.headers.get(key));
    }

    public void send(String serializeMessage) throws IOException {
        this.session.getBasicRemote().sendText(serializeMessage);
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String toString() {
        return ServerUtils.getRemoteAddress(this.session);
    }
}

