/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.shell;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellInterpreter
extends Interpreter {
    Logger logger = LoggerFactory.getLogger(ShellInterpreter.class);
    private static final String EXECUTOR_KEY = "executor";
    public static final String SHELL_COMMAND_TIMEOUT = "shell.command.timeout.millisecs";
    int commandTimeOut;
    private static final boolean isWindows = System.getProperty("os.name").startsWith("Windows");
    final String shell = isWindows ? "cmd /c" : "bash -c";

    public ShellInterpreter(Properties property) {
        super(property);
    }

    public void open() {
        this.logger.info("Command timeout is set as:", (Object)SHELL_COMMAND_TIMEOUT);
        this.commandTimeOut = Integer.valueOf(this.getProperty(SHELL_COMMAND_TIMEOUT));
    }

    public void close() {
    }

    public InterpreterResult interpret(String cmd, InterpreterContext contextInterpreter) {
        this.logger.debug("Run shell command '" + cmd + "'");
        CommandLine cmdLine = CommandLine.parse((String)this.shell);
        if (isWindows) {
            Object[] lines = StringUtils.split((String)cmd, (String)"\n");
            cmd = StringUtils.join((Object[])lines, (String)" && ");
        }
        cmdLine.addArgument(cmd, false);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)contextInterpreter.out, (OutputStream)contextInterpreter.out));
        executor.setWatchdog(new ExecuteWatchdog((long)this.commandTimeOut));
        Job runningJob = this.getRunningJob(contextInterpreter.getParagraphId());
        Map info = runningJob.info();
        info.put(EXECUTOR_KEY, executor);
        try {
            int exitVal = executor.execute(cmdLine);
            this.logger.info("Paragraph " + contextInterpreter.getParagraphId() + "return with exit value: " + exitVal);
            return new InterpreterResult(InterpreterResult.Code.SUCCESS, null);
        }
        catch (ExecuteException e) {
            int exitValue = e.getExitValue();
            this.logger.error("Can not run " + cmd, (Throwable)e);
            InterpreterResult.Code code = InterpreterResult.Code.ERROR;
            String msg = null;
            try {
                contextInterpreter.out.flush();
                msg = new String(contextInterpreter.out.toByteArray());
            }
            catch (IOException e1) {
                this.logger.error(e1.getMessage());
                msg = e1.getMessage();
            }
            if (exitValue == 143) {
                code = InterpreterResult.Code.INCOMPLETE;
                msg = msg + "Paragraph received a SIGTERM.\n";
                this.logger.info("The paragraph " + contextInterpreter.getParagraphId() + " stopped executing: " + msg);
            }
            msg = msg + "ExitValue: " + exitValue;
            return new InterpreterResult(code, msg);
        }
        catch (IOException e) {
            this.logger.error("Can not run " + cmd, (Throwable)e);
            return new InterpreterResult(InterpreterResult.Code.ERROR, e.getMessage());
        }
    }

    private Job getRunningJob(String paragraphId) {
        Job foundJob = null;
        Collection jobsRunning = this.getScheduler().getJobsRunning();
        for (Job job : jobsRunning) {
            if (!job.getId().equals(paragraphId)) continue;
            foundJob = job;
        }
        return foundJob;
    }

    public void cancel(InterpreterContext context) {
        Map info;
        Object object;
        Job runningJob = this.getRunningJob(context.getParagraphId());
        if (runningJob != null && (object = (info = runningJob.info()).get(EXECUTOR_KEY)) != null) {
            Executor executor = (Executor)object;
            ExecuteWatchdog watchdog = executor.getWatchdog();
            watchdog.destroyProcess();
        }
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.SIMPLE;
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }

    public Scheduler getScheduler() {
        return SchedulerFactory.singleton().createOrGetParallelScheduler(ShellInterpreter.class.getName() + ((Object)((Object)this)).hashCode(), 10);
    }

    public List<InterpreterCompletion> completion(String buf, int cursor) {
        return null;
    }
}

