/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.zeppelin.annotation.Experimental;
import org.apache.zeppelin.annotation.ZeppelinApi;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterHookRegistry;
import org.apache.zeppelin.interpreter.InterpreterOption;
import org.apache.zeppelin.interpreter.InterpreterProperty;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterRunner;
import org.apache.zeppelin.interpreter.WrappedInterpreter;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Interpreter {
    public static Logger logger = LoggerFactory.getLogger(Interpreter.class);
    private InterpreterGroup interpreterGroup;
    private URL[] classloaderUrls;
    protected Properties property;
    private String userName;
    public static Map<String, RegisteredInterpreter> registeredInterpreters = Collections.synchronizedMap(new HashMap());

    @ZeppelinApi
    public abstract void open();

    @ZeppelinApi
    public abstract void close();

    @ZeppelinApi
    public abstract InterpreterResult interpret(String var1, InterpreterContext var2);

    @ZeppelinApi
    public abstract void cancel(InterpreterContext var1);

    @ZeppelinApi
    public abstract FormType getFormType();

    @ZeppelinApi
    public abstract int getProgress(InterpreterContext var1);

    @ZeppelinApi
    public List<InterpreterCompletion> completion(String buf, int cursor) {
        return null;
    }

    @ZeppelinApi
    public Scheduler getScheduler() {
        return SchedulerFactory.singleton().createOrGetFIFOScheduler("interpreter_" + this.hashCode());
    }

    @ZeppelinApi
    public Interpreter(Properties property) {
        logger.debug("Properties: {}", (Object)property);
        this.property = property;
    }

    public void setProperty(Properties property) {
        this.property = property;
    }

    @ZeppelinApi
    public Properties getProperty() {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)this.property);
        RegisteredInterpreter registeredInterpreter = Interpreter.findRegisteredInterpreterByClassName(this.getClassName());
        if (null != registeredInterpreter) {
            Map<String, InterpreterProperty> defaultProperties = registeredInterpreter.getProperties();
            for (String k : defaultProperties.keySet()) {
                String value;
                if (p.containsKey(k) || (value = defaultProperties.get(k).getValue()) == null) continue;
                p.put(k, defaultProperties.get(k).getValue());
            }
        }
        return p;
    }

    @ZeppelinApi
    public String getProperty(String key) {
        logger.debug("key: {}, value: {}", (Object)key, (Object)this.getProperty().getProperty(key));
        return this.getProperty().getProperty(key);
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setInterpreterGroup(InterpreterGroup interpreterGroup) {
        this.interpreterGroup = interpreterGroup;
    }

    @ZeppelinApi
    public InterpreterGroup getInterpreterGroup() {
        return this.interpreterGroup;
    }

    public URL[] getClassloaderUrls() {
        return this.classloaderUrls;
    }

    public void setClassloaderUrls(URL[] classloaderUrls) {
        this.classloaderUrls = classloaderUrls;
    }

    @Experimental
    public void registerHook(String noteId, String event, String cmd) {
        InterpreterHookRegistry hooks = this.interpreterGroup.getInterpreterHookRegistry();
        String className = this.getClassName();
        hooks.register(noteId, className, event, cmd);
    }

    @Experimental
    public void registerHook(String event, String cmd) {
        this.registerHook(null, event, cmd);
    }

    @Experimental
    public String getHook(String noteId, String event) {
        InterpreterHookRegistry hooks = this.interpreterGroup.getInterpreterHookRegistry();
        String className = this.getClassName();
        return hooks.get(noteId, className, event);
    }

    @Experimental
    public String getHook(String event) {
        return this.getHook(null, event);
    }

    @Experimental
    public void unregisterHook(String noteId, String event) {
        InterpreterHookRegistry hooks = this.interpreterGroup.getInterpreterHookRegistry();
        String className = this.getClassName();
        hooks.unregister(noteId, className, event);
    }

    @Experimental
    public void unregisterHook(String event) {
        this.unregisterHook(null, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ZeppelinApi
    public Interpreter getInterpreterInTheSameSessionByClassName(String className) {
        InterpreterGroup interpreterGroup = this.interpreterGroup;
        synchronized (interpreterGroup) {
            for (List interpreters : this.interpreterGroup.values()) {
                boolean belongsToSameNoteGroup = false;
                Interpreter interpreterFound = null;
                for (Interpreter intp : interpreters) {
                    if (intp.getClassName().equals(className)) {
                        interpreterFound = intp;
                    }
                    Interpreter p = intp;
                    while (p instanceof WrappedInterpreter) {
                        p = ((WrappedInterpreter)((Object)p)).getInnerInterpreter();
                    }
                    if (this != p) continue;
                    belongsToSameNoteGroup = true;
                }
                if (!belongsToSameNoteGroup) continue;
                return interpreterFound;
            }
        }
        return null;
    }

    @Deprecated
    public static void register(String name, String group, String className, Map<String, InterpreterProperty> properties) {
        Interpreter.register(name, group, className, false, properties);
    }

    @Deprecated
    public static void register(String name, String group, String className, boolean defaultInterpreter, Map<String, InterpreterProperty> properties) {
        logger.warn("Static initialization is deprecated for interpreter {}, You should change it to use interpreter-setting.json in your jar or interpreter/{interpreter}/interpreter-setting.json", (Object)name);
        Interpreter.register(new RegisteredInterpreter(name, group, className, defaultInterpreter, properties));
    }

    @Deprecated
    public static void register(RegisteredInterpreter registeredInterpreter) {
        String interpreterKey = registeredInterpreter.getInterpreterKey();
        if (!registeredInterpreters.containsKey(interpreterKey)) {
            registeredInterpreters.put(interpreterKey, registeredInterpreter);
        } else {
            RegisteredInterpreter existInterpreter = registeredInterpreters.get(interpreterKey);
            if (!existInterpreter.getProperties().equals(registeredInterpreter.getProperties())) {
                logger.error("exist registeredInterpreter with the same key but has different settings.");
            }
        }
    }

    public static RegisteredInterpreter findRegisteredInterpreterByClassName(String className) {
        for (RegisteredInterpreter ri : registeredInterpreters.values()) {
            if (!ri.getClassName().equals(className)) continue;
            return ri;
        }
        return null;
    }

    public static enum SchedulingMode {
        FIFO,
        PARALLEL;

    }

    public static class RegisteredInterpreter {
        private String group;
        private String name;
        private String className;
        private boolean defaultInterpreter;
        private Map<String, InterpreterProperty> properties;
        private Map<String, Object> editor;
        private String path;
        private InterpreterOption option;
        private InterpreterRunner runner;

        public RegisteredInterpreter(String name, String group, String className, Map<String, InterpreterProperty> properties) {
            this(name, group, className, false, properties);
        }

        public RegisteredInterpreter(String name, String group, String className, boolean defaultInterpreter, Map<String, InterpreterProperty> properties) {
            this.name = name;
            this.group = group;
            this.className = className;
            this.defaultInterpreter = defaultInterpreter;
            this.properties = properties;
            this.editor = new HashMap<String, Object>();
        }

        public String getName() {
            return this.name;
        }

        public String getGroup() {
            return this.group;
        }

        public String getClassName() {
            return this.className;
        }

        public boolean isDefaultInterpreter() {
            return this.defaultInterpreter;
        }

        public void setDefaultInterpreter(boolean defaultInterpreter) {
            this.defaultInterpreter = defaultInterpreter;
        }

        public Map<String, InterpreterProperty> getProperties() {
            return this.properties;
        }

        public Map<String, Object> getEditor() {
            return this.editor;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public String getInterpreterKey() {
            return this.getGroup() + "." + this.getName();
        }

        public InterpreterOption getOption() {
            return this.option;
        }

        public InterpreterRunner getRunner() {
            return this.runner;
        }
    }

    public static enum FormType {
        NATIVE,
        SIMPLE,
        NONE;

    }
}

