/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterHookRegistry;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcess;
import org.apache.zeppelin.resource.ResourcePool;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterpreterGroup
extends ConcurrentHashMap<String, List<Interpreter>> {
    String id;
    private static final Logger LOGGER = LoggerFactory.getLogger(InterpreterGroup.class);
    AngularObjectRegistry angularObjectRegistry;
    InterpreterHookRegistry hookRegistry;
    RemoteInterpreterProcess remoteInterpreterProcess;
    ResourcePool resourcePool;
    boolean angularRegistryPushed = false;
    private static final Map<String, InterpreterGroup> allInterpreterGroups = new ConcurrentHashMap<String, InterpreterGroup>();

    public static InterpreterGroup getByInterpreterGroupId(String id) {
        return allInterpreterGroups.get(id);
    }

    public static Collection<InterpreterGroup> getAll() {
        return new LinkedList<InterpreterGroup>(allInterpreterGroups.values());
    }

    public InterpreterGroup(String id) {
        this.id = id;
        allInterpreterGroups.put(id, this);
    }

    public InterpreterGroup() {
        this.getId();
        allInterpreterGroups.put(this.id, this);
    }

    private static String generateId() {
        return "InterpreterGroup_" + System.currentTimeMillis() + "_" + new Random().nextInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getId() {
        InterpreterGroup interpreterGroup = this;
        synchronized (interpreterGroup) {
            if (this.id == null) {
                this.id = InterpreterGroup.generateId();
            }
            return this.id;
        }
    }

    public Properties getProperty() {
        Properties p = new Properties();
        Iterator iterator = this.values().iterator();
        if (iterator.hasNext()) {
            List intpGroupForASession = (List)iterator.next();
            for (Interpreter intp : intpGroupForASession) {
                p.putAll((Map<?, ?>)intp.getProperty());
            }
        }
        return p;
    }

    public AngularObjectRegistry getAngularObjectRegistry() {
        return this.angularObjectRegistry;
    }

    public void setAngularObjectRegistry(AngularObjectRegistry angularObjectRegistry) {
        this.angularObjectRegistry = angularObjectRegistry;
    }

    public InterpreterHookRegistry getInterpreterHookRegistry() {
        return this.hookRegistry;
    }

    public void setInterpreterHookRegistry(InterpreterHookRegistry hookRegistry) {
        this.hookRegistry = hookRegistry;
    }

    public RemoteInterpreterProcess getRemoteInterpreterProcess() {
        return this.remoteInterpreterProcess;
    }

    public void setRemoteInterpreterProcess(RemoteInterpreterProcess remoteInterpreterProcess) {
        this.remoteInterpreterProcess = remoteInterpreterProcess;
    }

    public void close() {
        LOGGER.info("Close interpreter group " + this.getId());
        LinkedList<Interpreter> intpToClose = new LinkedList<Interpreter>();
        for (List intpGroupForSession : this.values()) {
            intpToClose.addAll(intpGroupForSession);
        }
        this.close(intpToClose);
        if (this.remoteInterpreterProcess != null) {
            while (this.remoteInterpreterProcess.referenceCount() > 0) {
                this.remoteInterpreterProcess.dereference();
            }
            this.remoteInterpreterProcess = null;
        }
        allInterpreterGroups.remove(this.id);
    }

    public void close(String sessionId) {
        LOGGER.info("Close interpreter group " + this.getId() + " for session: " + sessionId);
        List intpForSession = (List)this.get(sessionId);
        this.close(intpForSession);
    }

    private void close(Collection<Interpreter> intpToClose) {
        this.close(null, null, null, intpToClose);
    }

    public void close(Map<String, InterpreterGroup> interpreterGroupRef, String processKey, String sessionKey) {
        LOGGER.info("Close interpreter group " + this.getId() + " for session: " + sessionKey);
        this.close(interpreterGroupRef, processKey, sessionKey, (Collection)this.get(sessionKey));
    }

    private void close(final Map<String, InterpreterGroup> interpreterGroupRef, final String processKey, final String sessionKey, final Collection<Interpreter> intpToClose) {
        if (intpToClose == null) {
            return;
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                for (Interpreter interpreter : intpToClose) {
                    Scheduler scheduler = interpreter.getScheduler();
                    interpreter.close();
                    if (null == scheduler) continue;
                    SchedulerFactory.singleton().removeScheduler(scheduler.getName());
                }
                if (InterpreterGroup.this.remoteInterpreterProcess != null && InterpreterGroup.this.remoteInterpreterProcess.referenceCount() <= 0) {
                    InterpreterGroup.this.remoteInterpreterProcess = null;
                    allInterpreterGroups.remove(InterpreterGroup.this.id);
                }
                if (null != interpreterGroupRef && null != processKey && null != sessionKey) {
                    InterpreterGroup interpreterGroup = (InterpreterGroup)interpreterGroupRef.get(processKey);
                    if (1 == interpreterGroup.size() && interpreterGroup.containsKey(sessionKey)) {
                        interpreterGroupRef.remove(processKey);
                    } else {
                        interpreterGroup.remove(sessionKey);
                    }
                }
            }
        };
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException e) {
            LOGGER.error("Can't close interpreter: {}", (Object)this.getId(), (Object)e);
        }
    }

    public void shutdown() {
        LOGGER.info("Close interpreter group " + this.getId());
        if (this.remoteInterpreterProcess != null) {
            while (this.remoteInterpreterProcess.referenceCount() > 0) {
                this.remoteInterpreterProcess.dereference();
            }
            this.remoteInterpreterProcess = null;
        }
        allInterpreterGroups.remove(this.id);
        LinkedList<Interpreter> intpToClose = new LinkedList<Interpreter>();
        for (List intpGroupForSession : this.values()) {
            intpToClose.addAll(intpGroupForSession);
        }
        this.close(intpToClose);
    }

    public void setResourcePool(ResourcePool resourcePool) {
        this.resourcePool = resourcePool;
    }

    public ResourcePool getResourcePool() {
        return this.resourcePool;
    }

    public boolean isAngularRegistryPushed() {
        return this.angularRegistryPushed;
    }

    public void setAngularRegistryPushed(boolean angularRegistryPushed) {
        this.angularRegistryPushed = angularRegistryPushed;
    }
}

