/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransportException;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterService;

public class ClientFactory
extends BasePooledObjectFactory<RemoteInterpreterService.Client> {
    private String host;
    private int port;
    Map<RemoteInterpreterService.Client, TSocket> clientSocketMap = new HashMap<RemoteInterpreterService.Client, TSocket>();

    public ClientFactory(String host, int port) {
        this.host = host;
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteInterpreterService.Client create() throws Exception {
        TSocket transport = new TSocket(this.host, this.port);
        try {
            transport.open();
        }
        catch (TTransportException e) {
            throw new InterpreterException(e);
        }
        TBinaryProtocol protocol = new TBinaryProtocol(transport);
        RemoteInterpreterService.Client client = new RemoteInterpreterService.Client(protocol);
        Map<RemoteInterpreterService.Client, TSocket> map = this.clientSocketMap;
        synchronized (map) {
            this.clientSocketMap.put(client, transport);
        }
        return client;
    }

    @Override
    public PooledObject<RemoteInterpreterService.Client> wrap(RemoteInterpreterService.Client client) {
        return new DefaultPooledObject<RemoteInterpreterService.Client>(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyObject(PooledObject<RemoteInterpreterService.Client> p) {
        Map<RemoteInterpreterService.Client, TSocket> map = this.clientSocketMap;
        synchronized (map) {
            if (this.clientSocketMap.containsKey(p.getObject())) {
                this.clientSocketMap.get(p.getObject()).close();
                this.clientSocketMap.remove(p.getObject());
            }
        }
    }

    @Override
    public boolean validateObject(PooledObject<RemoteInterpreterService.Client> p) {
        return p.getObject().getOutputProtocol().getTransport().isOpen();
    }
}

