/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import com.google.gson.Gson;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.thrift.TException;
import org.apache.zeppelin.helium.ApplicationEventListener;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.remote.ClientFactory;
import org.apache.zeppelin.interpreter.remote.InterpreterContextRunnerPool;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterEventPoller;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcessListener;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RemoteInterpreterProcess {
    private static final Logger logger = LoggerFactory.getLogger(RemoteInterpreterProcess.class);
    private final AtomicInteger referenceCount;
    private GenericObjectPool<RemoteInterpreterService.Client> clientPool;
    private final RemoteInterpreterEventPoller remoteInterpreterEventPoller;
    private final InterpreterContextRunnerPool interpreterContextRunnerPool = new InterpreterContextRunnerPool();
    private int connectTimeout;

    public RemoteInterpreterProcess(int connectTimeout, RemoteInterpreterProcessListener listener, ApplicationEventListener appListener) {
        this(new RemoteInterpreterEventPoller(listener, appListener), connectTimeout);
    }

    RemoteInterpreterProcess(RemoteInterpreterEventPoller remoteInterpreterEventPoller, int connectTimeout) {
        this.referenceCount = new AtomicInteger(0);
        this.remoteInterpreterEventPoller = remoteInterpreterEventPoller;
        this.connectTimeout = connectTimeout;
    }

    public abstract String getHost();

    public abstract int getPort();

    public abstract void start(String var1, Boolean var2);

    public abstract void stop();

    public abstract boolean isRunning();

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int reference(InterpreterGroup interpreterGroup, String userName, Boolean isUserImpersonate) {
        AtomicInteger atomicInteger = this.referenceCount;
        synchronized (atomicInteger) {
            if (!this.isRunning()) {
                this.start(userName, isUserImpersonate);
            }
            if (this.clientPool == null) {
                this.clientPool = new GenericObjectPool<RemoteInterpreterService.Client>(new ClientFactory(this.getHost(), this.getPort()));
                this.clientPool.setTestOnBorrow(true);
                this.remoteInterpreterEventPoller.setInterpreterGroup(interpreterGroup);
                this.remoteInterpreterEventPoller.setInterpreterProcess(this);
                this.remoteInterpreterEventPoller.start();
            }
            return this.referenceCount.incrementAndGet();
        }
    }

    public RemoteInterpreterService.Client getClient() throws Exception {
        if (this.clientPool == null || this.clientPool.isClosed()) {
            return null;
        }
        return this.clientPool.borrowObject();
    }

    public void releaseClient(RemoteInterpreterService.Client client) {
        this.releaseClient(client, false);
    }

    public void releaseClient(RemoteInterpreterService.Client client, boolean broken) {
        if (broken) {
            this.releaseBrokenClient(client);
        } else {
            try {
                this.clientPool.returnObject(client);
            }
            catch (Exception e) {
                logger.warn("exception occurred during releasing thrift client", e);
            }
        }
    }

    public void releaseBrokenClient(RemoteInterpreterService.Client client) {
        try {
            this.clientPool.invalidateObject(client);
        }
        catch (Exception e) {
            logger.warn("exception occurred during releasing thrift client", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dereference() {
        AtomicInteger atomicInteger = this.referenceCount;
        synchronized (atomicInteger) {
            int r = this.referenceCount.decrementAndGet();
            if (r == 0) {
                logger.info("shutdown interpreter process");
                this.remoteInterpreterEventPoller.shutdown();
                RemoteInterpreterService.Client client = null;
                try {
                    client = this.getClient();
                    client.shutdown();
                }
                catch (Exception e) {
                    logger.info("Exception in RemoteInterpreterProcess while synchronized dereference, can safely ignore exception while client.shutdown() may terminates remote process");
                    logger.debug(e.getMessage(), e);
                }
                finally {
                    if (client != null) {
                        this.releaseBrokenClient(client);
                    }
                }
                this.clientPool.clear();
                this.clientPool.close();
                long startTime = System.currentTimeMillis();
                while (System.currentTimeMillis() - startTime < (long)this.connectTimeout && this.isRunning()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        logger.error("Exception in RemoteInterpreterProcess while synchronized dereference Thread.sleep", e);
                    }
                }
            }
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int referenceCount() {
        AtomicInteger atomicInteger = this.referenceCount;
        synchronized (atomicInteger) {
            return this.referenceCount.get();
        }
    }

    public int getNumActiveClient() {
        if (this.clientPool == null) {
            return 0;
        }
        return this.clientPool.getNumActive();
    }

    public int getNumIdleClient() {
        if (this.clientPool == null) {
            return 0;
        }
        return this.clientPool.getNumIdle();
    }

    public void setMaxPoolSize(int size) {
        if (this.clientPool != null) {
            this.clientPool.setMaxTotal(size + 2);
        }
    }

    public int getMaxPoolSize() {
        if (this.clientPool != null) {
            return this.clientPool.getMaxTotal();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRemoteAngularObject(String name, String noteId, String paragraphId, Object o) {
        RemoteInterpreterService.Client client = null;
        try {
            client = this.getClient();
        }
        catch (NullPointerException e) {
            logger.info("NullPointerException in RemoteInterpreterProcess while updateRemoteAngularObject getClient, remote process not started", e);
            return;
        }
        catch (Exception e) {
            logger.error("Can't update angular object", e);
        }
        boolean broken = false;
        try {
            Gson gson = new Gson();
            client.angularObjectUpdate(name, noteId, paragraphId, gson.toJson(o));
        }
        catch (TException e) {
            broken = true;
            logger.error("Can't update angular object", e);
        }
        catch (NullPointerException e) {
            logger.error("Remote interpreter process not started", e);
            return;
        }
        finally {
            if (client != null) {
                this.releaseClient(client, broken);
            }
        }
    }

    public InterpreterContextRunnerPool getInterpreterContextRunnerPool() {
        return this.interpreterContextRunnerPool;
    }
}

