/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.thrift.TException;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TTransportException;
import org.apache.zeppelin.dep.DependencyResolver;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.display.AngularObjectRegistryListener;
import org.apache.zeppelin.display.GUI;
import org.apache.zeppelin.helium.Application;
import org.apache.zeppelin.helium.ApplicationContext;
import org.apache.zeppelin.helium.ApplicationException;
import org.apache.zeppelin.helium.ApplicationLoader;
import org.apache.zeppelin.helium.HeliumAppAngularObjectRegistry;
import org.apache.zeppelin.helium.HeliumPackage;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterContextRunner;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterHookListener;
import org.apache.zeppelin.interpreter.InterpreterHookRegistry;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.interpreter.InterpreterOutputListener;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.interpreter.InterpreterResultMessageOutput;
import org.apache.zeppelin.interpreter.LazyOpenInterpreter;
import org.apache.zeppelin.interpreter.RemoteWorksController;
import org.apache.zeppelin.interpreter.RemoteZeppelinServerResource;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreter;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterContextRunner;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterEventClient;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.interpreter.thrift.RemoteApplicationResult;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterContext;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterEvent;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterResult;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterResultMessage;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterService;
import org.apache.zeppelin.interpreter.thrift.ZeppelinServerResourceParagraphRunner;
import org.apache.zeppelin.resource.DistributedResourcePool;
import org.apache.zeppelin.resource.Resource;
import org.apache.zeppelin.resource.ResourcePool;
import org.apache.zeppelin.resource.ResourceSet;
import org.apache.zeppelin.resource.WellKnownResourceName;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.scheduler.JobListener;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteInterpreterServer
extends Thread
implements RemoteInterpreterService.Iface,
AngularObjectRegistryListener {
    Logger logger = LoggerFactory.getLogger(RemoteInterpreterServer.class);
    InterpreterGroup interpreterGroup;
    AngularObjectRegistry angularObjectRegistry;
    InterpreterHookRegistry hookRegistry;
    DistributedResourcePool resourcePool;
    private ApplicationLoader appLoader;
    Gson gson = new Gson();
    RemoteInterpreterService.Processor<RemoteInterpreterServer> processor;
    private int port;
    private TThreadPoolServer server;
    RemoteInterpreterEventClient eventClient = new RemoteInterpreterEventClient();
    private DependencyResolver depLoader;
    private final Map<String, RunningApplication> runningApplications = Collections.synchronizedMap(new HashMap());
    private Map<String, Object> remoteWorksResponsePool;
    private ZeppelinRemoteWorksController remoteWorksController;

    public RemoteInterpreterServer(int port) throws TTransportException {
        this.port = port;
        this.processor = new RemoteInterpreterService.Processor<RemoteInterpreterServer>(this);
        TServerSocket serverTransport = new TServerSocket(port);
        this.server = new TThreadPoolServer((TThreadPoolServer.Args)new TThreadPoolServer.Args(serverTransport).processor(this.processor));
        this.remoteWorksResponsePool = Collections.synchronizedMap(new HashMap());
        this.remoteWorksController = new ZeppelinRemoteWorksController(this, this.remoteWorksResponsePool);
    }

    @Override
    public void run() {
        this.logger.info("Starting remote interpreter server on port {}", (Object)this.port);
        this.server.serve();
    }

    @Override
    public void shutdown() throws TException {
        this.eventClient.waitForEventQueueBecomesEmpty();
        if (this.interpreterGroup != null) {
            this.interpreterGroup.close();
        }
        this.server.stop();
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < 2000L && this.server.isServing()) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                this.logger.info("Exception in RemoteInterpreterServer while shutdown, Thread.sleep", e);
            }
        }
        if (this.server.isServing()) {
            System.exit(0);
        }
    }

    public int getPort() {
        return this.port;
    }

    public boolean isRunning() {
        if (this.server == null) {
            return false;
        }
        return this.server.isServing();
    }

    public static void main(String[] args) throws TTransportException, InterruptedException {
        int port = 29914;
        if (args.length > 0) {
            port = Integer.parseInt(args[0]);
        }
        RemoteInterpreterServer remoteInterpreterServer = new RemoteInterpreterServer(port);
        remoteInterpreterServer.start();
        remoteInterpreterServer.join();
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createInterpreter(String interpreterGroupId, String sessionKey, String className, Map<String, String> properties, String userName) throws TException {
        if (this.interpreterGroup == null) {
            this.interpreterGroup = new InterpreterGroup(interpreterGroupId);
            this.angularObjectRegistry = new AngularObjectRegistry(this.interpreterGroup.getId(), this);
            this.hookRegistry = new InterpreterHookRegistry(this.interpreterGroup.getId());
            this.resourcePool = new DistributedResourcePool(this.interpreterGroup.getId(), this.eventClient);
            this.interpreterGroup.setInterpreterHookRegistry(this.hookRegistry);
            this.interpreterGroup.setAngularObjectRegistry(this.angularObjectRegistry);
            this.interpreterGroup.setResourcePool(this.resourcePool);
            String localRepoPath = properties.get("zeppelin.interpreter.localRepo");
            this.depLoader = new DependencyResolver(localRepoPath);
            this.appLoader = new ApplicationLoader(this.resourcePool, this.depLoader);
        }
        try {
            Class<?> replClass = Class.forName(className);
            Properties p = new Properties();
            p.putAll(properties);
            this.setSystemProperty(p);
            Constructor<?> constructor = replClass.getConstructor(Properties.class);
            Interpreter repl = (Interpreter)constructor.newInstance(p);
            repl.setClassloaderUrls(new URL[0]);
            InterpreterGroup interpreterGroup = this.interpreterGroup;
            synchronized (interpreterGroup) {
                LinkedList<LazyOpenInterpreter> interpreters = (LinkedList<LazyOpenInterpreter>)this.interpreterGroup.get(sessionKey);
                if (interpreters == null) {
                    interpreters = new LinkedList<LazyOpenInterpreter>();
                    this.interpreterGroup.put(sessionKey, interpreters);
                }
                interpreters.add(new LazyOpenInterpreter(repl));
            }
            this.logger.info("Instantiate interpreter {}", (Object)className);
            repl.setInterpreterGroup(this.interpreterGroup);
            repl.setUserName(userName);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.logger.error(e.toString(), e);
            throw new TException(e);
        }
    }

    protected InterpreterGroup getInterpreterGroup() {
        return this.interpreterGroup;
    }

    protected ResourcePool getResourcePool() {
        return this.resourcePool;
    }

    protected RemoteInterpreterEventClient getEventClient() {
        return this.eventClient;
    }

    private void setSystemProperty(Properties properties) {
        for (Object key : properties.keySet()) {
            if (RemoteInterpreter.isEnvString((String)key)) continue;
            String value = properties.getProperty((String)key);
            if (value == null || value.isEmpty()) {
                System.clearProperty((String)key);
                continue;
            }
            System.setProperty((String)key, properties.getProperty((String)key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Interpreter getInterpreter(String sessionKey, String className) throws TException {
        if (this.interpreterGroup == null) {
            throw new TException(new InterpreterException("Interpreter instance " + className + " not created"));
        }
        InterpreterGroup interpreterGroup = this.interpreterGroup;
        synchronized (interpreterGroup) {
            List interpreters = (List)this.interpreterGroup.get(sessionKey);
            if (interpreters == null) {
                throw new TException(new InterpreterException("Interpreter " + className + " not initialized"));
            }
            for (Interpreter inp : interpreters) {
                if (!inp.getClassName().equals(className)) continue;
                return inp;
            }
        }
        throw new TException(new InterpreterException("Interpreter instance " + className + " not found"));
    }

    @Override
    public void open(String noteId, String className) throws TException {
        Interpreter intp = this.getInterpreter(noteId, className);
        intp.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(String sessionKey, String className) throws TException {
        List interpreters;
        for (String string : this.runningApplications.keySet()) {
            RunningApplication appInfo = this.runningApplications.get(string);
            if (!appInfo.noteId.equals(sessionKey) && !sessionKey.equals("shared_session")) continue;
            try {
                this.logger.info("Unload App {} ", (Object)appInfo.pkg.getName());
                appInfo.app.unload();
                this.eventClient.onAppStatusUpdate(appInfo.noteId, appInfo.paragraphId, string, "UNLOADED");
            }
            catch (ApplicationException e) {
                this.logger.error(e.getMessage(), e);
            }
        }
        InterpreterGroup interpreterGroup = this.interpreterGroup;
        synchronized (interpreterGroup) {
            interpreters = (List)this.interpreterGroup.get(sessionKey);
        }
        if (interpreters != null) {
            Iterator iterator = interpreters.iterator();
            while (iterator.hasNext()) {
                Interpreter inp = (Interpreter)iterator.next();
                if (!inp.getClassName().equals(className)) continue;
                inp.close();
                iterator.remove();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteInterpreterResult interpret(String noteId, String className, String st, RemoteInterpreterContext interpreterContext) throws TException {
        InterpreterResult result;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("st:\n{}", (Object)st);
        }
        Interpreter intp = this.getInterpreter(noteId, className);
        InterpreterContext context = this.convert(interpreterContext);
        context.setClassName(intp.getClassName());
        Scheduler scheduler = intp.getScheduler();
        InterpretJobListener jobListener = new InterpretJobListener();
        InterpretJob job = new InterpretJob(interpreterContext.getParagraphId(), "remoteInterpretJob_" + System.currentTimeMillis(), jobListener, 500L, intp, st, context);
        scheduler.submit(job);
        while (!job.isTerminated()) {
            InterpretJobListener interpretJobListener = jobListener;
            synchronized (interpretJobListener) {
                try {
                    jobListener.wait(1000L);
                }
                catch (InterruptedException e) {
                    this.logger.info("Exception in RemoteInterpreterServer while interpret, jobListener.wait", e);
                }
            }
        }
        if (job.getStatus() == Job.Status.ERROR) {
            result = new InterpreterResult(InterpreterResult.Code.ERROR, Job.getStack(job.getException()));
        } else {
            result = (InterpreterResult)job.getReturn();
            if (result == null) {
                result = new InterpreterResult(InterpreterResult.Code.KEEP_PREVIOUS_RESULT);
            }
        }
        return this.convert(result, context.getConfig(), context.getGui());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReceivedZeppelinResource(String responseJson) throws TException {
        block7: {
            RemoteZeppelinServerResource response = this.gson.fromJson(responseJson, RemoteZeppelinServerResource.class);
            if (response == null) {
                throw new TException("Bad response for remote resource");
            }
            if (response.getResourceType() != RemoteZeppelinServerResource.Type.PARAGRAPH_RUNNERS) break block7;
            LinkedList<ParagraphRunner> intpContextRunners = new LinkedList<ParagraphRunner>();
            List remoteRunnersMap = (List)response.getData();
            String noteId = null;
            String paragraphId = null;
            for (Map runnerItem : remoteRunnersMap) {
                noteId = (String)runnerItem.get("noteId");
                paragraphId = (String)runnerItem.get("paragraphId");
                intpContextRunners.add(new ParagraphRunner(this, noteId, paragraphId));
            }
            Map<String, Object> map = this.remoteWorksResponsePool;
            synchronized (map) {
                this.remoteWorksResponsePool.put(response.getOwnerKey(), intpContextRunners);
            }
        }
    }

    @Override
    public void cancel(String noteId, String className, RemoteInterpreterContext interpreterContext) throws TException {
        this.logger.info("cancel {} {}", (Object)className, (Object)interpreterContext.getParagraphId());
        Interpreter intp = this.getInterpreter(noteId, className);
        String jobId = interpreterContext.getParagraphId();
        Job job = intp.getScheduler().removeFromWaitingQueue(jobId);
        if (job != null) {
            job.setStatus(Job.Status.ABORT);
        } else {
            intp.cancel(this.convert(interpreterContext, null));
        }
    }

    @Override
    public int getProgress(String noteId, String className, RemoteInterpreterContext interpreterContext) throws TException {
        Interpreter intp = this.getInterpreter(noteId, className);
        return intp.getProgress(this.convert(interpreterContext, null));
    }

    @Override
    public String getFormType(String noteId, String className) throws TException {
        Interpreter intp = this.getInterpreter(noteId, className);
        return intp.getFormType().toString();
    }

    @Override
    public List<InterpreterCompletion> completion(String noteId, String className, String buf, int cursor) throws TException {
        Interpreter intp = this.getInterpreter(noteId, className);
        List<InterpreterCompletion> completion2 = intp.completion(buf, cursor);
        return completion2;
    }

    private InterpreterContext convert(RemoteInterpreterContext ric) {
        return this.convert(ric, this.createInterpreterOutput(ric.getNoteId(), ric.getParagraphId()));
    }

    private InterpreterContext convert(RemoteInterpreterContext ric, InterpreterOutput output) {
        LinkedList<InterpreterContextRunner> contextRunners = new LinkedList<InterpreterContextRunner>();
        List runners = (List)this.gson.fromJson(ric.getRunners(), new TypeToken<List<RemoteInterpreterContextRunner>>(){}.getType());
        for (InterpreterContextRunner r : runners) {
            contextRunners.add(new ParagraphRunner(this, r.getNoteId(), r.getParagraphId()));
        }
        return new InterpreterContext(ric.getNoteId(), ric.getParagraphId(), ric.getReplName(), ric.getParagraphTitle(), ric.getParagraphText(), this.gson.fromJson(ric.getAuthenticationInfo(), AuthenticationInfo.class), (Map)this.gson.fromJson(ric.getConfig(), new TypeToken<Map<String, Object>>(){}.getType()), this.gson.fromJson(ric.getGui(), GUI.class), this.interpreterGroup.getAngularObjectRegistry(), this.interpreterGroup.getResourcePool(), contextRunners, output, this.remoteWorksController, this.eventClient);
    }

    protected InterpreterOutput createInterpreterOutput(final String noteId, final String paragraphId) {
        return new InterpreterOutput(new InterpreterOutputListener(){

            @Override
            public void onUpdateAll(InterpreterOutput out) {
                try {
                    RemoteInterpreterServer.this.eventClient.onInterpreterOutputUpdateAll(noteId, paragraphId, out.toInterpreterResultMessage());
                }
                catch (IOException e) {
                    RemoteInterpreterServer.this.logger.error(e.getMessage(), e);
                }
            }

            @Override
            public void onAppend(int index, InterpreterResultMessageOutput out, byte[] line) {
                String output = new String(line);
                RemoteInterpreterServer.this.logger.debug("Output Append: {}", (Object)output);
                RemoteInterpreterServer.this.eventClient.onInterpreterOutputAppend(noteId, paragraphId, index, output);
            }

            @Override
            public void onUpdate(int index, InterpreterResultMessageOutput out) {
                try {
                    String output = new String(out.toByteArray());
                    RemoteInterpreterServer.this.logger.debug("Output Update: {}", (Object)output);
                    RemoteInterpreterServer.this.eventClient.onInterpreterOutputUpdate(noteId, paragraphId, index, out.getType(), output);
                }
                catch (IOException e) {
                    RemoteInterpreterServer.this.logger.error(e.getMessage(), e);
                }
            }
        });
    }

    private RemoteInterpreterResult convert(InterpreterResult result, Map<String, Object> config, GUI gui) {
        LinkedList<RemoteInterpreterResultMessage> msg = new LinkedList<RemoteInterpreterResultMessage>();
        for (InterpreterResultMessage m : result.message()) {
            msg.add(new RemoteInterpreterResultMessage(m.getType().name(), m.getData()));
        }
        return new RemoteInterpreterResult(result.code().name(), msg, this.gson.toJson(config), this.gson.toJson(gui));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStatus(String sessionKey, String jobId) throws TException {
        if (this.interpreterGroup == null) {
            return "Unknown";
        }
        InterpreterGroup interpreterGroup = this.interpreterGroup;
        synchronized (interpreterGroup) {
            List interpreters = (List)this.interpreterGroup.get(sessionKey);
            if (interpreters == null) {
                return "Unknown";
            }
            for (Interpreter intp : interpreters) {
                for (Job job : intp.getScheduler().getJobsRunning()) {
                    if (!jobId.equals(job.getId())) continue;
                    return job.getStatus().name();
                }
                for (Job job : intp.getScheduler().getJobsWaiting()) {
                    if (!jobId.equals(job.getId())) continue;
                    return job.getStatus().name();
                }
            }
        }
        return "Unknown";
    }

    @Override
    public void onAdd(String interpreterGroupId, AngularObject object) {
        this.eventClient.angularObjectAdd(object);
    }

    @Override
    public void onUpdate(String interpreterGroupId, AngularObject object) {
        this.eventClient.angularObjectUpdate(object);
    }

    @Override
    public void onRemove(String interpreterGroupId, String name, String noteId, String paragraphId) {
        this.eventClient.angularObjectRemove(name, noteId, paragraphId);
    }

    @Override
    public RemoteInterpreterEvent getEvent() throws TException {
        return this.eventClient.pollEvent();
    }

    @Override
    public void angularObjectUpdate(String name, String noteId, String paragraphId, String object) throws TException {
        AngularObjectRegistry registry = this.interpreterGroup.getAngularObjectRegistry();
        AngularObject ao = registry.get(name, noteId, paragraphId);
        if (ao == null) {
            this.logger.debug("Angular object {} not exists", (Object)name);
            return;
        }
        if (object == null) {
            ao.set(null, false);
            return;
        }
        Object oldObject = ao.get();
        String value = null;
        if (oldObject != null) {
            try {
                value = (String)this.gson.fromJson(object, oldObject.getClass());
                ao.set(value, false);
                return;
            }
            catch (Exception e) {
                this.logger.debug(e.getMessage(), e);
            }
        }
        if (value == null) {
            try {
                value = this.gson.fromJson(object, new TypeToken<Map<String, Object>>(){}.getType());
            }
            catch (Exception e) {
                this.logger.debug(e.getMessage(), e);
            }
        }
        if (value == null) {
            value = this.gson.fromJson(object, String.class);
        }
        ao.set(value, false);
    }

    @Override
    public void angularObjectAdd(String name, String noteId, String paragraphId, String object) throws TException {
        AngularObjectRegistry registry = this.interpreterGroup.getAngularObjectRegistry();
        AngularObject ao = registry.get(name, noteId, paragraphId);
        if (ao != null) {
            this.angularObjectUpdate(name, noteId, paragraphId, object);
            return;
        }
        String value = null;
        try {
            value = (String)this.gson.fromJson(object, new TypeToken<Map<String, Object>>(){}.getType());
        }
        catch (Exception e) {
            this.logger.debug(e.getMessage(), e);
        }
        if (value == null) {
            value = this.gson.fromJson(object, String.class);
        }
        registry.add(name, value, noteId, paragraphId, false);
    }

    @Override
    public void angularObjectRemove(String name, String noteId, String paragraphId) throws TException {
        AngularObjectRegistry registry = this.interpreterGroup.getAngularObjectRegistry();
        registry.remove(name, noteId, paragraphId, false);
    }

    @Override
    public void resourcePoolResponseGetAll(List<String> resources) throws TException {
        this.eventClient.putResponseGetAllResources(resources);
    }

    @Override
    public void resourceResponseGet(String resourceId, ByteBuffer object) throws TException {
        this.eventClient.putResponseGetResource(resourceId, object);
    }

    @Override
    public List<String> resourcePoolGetAll() throws TException {
        this.logger.debug("Request getAll from ZeppelinServer");
        LinkedList<String> result = new LinkedList<String>();
        if (this.resourcePool == null) {
            return result;
        }
        ResourceSet resourceSet = this.resourcePool.getAll(false);
        Gson gson = new Gson();
        for (Resource r : resourceSet) {
            result.add(gson.toJson(r));
        }
        return result;
    }

    @Override
    public boolean resourceRemove(String noteId, String paragraphId, String resourceName) throws TException {
        Resource resource = this.resourcePool.remove(noteId, paragraphId, resourceName);
        return resource != null;
    }

    @Override
    public ByteBuffer resourceGet(String noteId, String paragraphId, String resourceName) throws TException {
        this.logger.debug("Request resourceGet {} from ZeppelinServer", (Object)resourceName);
        Resource resource = this.resourcePool.get(noteId, paragraphId, resourceName, false);
        if (resource == null || resource.get() == null || !resource.isSerializable()) {
            return ByteBuffer.allocate(0);
        }
        try {
            return Resource.serializeObject(resource.get());
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
            return ByteBuffer.allocate(0);
        }
    }

    @Override
    public void angularRegistryPush(String registryAsString) throws TException {
        try {
            Map deserializedRegistry = (Map)this.gson.fromJson(registryAsString, new TypeToken<Map<String, Map<String, AngularObject>>>(){}.getType());
            this.interpreterGroup.getAngularObjectRegistry().setRegistry(deserializedRegistry);
        }
        catch (Exception e) {
            this.logger.info("Exception in RemoteInterpreterServer while angularRegistryPush, nolock", e);
        }
    }

    protected InterpreterOutput createAppOutput(final String noteId, final String paragraphId, final String appId) {
        return new InterpreterOutput(new InterpreterOutputListener(){

            @Override
            public void onUpdateAll(InterpreterOutput out) {
            }

            @Override
            public void onAppend(int index, InterpreterResultMessageOutput out, byte[] line) {
                RemoteInterpreterServer.this.eventClient.onAppOutputAppend(noteId, paragraphId, index, appId, new String(line));
            }

            @Override
            public void onUpdate(int index, InterpreterResultMessageOutput out) {
                try {
                    RemoteInterpreterServer.this.eventClient.onAppOutputUpdate(noteId, paragraphId, index, appId, out.getType(), new String(out.toByteArray()));
                }
                catch (IOException e) {
                    RemoteInterpreterServer.this.logger.error(e.getMessage(), e);
                }
            }
        });
    }

    private ApplicationContext getApplicationContext(HeliumPackage packageInfo, String noteId, String paragraphId, String applicationInstanceId) {
        InterpreterOutput out = this.createAppOutput(noteId, paragraphId, applicationInstanceId);
        return new ApplicationContext(noteId, paragraphId, applicationInstanceId, new HeliumAppAngularObjectRegistry(this.angularObjectRegistry, noteId, applicationInstanceId), out);
    }

    @Override
    public RemoteApplicationResult loadApplication(String applicationInstanceId, String packageInfo, String noteId, String paragraphId) throws TException {
        if (this.runningApplications.containsKey(applicationInstanceId)) {
            this.logger.warn("Application instance {} is already running");
            return new RemoteApplicationResult(true, "");
        }
        HeliumPackage pkgInfo = this.gson.fromJson(packageInfo, HeliumPackage.class);
        ApplicationContext context = this.getApplicationContext(pkgInfo, noteId, paragraphId, applicationInstanceId);
        try {
            Application app = null;
            this.logger.info("Loading application {}({}), artifact={}, className={} into note={}, paragraph={}", pkgInfo.getName(), applicationInstanceId, pkgInfo.getArtifact(), pkgInfo.getClassName(), noteId, paragraphId);
            app = this.appLoader.load(pkgInfo, context);
            this.runningApplications.put(applicationInstanceId, new RunningApplication(pkgInfo, app, noteId, paragraphId));
            return new RemoteApplicationResult(true, "");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            return new RemoteApplicationResult(false, e.getMessage());
        }
    }

    @Override
    public RemoteApplicationResult unloadApplication(String applicationInstanceId) throws TException {
        RunningApplication runningApplication = this.runningApplications.remove(applicationInstanceId);
        if (runningApplication != null) {
            try {
                this.logger.info("Unloading application {}", (Object)applicationInstanceId);
                runningApplication.app.unload();
            }
            catch (ApplicationException e) {
                this.logger.error(e.getMessage(), e);
                return new RemoteApplicationResult(false, e.getMessage());
            }
        }
        return new RemoteApplicationResult(true, "");
    }

    @Override
    public RemoteApplicationResult runApplication(String applicationInstanceId) throws TException {
        this.logger.info("run application {}", (Object)applicationInstanceId);
        RunningApplication runningApp = this.runningApplications.get(applicationInstanceId);
        if (runningApp == null) {
            this.logger.error("Application instance {} not exists", (Object)applicationInstanceId);
            return new RemoteApplicationResult(false, "Application instance does not exists");
        }
        ApplicationContext context = runningApp.app.context();
        try {
            context.out.clear();
            context.out.setType(InterpreterResult.Type.ANGULAR);
            ResourceSet resource = this.appLoader.findRequiredResourceSet(runningApp.pkg.getResources(), context.getNoteId(), context.getParagraphId());
            for (Resource res : resource) {
                System.err.println("Resource " + res.get());
            }
            runningApp.app.run(resource);
            context.out.flush();
            InterpreterResultMessageOutput out = context.out.getOutputAt(0);
            this.eventClient.onAppOutputUpdate(context.getNoteId(), context.getParagraphId(), 0, applicationInstanceId, out.getType(), new String(out.toByteArray()));
            return new RemoteApplicationResult(true, "");
        }
        catch (IOException | ApplicationException e) {
            return new RemoteApplicationResult(false, e.getMessage());
        }
    }

    private static class RunningApplication {
        public final Application app;
        public final HeliumPackage pkg;
        public final String noteId;
        public final String paragraphId;

        public RunningApplication(HeliumPackage pkg, Application app, String noteId, String paragraphId) {
            this.app = app;
            this.pkg = pkg;
            this.noteId = noteId;
            this.paragraphId = paragraphId;
        }
    }

    static class ZeppelinRemoteWorksController
    implements RemoteWorksController {
        Logger logger = LoggerFactory.getLogger(ZeppelinRemoteWorksController.class);
        private final long DEFAULT_TIMEOUT_VALUE = 300000L;
        private final Map<String, Object> remoteWorksResponsePool;
        private RemoteInterpreterServer server;

        public ZeppelinRemoteWorksController(RemoteInterpreterServer server, Map<String, Object> remoteWorksResponsePool) {
            this.remoteWorksResponsePool = remoteWorksResponsePool;
            this.server = server;
        }

        public String generateOwnerKey() {
            String hashKeyText = new String("ownerKey" + System.currentTimeMillis());
            String hashKey = String.valueOf(hashKeyText.hashCode());
            return hashKey;
        }

        public boolean waitForEvent(String eventOwnerKey) throws InterruptedException {
            return this.waitForEvent(eventOwnerKey, 300000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitForEvent(String eventOwnerKey, long timeout) throws InterruptedException {
            boolean wasGetData = false;
            long now = System.currentTimeMillis();
            long endTime = System.currentTimeMillis() + timeout;
            while (endTime >= now) {
                Map<String, Object> map = this.remoteWorksResponsePool;
                synchronized (map) {
                    wasGetData = this.remoteWorksResponsePool.containsKey(eventOwnerKey);
                }
                if (wasGetData) break;
                now = System.currentTimeMillis();
                Thread.sleep(500L);
            }
            return wasGetData;
        }

        @Override
        public List<InterpreterContextRunner> getRemoteContextRunner(String noteId) {
            return this.getRemoteContextRunner(noteId, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<InterpreterContextRunner> getRemoteContextRunner(String noteId, String paragraphID) {
            List runners = null;
            String ownerKey = this.generateOwnerKey();
            ZeppelinServerResourceParagraphRunner resource = new ZeppelinServerResourceParagraphRunner();
            resource.setNoteId(noteId);
            resource.setParagraphId(paragraphID);
            this.server.eventClient.getZeppelinServerNoteRunner(ownerKey, resource);
            try {
                this.waitForEvent(ownerKey);
            }
            catch (Exception e) {
                return new LinkedList<InterpreterContextRunner>();
            }
            Map<String, Object> map = this.remoteWorksResponsePool;
            synchronized (map) {
                runners = (List)this.remoteWorksResponsePool.get(ownerKey);
                this.remoteWorksResponsePool.remove(ownerKey);
            }
            return runners;
        }
    }

    static class ParagraphRunner
    extends InterpreterContextRunner {
        Logger logger = LoggerFactory.getLogger(ParagraphRunner.class);
        private transient RemoteInterpreterServer server;

        public ParagraphRunner(RemoteInterpreterServer server, String noteId, String paragraphId) {
            super(noteId, paragraphId);
            this.server = server;
        }

        @Override
        public void run() {
            this.server.eventClient.run(this);
        }
    }

    class InterpretJob
    extends Job {
        private Interpreter interpreter;
        private String script;
        private InterpreterContext context;
        private Map<String, Object> infos;
        private Object results;

        public InterpretJob(String jobId, String jobName, JobListener listener, long progressUpdateIntervalMsec, Interpreter interpreter, String script, InterpreterContext context) {
            super(jobId, jobName, listener, progressUpdateIntervalMsec);
            this.interpreter = interpreter;
            this.script = script;
            this.context = context;
        }

        @Override
        public Object getReturn() {
            return this.results;
        }

        @Override
        public int progress() {
            return 0;
        }

        @Override
        public Map<String, Object> info() {
            if (this.infos == null) {
                this.infos = new HashMap<String, Object>();
            }
            return this.infos;
        }

        private void processInterpreterHooks(final String noteId) {
            InterpreterHookListener hookListener = new InterpreterHookListener(){

                @Override
                public void onPreExecute(String script) {
                    String cmdDev = InterpretJob.this.interpreter.getHook(noteId, "pre_exec_dev");
                    String cmdUser = InterpretJob.this.interpreter.getHook(noteId, "pre_exec");
                    List<String> cmds = Arrays.asList(cmdDev, cmdUser);
                    for (String cmd : cmds) {
                        if (cmd == null) continue;
                        script = cmd + '\n' + script;
                    }
                    InterpretJob.this.script = script;
                }

                @Override
                public void onPostExecute(String script) {
                    String cmdDev = InterpretJob.this.interpreter.getHook(noteId, "post_exec_dev");
                    String cmdUser = InterpretJob.this.interpreter.getHook(noteId, "post_exec");
                    List<String> cmds = Arrays.asList(cmdUser, cmdDev);
                    for (String cmd : cmds) {
                        if (cmd == null) continue;
                        script = script + '\n' + cmd;
                    }
                    InterpretJob.this.script = script;
                }
            };
            hookListener.onPreExecute(this.script);
            hookListener.onPostExecute(this.script);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object jobRun() throws Throwable {
            try {
                int lastMessageIndex;
                InterpreterContext.set(this.context);
                LazyOpenInterpreter lazy = (LazyOpenInterpreter)this.interpreter;
                if (!lazy.isOpen()) {
                    lazy.open();
                }
                this.processInterpreterHooks(null);
                this.processInterpreterHooks(this.context.getNoteId());
                InterpreterResult result = this.interpreter.interpret(this.script, this.context);
                this.context.out.flush();
                List<InterpreterResultMessage> resultMessages = this.context.out.toInterpreterResultMessage();
                resultMessages.addAll(result.message());
                if (resultMessages.size() > 0 && resultMessages.get(lastMessageIndex = resultMessages.size() - 1).getType() == InterpreterResult.Type.TABLE) {
                    this.context.getResourcePool().put(this.context.getNoteId(), this.context.getParagraphId(), WellKnownResourceName.ZeppelinTableResult.toString(), resultMessages.get(lastMessageIndex));
                }
                InterpreterResult interpreterResult = new InterpreterResult(result.code(), resultMessages);
                return interpreterResult;
            }
            finally {
                InterpreterContext.remove();
            }
        }

        @Override
        protected boolean jobAbort() {
            return false;
        }

        @Override
        public void setResult(Object results) {
            this.results = results;
        }
    }

    class InterpretJobListener
    implements JobListener {
        InterpretJobListener() {
        }

        @Override
        public void onProgressUpdate(Job job, int progress) {
        }

        @Override
        public void beforeStatusChange(Job job, Job.Status before, Job.Status after) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void afterStatusChange(Job job, Job.Status before, Job.Status after) {
            InterpretJobListener interpretJobListener = this;
            synchronized (interpretJobListener) {
                this.notifyAll();
            }
        }
    }
}

