/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.scheduler;

import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.scheduler.JobListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobProgressPoller
extends Thread {
    public static final long DEFAULT_INTERVAL_MSEC = 500L;
    Logger logger = LoggerFactory.getLogger(JobProgressPoller.class);
    private Job job;
    private long intervalMs;
    boolean terminate = false;

    public JobProgressPoller(Job job, long intervalMs) {
        this.job = job;
        this.intervalMs = intervalMs;
    }

    @Override
    public void run() {
        if (this.intervalMs < 0L) {
            return;
        }
        if (this.intervalMs == 0L) {
            this.intervalMs = 500L;
        }
        while (!this.terminate) {
            JobListener listener = this.job.getListener();
            if (listener != null) {
                try {
                    if (this.job.isRunning()) {
                        listener.onProgressUpdate(this.job, this.job.progress());
                    }
                }
                catch (Exception e) {
                    this.logger.error("Can not get or update progress", e);
                }
            }
            try {
                Thread.sleep(this.intervalMs);
            }
            catch (InterruptedException e) {
                this.logger.error("Exception in JobProgressPoller while run Thread.sleep", e);
            }
        }
    }

    public void terminate() {
        this.terminate = true;
    }
}

