/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.spark;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.spark.repl.SparkILoop;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.WrappedInterpreter;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.spark.SparkInterpreter;
import org.apache.zeppelin.spark.Utils;
import org.apache.zeppelin.spark.dep.SparkDependencyContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.DependencyResolutionException;
import scala.Console;
import scala.None;
import scala.Option;
import scala.Some;
import scala.collection.JavaConversions;
import scala.collection.Seq;
import scala.collection.convert.WrapAsJava$;
import scala.tools.nsc.Settings;
import scala.tools.nsc.interpreter.Completion;
import scala.tools.nsc.interpreter.IMain;
import scala.tools.nsc.interpreter.Results;
import scala.tools.nsc.settings.AbsSettings;
import scala.tools.nsc.settings.MutableSettings;

public class DepInterpreter
extends Interpreter {
    private Object intp;
    private ByteArrayOutputStream out;
    private SparkDependencyContext depc;
    private Object completer;
    private SparkILoop interpreter;
    static final Logger LOGGER = LoggerFactory.getLogger(DepInterpreter.class);

    public DepInterpreter(Properties property) {
        super(property);
    }

    public SparkDependencyContext getDependencyContext() {
        return this.depc;
    }

    public static String getSystemDefault(String envName, String propertyName, String defaultValue) {
        String propValue;
        String envValue;
        if (envName != null && !envName.isEmpty() && (envValue = System.getenv().get(envName)) != null) {
            return envValue;
        }
        if (propertyName != null && !propertyName.isEmpty() && (propValue = System.getProperty(propertyName)) != null) {
            return propValue;
        }
        return defaultValue;
    }

    @Override
    public void close() {
        if (this.intp != null) {
            Utils.invokeMethod(this.intp, "close");
        }
    }

    @Override
    public void open() {
        this.out = new ByteArrayOutputStream();
        this.createIMain();
    }

    private void createIMain() {
        Settings settings = new Settings();
        URL[] urls = this.getClassloaderUrls();
        MutableSettings.PathSetting pathSettings = settings.classpath();
        String classpath = "";
        List<File> paths = this.currentClassPath();
        for (File f : paths) {
            if (classpath.length() > 0) {
                classpath = classpath + File.pathSeparator;
            }
            classpath = classpath + f.getAbsolutePath();
        }
        if (urls != null) {
            for (URL u : urls) {
                if (classpath.length() > 0) {
                    classpath = classpath + File.pathSeparator;
                }
                classpath = classpath + u.getFile();
            }
        }
        pathSettings.v_$eq(classpath);
        settings.scala$tools$nsc$settings$ScalaSettings$_setter_$classpath_$eq(pathSettings);
        settings.explicitParentLoader_$eq((Option)new Some((Object)Thread.currentThread().getContextClassLoader()));
        MutableSettings.BooleanSetting b = (MutableSettings.BooleanSetting)settings.usejavacp();
        b.v_$eq(true);
        settings.scala$tools$nsc$settings$StandardScalaSettings$_setter_$usejavacp_$eq((AbsSettings.AbsSetting)b);
        this.interpreter = new SparkILoop((BufferedReader)null, new PrintWriter(this.out));
        this.interpreter.settings_$eq(settings);
        this.interpreter.createInterpreter();
        this.intp = Utils.invokeMethod(this.interpreter, "intp");
        if (Utils.isScala2_10()) {
            Utils.invokeMethod(this.intp, "setContextClassLoader");
            Utils.invokeMethod(this.intp, "initializeSynchronous");
        }
        this.depc = new SparkDependencyContext(this.getProperty("zeppelin.dep.localrepo"), this.getProperty("zeppelin.dep.additionalRemoteRepository"));
        if (Utils.isScala2_10()) {
            this.completer = Utils.instantiateClass("org.apache.spark.repl.SparkJLineCompletion", new Class[]{Utils.findClass("org.apache.spark.repl.SparkIMain")}, new Object[]{this.intp});
        }
        this.interpret("@transient var _binder = new java.util.HashMap[String, Object]()");
        Map binder = Utils.isScala2_10() ? (Map)this.getValue("_binder") : (Map)this.getLastObject();
        binder.put("depc", this.depc);
        this.interpret("@transient val z = _binder.get(\"depc\").asInstanceOf[org.apache.zeppelin.spark.dep.SparkDependencyContext]");
    }

    private Results.Result interpret(String line) {
        return (Results.Result)Utils.invokeMethod(this.intp, "interpret", new Class[]{String.class}, new Object[]{line});
    }

    public Object getValue(String name) {
        Object ret = Utils.invokeMethod(this.intp, "valueOfTerm", new Class[]{String.class}, new Object[]{name});
        if (ret instanceof None) {
            return null;
        }
        if (ret instanceof Some) {
            return ((Some)ret).get();
        }
        return ret;
    }

    public Object getLastObject() {
        IMain.Request r = (IMain.Request)Utils.invokeMethod(this.intp, "lastRequest");
        Object obj = r.lineRep().call("$result", (Seq)JavaConversions.asScalaBuffer(new LinkedList()));
        return obj;
    }

    @Override
    public InterpreterResult interpret(String st, InterpreterContext context) {
        PrintStream printStream = new PrintStream(this.out);
        Console.setOut((PrintStream)printStream);
        this.out.reset();
        SparkInterpreter sparkInterpreter = this.getSparkInterpreter();
        if (sparkInterpreter != null && sparkInterpreter.isSparkContextInitialized()) {
            return new InterpreterResult(InterpreterResult.Code.ERROR, "Must be used before SparkInterpreter (%spark) initialized\nHint: put this paragraph before any Spark code and restart Zeppelin/Interpreter");
        }
        Results.Result ret = this.interpret(st);
        InterpreterResult.Code code = this.getResultCode(ret);
        try {
            this.depc.fetch();
        }
        catch (MalformedURLException | ArtifactResolutionException | DependencyResolutionException e) {
            LOGGER.error("Exception in DepInterpreter while interpret ", e);
            return new InterpreterResult(InterpreterResult.Code.ERROR, e.toString());
        }
        if (code == InterpreterResult.Code.INCOMPLETE) {
            return new InterpreterResult(code, "Incomplete expression");
        }
        if (code == InterpreterResult.Code.ERROR) {
            return new InterpreterResult(code, this.out.toString());
        }
        return new InterpreterResult(code, this.out.toString());
    }

    private InterpreterResult.Code getResultCode(Results.Result r) {
        if (r instanceof Results.Success$) {
            return InterpreterResult.Code.SUCCESS;
        }
        if (r instanceof Results.Incomplete$) {
            return InterpreterResult.Code.INCOMPLETE;
        }
        return InterpreterResult.Code.ERROR;
    }

    @Override
    public void cancel(InterpreterContext context) {
    }

    @Override
    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.NATIVE;
    }

    @Override
    public int getProgress(InterpreterContext context) {
        return 0;
    }

    @Override
    public List<InterpreterCompletion> completion(String buf, int cursor) {
        if (Utils.isScala2_10()) {
            Completion.ScalaCompleter c = (Completion.ScalaCompleter)Utils.invokeMethod(this.completer, "completer");
            Completion.Candidates ret = c.complete(buf, cursor);
            List candidates = WrapAsJava$.MODULE$.seqAsJavaList((Seq)ret.candidates());
            LinkedList<InterpreterCompletion> completions = new LinkedList<InterpreterCompletion>();
            for (String candidate : candidates) {
                completions.add(new InterpreterCompletion(candidate, candidate));
            }
            return completions;
        }
        return new LinkedList<InterpreterCompletion>();
    }

    private List<File> currentClassPath() {
        List<File> paths = this.classPath(Thread.currentThread().getContextClassLoader());
        String[] cps = System.getProperty("java.class.path").split(File.pathSeparator);
        if (cps != null) {
            for (String cp : cps) {
                paths.add(new File(cp));
            }
        }
        return paths;
    }

    private List<File> classPath(ClassLoader cl) {
        URLClassLoader ucl;
        URL[] urls;
        LinkedList<File> paths = new LinkedList<File>();
        if (cl == null) {
            return paths;
        }
        if (cl instanceof URLClassLoader && (urls = (ucl = (URLClassLoader)cl).getURLs()) != null) {
            for (URL url : urls) {
                paths.add(new File(url.getFile()));
            }
        }
        return paths;
    }

    private SparkInterpreter getSparkInterpreter() {
        InterpreterGroup intpGroup = this.getInterpreterGroup();
        if (intpGroup == null) {
            return null;
        }
        Interpreter p = this.getInterpreterInTheSameSessionByClassName(SparkInterpreter.class.getName());
        if (p == null) {
            return null;
        }
        while (p instanceof WrappedInterpreter) {
            p = ((WrappedInterpreter)((Object)p)).getInnerInterpreter();
        }
        return (SparkInterpreter)p;
    }

    @Override
    public Scheduler getScheduler() {
        SparkInterpreter sparkInterpreter = this.getSparkInterpreter();
        if (sparkInterpreter != null) {
            return this.getSparkInterpreter().getScheduler();
        }
        return null;
    }
}

