/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.spark;

import com.google.common.base.Joiner;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.repl.SparkILoop;
import org.apache.spark.scheduler.ActiveJob;
import org.apache.spark.scheduler.DAGScheduler;
import org.apache.spark.scheduler.Pool;
import org.apache.spark.scheduler.Schedulable;
import org.apache.spark.scheduler.SchedulingMode;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.ui.SparkUI;
import org.apache.spark.ui.jobs.JobProgressListener;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterHookRegistry;
import org.apache.zeppelin.interpreter.InterpreterProperty;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterUtils;
import org.apache.zeppelin.interpreter.WrappedInterpreter;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.interpreter.util.InterpreterOutputStream;
import org.apache.zeppelin.resource.ResourcePool;
import org.apache.zeppelin.resource.WellKnownResourceName;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.apache.zeppelin.spark.DepInterpreter;
import org.apache.zeppelin.spark.SparkVersion;
import org.apache.zeppelin.spark.Utils;
import org.apache.zeppelin.spark.ZeppelinContext;
import org.apache.zeppelin.spark.dep.SparkDependencyContext;
import org.apache.zeppelin.spark.dep.SparkDependencyResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Console;
import scala.Enumeration;
import scala.None;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.convert.WrapAsJava$;
import scala.collection.immutable.List;
import scala.collection.mutable.HashSet;
import scala.reflect.io.AbstractFile;
import scala.tools.nsc.Global;
import scala.tools.nsc.Settings;
import scala.tools.nsc.interpreter.Completion;
import scala.tools.nsc.interpreter.IMain;
import scala.tools.nsc.interpreter.Results;
import scala.tools.nsc.settings.AbsSettings;
import scala.tools.nsc.settings.MutableSettings;

public class SparkInterpreter
extends Interpreter {
    public static Logger logger = LoggerFactory.getLogger(SparkInterpreter.class);
    private ZeppelinContext z;
    private SparkILoop interpreter;
    private Object intp;
    private SparkConf conf;
    private static SparkContext sc;
    private static SQLContext sqlc;
    private static InterpreterHookRegistry hooks;
    private static SparkEnv env;
    private static Object sparkSession;
    private static JobProgressListener sparkListener;
    private static AbstractFile classOutputDir;
    private static Integer sharedInterpreterLock;
    private static AtomicInteger numReferenceOfSparkContext;
    private InterpreterOutputStream out = new InterpreterOutputStream(logger);
    private SparkDependencyResolver dep;
    private String sparkUrl;
    private Object completer = null;
    private java.util.Map<String, Object> binder;
    private SparkVersion sparkVersion;
    private static File outputDir;
    private Object classServer;
    private JavaSparkContext jsc;

    public SparkInterpreter(Properties property) {
        super(property);
    }

    public SparkInterpreter(Properties property, SparkContext sc) {
        this(property);
        SparkInterpreter.sc = sc;
        env = SparkEnv.get();
        sparkListener = SparkInterpreter.setupListeners(SparkInterpreter.sc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SparkContext getSparkContext() {
        Integer n = sharedInterpreterLock;
        synchronized (n) {
            if (sc == null) {
                sc = this.createSparkContext();
                env = SparkEnv.get();
                sparkListener = SparkInterpreter.setupListeners(sc);
            }
            return sc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaSparkContext getJavaSparkContext() {
        Integer n = sharedInterpreterLock;
        synchronized (n) {
            if (this.jsc == null) {
                this.jsc = JavaSparkContext.fromSparkContext((SparkContext)sc);
            }
            return this.jsc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSparkContextInitialized() {
        Integer n = sharedInterpreterLock;
        synchronized (n) {
            return sc != null;
        }
    }

    static JobProgressListener setupListeners(SparkContext context) {
        JobProgressListener pl = new JobProgressListener(context.getConf());
        try {
            Object listenerBus = context.getClass().getMethod("listenerBus", new Class[0]).invoke((Object)context, new Object[0]);
            Method[] methods = listenerBus.getClass().getMethods();
            Method addListenerMethod = null;
            for (Method m : methods) {
                Class<?>[] parameterTypes;
                if (!m.getName().equals("addListener") || (parameterTypes = m.getParameterTypes()).length != 1 || !parameterTypes[0].isAssignableFrom(JobProgressListener.class)) continue;
                addListenerMethod = m;
                break;
            }
            if (addListenerMethod == null) {
                return null;
            }
            addListenerMethod.invoke(listenerBus, pl);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            logger.error(e.toString(), e);
            return null;
        }
        return pl;
    }

    private boolean useHiveContext() {
        return Boolean.parseBoolean(this.getProperty("zeppelin.spark.useHiveContext"));
    }

    private boolean hiveClassesArePresent() {
        try {
            this.getClass();
            Class.forName("org.apache.spark.sql.hive.HiveSessionState");
            this.getClass();
            Class.forName("org.apache.hadoop.hive.conf.HiveConf");
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
    }

    private boolean importImplicit() {
        return Boolean.parseBoolean(this.getProperty("zeppelin.spark.importImplicit"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSparkSession() {
        Integer n = sharedInterpreterLock;
        synchronized (n) {
            if (sparkSession == null) {
                this.createSparkSession();
            }
            return sparkSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLContext getSQLContext() {
        Integer n = sharedInterpreterLock;
        synchronized (n) {
            if (Utils.isSpark2()) {
                return this.getSQLContext_2();
            }
            return this.getSQLContext_1();
        }
    }

    private SQLContext getSQLContext_2() {
        if (sqlc == null) {
            sqlc = (SQLContext)Utils.invokeMethod(sparkSession, "sqlContext");
        }
        return sqlc;
    }

    public SQLContext getSQLContext_1() {
        if (sqlc == null) {
            if (this.useHiveContext()) {
                String name = "org.apache.spark.sql.hive.HiveContext";
                try {
                    Constructor<?> hc = this.getClass().getClassLoader().loadClass(name).getConstructor(SparkContext.class);
                    sqlc = (SQLContext)hc.newInstance(this.getSparkContext());
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    logger.warn("Can't create HiveContext. Fallback to SQLContext", e);
                    sqlc = new SQLContext(this.getSparkContext());
                }
            } else {
                sqlc = new SQLContext(this.getSparkContext());
            }
        }
        return sqlc;
    }

    public SparkDependencyResolver getDependencyResolver() {
        if (this.dep == null) {
            this.dep = new SparkDependencyResolver((Global)Utils.invokeMethod(this.intp, "global"), (ClassLoader)Utils.invokeMethod(Utils.invokeMethod(this.intp, "classLoader"), "getParent"), sc, this.getProperty("zeppelin.dep.localrepo"), this.getProperty("zeppelin.dep.additionalRemoteRepository"));
        }
        return this.dep;
    }

    private DepInterpreter getDepInterpreter() {
        Interpreter p = this.getInterpreterInTheSameSessionByClassName(DepInterpreter.class.getName());
        if (p == null) {
            return null;
        }
        while (p instanceof WrappedInterpreter) {
            p = ((WrappedInterpreter)((Object)p)).getInnerInterpreter();
        }
        return (DepInterpreter)p;
    }

    public boolean isYarnMode() {
        return this.getProperty("master").startsWith("yarn");
    }

    public Object createSparkSession() {
        logger.info("------ Create new SparkContext {} -------", (Object)this.getProperty("master"));
        String execUri = System.getenv("SPARK_EXECUTOR_URI");
        this.conf.setAppName(this.getProperty("spark.app.name"));
        if (outputDir != null) {
            this.conf.set("spark.repl.class.outputDir", outputDir.getAbsolutePath());
        }
        if (execUri != null) {
            this.conf.set("spark.executor.uri", execUri);
        }
        if (System.getenv("SPARK_HOME") != null) {
            this.conf.setSparkHome(System.getenv("SPARK_HOME"));
        }
        this.conf.set("spark.scheduler.mode", "FAIR");
        this.conf.setMaster(this.getProperty("master"));
        if (this.isYarnMode()) {
            this.conf.set("master", "yarn");
            this.conf.set("spark.submit.deployMode", "client");
        }
        Properties intpProperty = this.getProperty();
        for (Object k : intpProperty.keySet()) {
            String key = (String)k;
            String val = SparkInterpreter.toString(intpProperty.get(key));
            if (!key.startsWith("spark.") || val.trim().isEmpty()) continue;
            logger.debug(String.format("SparkConf: key = [%s], value = [%s]", key, val));
            this.conf.set(key, val);
        }
        this.setupConfForPySpark(this.conf);
        this.setupConfForSparkR(this.conf);
        Class SparkSession = Utils.findClass("org.apache.spark.sql.SparkSession");
        Object builder = Utils.invokeStaticMethod(SparkSession, "builder");
        Utils.invokeMethod(builder, "config", new Class[]{SparkConf.class}, new Object[]{this.conf});
        if (this.useHiveContext()) {
            if (this.hiveClassesArePresent()) {
                Utils.invokeMethod(builder, "enableHiveSupport");
                sparkSession = Utils.invokeMethod(builder, "getOrCreate");
                logger.info("Created Spark session with Hive support");
            } else {
                Utils.invokeMethod(builder, "config", new Class[]{String.class, String.class}, new Object[]{"spark.sql.catalogImplementation", "in-memory"});
                sparkSession = Utils.invokeMethod(builder, "getOrCreate");
                logger.info("Created Spark session with Hive support use in-memory catalogImplementation");
            }
        } else {
            sparkSession = Utils.invokeMethod(builder, "getOrCreate");
            logger.info("Created Spark session");
        }
        return sparkSession;
    }

    public SparkContext createSparkContext() {
        if (Utils.isSpark2()) {
            return this.createSparkContext_2();
        }
        return this.createSparkContext_1();
    }

    private SparkContext createSparkContext_2() {
        return (SparkContext)Utils.invokeMethod(sparkSession, "sparkContext");
    }

    public SparkContext createSparkContext_1() {
        logger.info("------ Create new SparkContext {} -------", (Object)this.getProperty("master"));
        String execUri = System.getenv("SPARK_EXECUTOR_URI");
        String[] jars = null;
        jars = Utils.isScala2_10() ? (String[])Utils.invokeStaticMethod(SparkILoop.class, "getAddedJars") : (String[])Utils.invokeStaticMethod(Utils.findClass("org.apache.spark.repl.Main"), "getAddedJars");
        String classServerUri = null;
        String replClassOutputDirectory = null;
        try {
            Method classServer2 = this.intp.getClass().getMethod("classServer", new Class[0]);
            Object httpServer = classServer2.invoke(this.intp, new Object[0]);
            classServerUri = (String)Utils.invokeMethod(httpServer, "uri");
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException classServer2) {
            // empty catch block
        }
        if (classServerUri == null) {
            try {
                Method classServer = this.intp.getClass().getMethod("classServerUri", new Class[0]);
                classServerUri = (String)classServer.invoke(this.intp, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                logger.warn(String.format("Spark method classServerUri not available due to: [%s]", e.getMessage()));
            }
        }
        if (classServerUri == null) {
            try {
                Method getClassOutputDirectory = this.intp.getClass().getMethod("getClassOutputDirectory", new Class[0]);
                File classOutputDirectory = (File)getClassOutputDirectory.invoke(this.intp, new Object[0]);
                replClassOutputDirectory = classOutputDirectory.getAbsolutePath();
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException getClassOutputDirectory) {
                // empty catch block
            }
        }
        if (Utils.isScala2_11()) {
            this.classServer = this.createHttpServer(outputDir);
            Utils.invokeMethod(this.classServer, "start");
            classServerUri = (String)Utils.invokeMethod(this.classServer, "uri");
        }
        this.conf.setMaster(this.getProperty("master")).setAppName(this.getProperty("spark.app.name"));
        if (classServerUri != null) {
            this.conf.set("spark.repl.class.uri", classServerUri);
        }
        if (replClassOutputDirectory != null) {
            this.conf.set("spark.repl.class.outputDir", replClassOutputDirectory);
        }
        if (jars.length > 0) {
            this.conf.setJars(jars);
        }
        if (execUri != null) {
            this.conf.set("spark.executor.uri", execUri);
        }
        if (System.getenv("SPARK_HOME") != null) {
            this.conf.setSparkHome(System.getenv("SPARK_HOME"));
        }
        this.conf.set("spark.scheduler.mode", "FAIR");
        Properties intpProperty = this.getProperty();
        for (Object e : intpProperty.keySet()) {
            String key = (String)e;
            String val = SparkInterpreter.toString(intpProperty.get(key));
            if (!key.startsWith("spark.") || val.trim().isEmpty()) continue;
            logger.debug(String.format("SparkConf: key = [%s], value = [%s]", key, val));
            this.conf.set(key, val);
        }
        this.setupConfForPySpark(this.conf);
        this.setupConfForSparkR(this.conf);
        SparkContext sparkContext = new SparkContext(this.conf);
        return sparkContext;
    }

    private void setupConfForPySpark(SparkConf conf) {
        File pysparkPath;
        String pysparkBasePath = new InterpreterProperty("SPARK_HOME", null, null, null).getValue();
        if (null == pysparkBasePath) {
            pysparkBasePath = new InterpreterProperty("ZEPPELIN_HOME", "zeppelin.home", "../", null).getValue();
            pysparkPath = new File(pysparkBasePath, "interpreter" + File.separator + "spark" + File.separator + "pyspark");
        } else {
            pysparkPath = new File(pysparkBasePath, "python" + File.separator + "lib");
        }
        Object[] pythonLibs = new String[]{"pyspark.zip", "py4j-0.9-src.zip", "py4j-0.8.2.1-src.zip", "py4j-0.10.1-src.zip", "py4j-0.10.3-src.zip", "py4j-0.10.4-src.zip"};
        ArrayList<String> pythonLibUris = new ArrayList<String>();
        for (String string : pythonLibs) {
            File libFile = new File(pysparkPath, string);
            if (!libFile.exists()) continue;
            pythonLibUris.add(libFile.toURI().toString());
        }
        pythonLibUris.trimToSize();
        if (pythonLibUris.size() == 2) {
            try {
                String confValue = conf.get("spark.yarn.dist.files");
                conf.set("spark.yarn.dist.files", confValue + "," + Joiner.on(",").join(pythonLibUris));
            }
            catch (NoSuchElementException e) {
                conf.set("spark.yarn.dist.files", Joiner.on(",").join(pythonLibUris));
            }
            if (!SparkInterpreter.useSparkSubmit()) {
                conf.set("spark.files", conf.get("spark.yarn.dist.files"));
            }
            conf.set("spark.submit.pyArchives", Joiner.on(":").join(pythonLibs));
            conf.set("spark.submit.pyFiles", Joiner.on(",").join(pythonLibUris));
        }
        if (this.isYarnMode()) {
            conf.set("spark.yarn.isPython", "true");
        }
    }

    private void setupConfForSparkR(SparkConf conf) {
        File sparkRPath;
        String sparkRBasePath = new InterpreterProperty("SPARK_HOME", null, null, null).getValue();
        if (null == sparkRBasePath) {
            sparkRBasePath = new InterpreterProperty("ZEPPELIN_HOME", "zeppelin.home", "../", null).getValue();
            sparkRPath = new File(sparkRBasePath, "interpreter" + File.separator + "spark" + File.separator + "R");
        } else {
            sparkRPath = new File(sparkRBasePath, "R" + File.separator + "lib");
        }
        sparkRPath = new File(sparkRPath, "sparkr.zip");
        if (sparkRPath.exists() && sparkRPath.isFile()) {
            String archives = null;
            if (conf.contains("spark.yarn.dist.archives")) {
                archives = conf.get("spark.yarn.dist.archives");
            }
            archives = archives != null ? archives + "," + sparkRPath + "#sparkr" : sparkRPath + "#sparkr";
            conf.set("spark.yarn.dist.archives", archives);
        } else {
            logger.warn("sparkr.zip is not found, sparkr may not work.");
        }
    }

    static final String toString(Object o) {
        return o instanceof String ? (String)o : "";
    }

    public static boolean useSparkSubmit() {
        return null != System.getenv("SPARK_SUBMIT");
    }

    public boolean printREPLOutput() {
        return Boolean.parseBoolean(this.getProperty("zeppelin.spark.printREPLOutput"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        File file;
        File[] files;
        SparkDependencyContext sparkDependencyContext;
        File[] files2;
        File localRepoDir2;
        String classpath;
        Object sparkCommandLine;
        java.util.List<File> files3;
        SparkDependencyContext depc2;
        if (this.isYarnMode()) {
            System.setProperty("SPARK_YARN_MODE", "true");
        }
        if (this.getProperty().containsKey("spark.yarn.keytab") && this.getProperty().containsKey("spark.yarn.principal")) {
            try {
                String keytab = this.getProperty().getProperty("spark.yarn.keytab");
                String principal = this.getProperty().getProperty("spark.yarn.principal");
                UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab);
            }
            catch (IOException e) {
                throw new RuntimeException("Can not pass kerberos authentication", e);
            }
        }
        this.conf = new SparkConf();
        URL[] urls = this.getClassloaderUrls();
        Settings settings = new Settings();
        String args = this.getProperty("args");
        if (args == null) {
            args = "";
        }
        String[] argsArray = args.split(" ");
        LinkedList<String> argList = new LinkedList<String>();
        for (String arg : argsArray) {
            argList.add(arg);
        }
        DepInterpreter depInterpreter = this.getDepInterpreter();
        String depInterpreterClasspath = "";
        if (depInterpreter != null && (depc2 = depInterpreter.getDependencyContext()) != null && (files3 = depc2.getFiles()) != null) {
            for (File file2 : files3) {
                if (depInterpreterClasspath.length() > 0) {
                    depInterpreterClasspath = depInterpreterClasspath + File.pathSeparator;
                }
                depInterpreterClasspath = depInterpreterClasspath + file2.getAbsolutePath();
            }
        }
        if (Utils.isScala2_10()) {
            List list = JavaConversions.asScalaBuffer(argList).toList();
            sparkCommandLine = Utils.instantiateClass("org.apache.spark.repl.SparkCommandLine", new Class[]{List.class}, new Object[]{list});
            settings = (Settings)Utils.invokeMethod(sparkCommandLine, "settings");
        } else {
            String sparkReplClassDir = this.getProperty("spark.repl.classdir");
            if (sparkReplClassDir == null) {
                sparkReplClassDir = System.getProperty("spark.repl.classdir");
            }
            if (sparkReplClassDir == null) {
                sparkReplClassDir = System.getProperty("java.io.tmpdir");
            }
            sparkCommandLine = sharedInterpreterLock;
            synchronized (sparkCommandLine) {
                if (outputDir == null) {
                    outputDir = this.createTempDir(sparkReplClassDir);
                }
            }
            argList.add("-Yrepl-class-based");
            argList.add("-Yrepl-outdir");
            argList.add(outputDir.getAbsolutePath());
            classpath = "";
            if (this.conf.contains("spark.jars")) {
                classpath = StringUtils.join((Object[])this.conf.get("spark.jars").split(","), (String)File.separator);
            }
            if (!depInterpreterClasspath.isEmpty()) {
                if (!classpath.isEmpty()) {
                    classpath = classpath + File.separator;
                }
                classpath = classpath + depInterpreterClasspath;
            }
            if (!classpath.isEmpty()) {
                argList.add("-classpath");
                argList.add(classpath);
            }
            List list = JavaConversions.asScalaBuffer(argList).toList();
            settings.processArguments(list, true);
        }
        MutableSettings.PathSetting pathSettings = settings.classpath();
        classpath = "";
        java.util.List<File> paths = this.currentClassPath();
        for (File f : paths) {
            if (classpath.length() > 0) {
                classpath = classpath + File.pathSeparator;
            }
            classpath = classpath + f.getAbsolutePath();
        }
        if (urls != null) {
            for (URL uRL : urls) {
                if (classpath.length() > 0) {
                    classpath = classpath + File.pathSeparator;
                }
                classpath = classpath + uRL.getFile();
            }
        }
        if (classpath.length() > 0) {
            classpath = classpath + File.pathSeparator;
        }
        classpath = classpath + depInterpreterClasspath;
        String string = this.getProperty("zeppelin.interpreter.localRepo");
        if (string != null && (localRepoDir2 = new File(string)).exists() && (files2 = localRepoDir2.listFiles()) != null) {
            for (File f : files2) {
                if (classpath.length() > 0) {
                    classpath = classpath + File.pathSeparator;
                }
                classpath = classpath + f.getAbsolutePath();
            }
        }
        pathSettings.v_$eq(classpath);
        settings.scala$tools$nsc$settings$ScalaSettings$_setter_$classpath_$eq(pathSettings);
        settings.explicitParentLoader_$eq((Option)new Some((Object)Thread.currentThread().getContextClassLoader()));
        MutableSettings.BooleanSetting b = (MutableSettings.BooleanSetting)settings.usejavacp();
        b.v_$eq(true);
        settings.scala$tools$nsc$settings$StandardScalaSettings$_setter_$usejavacp_$eq((AbsSettings.AbsSetting)b);
        System.setProperty("scala.repl.name.line", ("$line" + this.hashCode()).replace('-', '0'));
        MutableSettings.IntSetting numClassFileSetting = settings.maxClassfileName();
        numClassFileSetting.v_$eq(128);
        settings.scala$tools$nsc$settings$ScalaSettings$_setter_$maxClassfileName_$eq(numClassFileSetting);
        Integer n = sharedInterpreterLock;
        synchronized (n) {
            this.interpreter = this.printREPLOutput() ? new SparkILoop((BufferedReader)null, new PrintWriter(this.out)) : new SparkILoop((BufferedReader)null, new PrintWriter(Console.out(), false));
            this.interpreter.settings_$eq(settings);
            this.interpreter.createInterpreter();
            this.intp = Utils.invokeMethod(this.interpreter, "intp");
            Utils.invokeMethod(this.intp, "setContextClassLoader");
            Utils.invokeMethod(this.intp, "initializeSynchronous");
            if (Utils.isScala2_10()) {
                if (classOutputDir == null) {
                    classOutputDir = (AbstractFile)settings.outputDirs().getSingleOutput().get();
                } else {
                    settings.outputDirs().setSingleOutput(classOutputDir);
                    ClassLoader cl = (ClassLoader)Utils.invokeMethod(this.intp, "classLoader");
                    try {
                        Field rootField = cl.getClass().getSuperclass().getDeclaredField("root");
                        rootField.setAccessible(true);
                        rootField.set(cl, classOutputDir);
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        logger.error(e.getMessage(), e);
                    }
                }
            }
            if (Utils.findClass("org.apache.spark.repl.SparkJLineCompletion", true) != null) {
                this.completer = Utils.instantiateClass("org.apache.spark.repl.SparkJLineCompletion", new Class[]{Utils.findClass("org.apache.spark.repl.SparkIMain")}, new Object[]{this.intp});
            } else if (Utils.findClass("scala.tools.nsc.interpreter.PresentationCompilerCompleter", true) != null) {
                this.completer = Utils.instantiateClass("scala.tools.nsc.interpreter.PresentationCompilerCompleter", new Class[]{IMain.class}, new Object[]{this.intp});
            } else if (Utils.findClass("scala.tools.nsc.interpreter.JLineCompletion", true) != null) {
                this.completer = Utils.instantiateClass("scala.tools.nsc.interpreter.JLineCompletion", new Class[]{IMain.class}, new Object[]{this.intp});
            }
            if (Utils.isSpark2()) {
                sparkSession = this.getSparkSession();
            }
            if ((sc = this.getSparkContext()).getPoolForName("fair").isEmpty()) {
                Enumeration.Value schedulingMode = SchedulingMode.FAIR();
                int minimumShare = 0;
                int weight = 1;
                Pool pool = new Pool("fair", schedulingMode, minimumShare, weight);
                sc.taskScheduler().rootPool().addSchedulable((Schedulable)pool);
            }
            this.sparkVersion = SparkVersion.fromVersionString(sc.version());
            sqlc = this.getSQLContext();
            this.dep = this.getDependencyResolver();
            hooks = this.getInterpreterGroup().getInterpreterHookRegistry();
            this.z = new ZeppelinContext(sc, sqlc, null, this.dep, hooks, Integer.parseInt(this.getProperty("zeppelin.spark.maxResult")));
            this.interpret("@transient val _binder = new java.util.HashMap[String, Object]()");
            java.util.Map binder = Utils.isScala2_10() ? (java.util.Map)this.getValue("_binder") : (java.util.Map)this.getLastObject();
            binder.put("sc", sc);
            binder.put("sqlc", sqlc);
            binder.put("z", this.z);
            if (Utils.isSpark2()) {
                binder.put("spark", sparkSession);
            }
            this.interpret("@transient val z = _binder.get(\"z\").asInstanceOf[org.apache.zeppelin.spark.ZeppelinContext]");
            this.interpret("@transient val sc = _binder.get(\"sc\").asInstanceOf[org.apache.spark.SparkContext]");
            this.interpret("@transient val sqlc = _binder.get(\"sqlc\").asInstanceOf[org.apache.spark.sql.SQLContext]");
            this.interpret("@transient val sqlContext = _binder.get(\"sqlc\").asInstanceOf[org.apache.spark.sql.SQLContext]");
            if (Utils.isSpark2()) {
                this.interpret("@transient val spark = _binder.get(\"spark\").asInstanceOf[org.apache.spark.sql.SparkSession]");
            }
            this.interpret("import org.apache.spark.SparkContext._");
            if (this.importImplicit()) {
                if (Utils.isSpark2()) {
                    this.interpret("import spark.implicits._");
                    this.interpret("import spark.sql");
                    this.interpret("import org.apache.spark.sql.functions._");
                } else if (this.sparkVersion.oldSqlContextImplicits()) {
                    this.interpret("import sqlContext._");
                } else {
                    this.interpret("import sqlContext.implicits._");
                    this.interpret("import sqlContext.sql");
                    this.interpret("import org.apache.spark.sql.functions._");
                }
            }
        }
        if (Utils.isScala2_10()) {
            try {
                if (this.sparkVersion.oldLoadFilesMethodName()) {
                    Method method = this.interpreter.getClass().getMethod("loadFiles", Settings.class);
                    method.invoke((Object)this.interpreter, settings);
                } else {
                    Method method = this.interpreter.getClass().getMethod("org$apache$spark$repl$SparkILoop$$loadFiles", Settings.class);
                    method.invoke((Object)this.interpreter, settings);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                throw new InterpreterException(exception);
            }
        }
        if (depInterpreter != null && (sparkDependencyContext = depInterpreter.getDependencyContext()) != null && (files = sparkDependencyContext.getFilesDist()) != null) {
            for (File f : files) {
                if (f.getName().toLowerCase().endsWith(".jar")) {
                    sc.addJar(f.getAbsolutePath());
                    logger.info("sc.addJar(" + f.getAbsolutePath() + ")");
                    continue;
                }
                sc.addFile(f.getAbsolutePath());
                logger.info("sc.addFile(" + f.getAbsolutePath() + ")");
            }
        }
        if (string != null && (file = new File(string)).exists() && (files = file.listFiles()) != null) {
            for (File f : files) {
                if (f.getName().toLowerCase().endsWith(".jar")) {
                    sc.addJar(f.getAbsolutePath());
                    logger.info("sc.addJar(" + f.getAbsolutePath() + ")");
                    continue;
                }
                sc.addFile(f.getAbsolutePath());
                logger.info("sc.addFile(" + f.getAbsolutePath() + ")");
            }
        }
        numReferenceOfSparkContext.incrementAndGet();
    }

    private String getSparkUIUrl() {
        Option sparkUiOption = (Option)Utils.invokeMethod(sc, "ui");
        SparkUI sparkUi = (SparkUI)sparkUiOption.get();
        String sparkWebUrl = sparkUi.appUIAddress();
        return sparkWebUrl;
    }

    private Results.Result interpret(String line) {
        return (Results.Result)Utils.invokeMethod(this.intp, "interpret", new Class[]{String.class}, new Object[]{line});
    }

    public void populateSparkWebUrl(InterpreterContext ctx) {
        if (this.sparkUrl == null) {
            this.sparkUrl = this.getSparkUIUrl();
            HashMap<String, String> infos = new HashMap<String, String>();
            if (this.sparkUrl != null) {
                infos.put("url", this.sparkUrl);
                logger.info("Sending metainfos to Zeppelin server: {}", (Object)((Object)infos).toString());
                if (ctx != null && ctx.getClient() != null) {
                    ctx.getClient().onMetaInfosReceived(infos);
                }
            }
        }
    }

    public java.util.List<File> currentClassPath() {
        java.util.List<File> paths = this.classPath(Thread.currentThread().getContextClassLoader());
        String[] cps = System.getProperty("java.class.path").split(File.pathSeparator);
        if (cps != null) {
            for (String cp : cps) {
                paths.add(new File(cp));
            }
        }
        return paths;
    }

    private java.util.List<File> classPath(ClassLoader cl) {
        URLClassLoader ucl;
        URL[] urls;
        LinkedList<File> paths = new LinkedList<File>();
        if (cl == null) {
            return paths;
        }
        if (cl instanceof URLClassLoader && (urls = (ucl = (URLClassLoader)cl).getURLs()) != null) {
            for (URL url : urls) {
                paths.add(new File(url.getFile()));
            }
        }
        return paths;
    }

    @Override
    public java.util.List<InterpreterCompletion> completion(String buf, int cursor) {
        String completionText;
        if (this.completer == null) {
            logger.warn("Can't find completer");
            return new LinkedList<InterpreterCompletion>();
        }
        if (buf.length() < cursor) {
            cursor = buf.length();
        }
        if ((completionText = this.getCompletionTargetString(buf, cursor)) == null) {
            completionText = "";
            cursor = completionText.length();
        }
        Completion.ScalaCompleter c = (Completion.ScalaCompleter)Utils.invokeMethod(this.completer, "completer");
        Completion.Candidates ret = c.complete(completionText, cursor);
        java.util.List candidates = WrapAsJava$.MODULE$.seqAsJavaList((Seq)ret.candidates());
        LinkedList<InterpreterCompletion> completions = new LinkedList<InterpreterCompletion>();
        for (String candidate : candidates) {
            completions.add(new InterpreterCompletion(candidate, candidate));
        }
        return completions;
    }

    private String getCompletionTargetString(String text, int cursor) {
        String[] completionSeqCharaters = new String[]{" ", "\n", "\t"};
        int completionEndPosition = cursor;
        int completionStartPosition = cursor;
        int indexOfReverseSeqPostion = cursor;
        String resultCompletionText = "";
        String completionScriptText = "";
        try {
            completionScriptText = text.substring(0, cursor);
        }
        catch (Exception e) {
            logger.error(e.toString());
            return null;
        }
        completionEndPosition = completionScriptText.length();
        String tempReverseCompletionText = new StringBuilder(completionScriptText).reverse().toString();
        for (String seqCharacter : completionSeqCharaters) {
            indexOfReverseSeqPostion = tempReverseCompletionText.indexOf(seqCharacter);
            if (indexOfReverseSeqPostion >= completionStartPosition || indexOfReverseSeqPostion <= 0) continue;
            completionStartPosition = indexOfReverseSeqPostion;
        }
        completionStartPosition = completionStartPosition == completionEndPosition ? 0 : completionEndPosition - completionStartPosition;
        resultCompletionText = completionScriptText.substring(completionStartPosition, completionEndPosition);
        return resultCompletionText;
    }

    public Object getValue(String name) {
        Object ret = Utils.invokeMethod(this.intp, "valueOfTerm", new Class[]{String.class}, new Object[]{name});
        if (ret instanceof None || ret instanceof None$) {
            return null;
        }
        if (ret instanceof Some) {
            return ((Some)ret).get();
        }
        return ret;
    }

    public Object getLastObject() {
        IMain.Request r = (IMain.Request)Utils.invokeMethod(this.intp, "lastRequest");
        if (r == null || r.lineRep() == null) {
            return null;
        }
        Object obj = r.lineRep().call("$result", (Seq)JavaConversions.asScalaBuffer(new LinkedList()));
        return obj;
    }

    String getJobGroup(InterpreterContext context) {
        return "zeppelin-" + context.getParagraphId();
    }

    @Override
    public InterpreterResult interpret(String line, InterpreterContext context) {
        if (this.sparkVersion.isUnsupportedVersion()) {
            return new InterpreterResult(InterpreterResult.Code.ERROR, "Spark " + this.sparkVersion.toString() + " is not supported");
        }
        this.populateSparkWebUrl(context);
        this.z.setInterpreterContext(context);
        if (line == null || line.trim().length() == 0) {
            return new InterpreterResult(InterpreterResult.Code.SUCCESS);
        }
        return this.interpret(line.split("\n"), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterpreterResult interpret(String[] lines, InterpreterContext context) {
        SparkInterpreter sparkInterpreter = this;
        synchronized (sparkInterpreter) {
            this.z.setGui(context.getGui());
            sc.setJobGroup(this.getJobGroup(context), "Zeppelin", false);
            InterpreterResult r = this.interpretInput(lines, context);
            sc.clearJobGroup();
            return r;
        }
    }

    public InterpreterResult interpretInput(String[] lines, InterpreterContext context) {
        SparkEnv.set((SparkEnv)env);
        String[] linesToRun = new String[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            linesToRun[i] = lines[i];
        }
        Console.setOut((OutputStream)context.out);
        this.out.setInterpreterOutput(context.out);
        context.out.clear();
        InterpreterResult.Code r = null;
        String incomplete = "";
        boolean inComment = false;
        for (int l = 0; l < linesToRun.length; ++l) {
            String s = linesToRun[l];
            if (l + 1 < linesToRun.length) {
                String nextLine = linesToRun[l + 1].trim();
                boolean continuation = false;
                if (nextLine.isEmpty() || nextLine.startsWith("//") || nextLine.startsWith("}") || nextLine.startsWith("object")) {
                    continuation = true;
                } else if (!inComment && nextLine.startsWith("/*")) {
                    inComment = true;
                    continuation = true;
                } else if (inComment && nextLine.lastIndexOf("*/") >= 0) {
                    inComment = false;
                    continuation = true;
                } else if (nextLine.length() > 1 && nextLine.charAt(0) == '.' && nextLine.charAt(1) != '.' && nextLine.charAt(1) != '/') {
                    continuation = true;
                } else if (inComment) {
                    continuation = true;
                }
                if (continuation) {
                    incomplete = incomplete + s + "\n";
                    continue;
                }
            }
            Results.Result res = null;
            try {
                res = this.interpret(incomplete + s);
            }
            catch (Exception e) {
                sc.clearJobGroup();
                this.out.setInterpreterOutput(null);
                logger.info("Interpreter exception", e);
                return new InterpreterResult(InterpreterResult.Code.ERROR, InterpreterUtils.getMostRelevantMessage(e));
            }
            r = this.getResultCode(res);
            if (r == InterpreterResult.Code.ERROR) {
                sc.clearJobGroup();
                this.out.setInterpreterOutput(null);
                return new InterpreterResult(r, "");
            }
            incomplete = r == InterpreterResult.Code.INCOMPLETE ? incomplete + s + "\n" : "";
        }
        if (r == InterpreterResult.Code.INCOMPLETE) {
            Results.Result res = null;
            res = this.interpret(incomplete + "\nprint(\"\")");
            r = this.getResultCode(res);
        }
        if (r == InterpreterResult.Code.INCOMPLETE) {
            sc.clearJobGroup();
            this.out.setInterpreterOutput(null);
            return new InterpreterResult(r, "Incomplete expression");
        }
        sc.clearJobGroup();
        this.putLatestVarInResourcePool(context);
        this.out.setInterpreterOutput(null);
        return new InterpreterResult(InterpreterResult.Code.SUCCESS);
    }

    private void putLatestVarInResourcePool(InterpreterContext context) {
        String varName = (String)Utils.invokeMethod(this.intp, "mostRecentVar");
        if (varName == null || varName.isEmpty()) {
            return;
        }
        Object lastObj = null;
        try {
            lastObj = Utils.isScala2_10() ? this.getValue(varName) : this.getLastObject();
        }
        catch (NullPointerException e) {
            logger.error(e.getMessage(), e);
        }
        if (lastObj != null) {
            ResourcePool resourcePool = context.getResourcePool();
            resourcePool.put(context.getNoteId(), context.getParagraphId(), WellKnownResourceName.ZeppelinReplResult.toString(), lastObj);
        }
    }

    @Override
    public void cancel(InterpreterContext context) {
        sc.cancelJobGroup(this.getJobGroup(context));
    }

    @Override
    public int getProgress(InterpreterContext context) {
        String jobGroup = this.getJobGroup(context);
        int completedTasks = 0;
        int totalTasks = 0;
        DAGScheduler scheduler = sc.dagScheduler();
        if (scheduler == null) {
            return 0;
        }
        HashSet jobs = scheduler.activeJobs();
        if (jobs == null || jobs.size() == 0) {
            return 0;
        }
        for (ActiveJob job : jobs) {
            String g = (String)job.properties().get("spark.jobGroup.id");
            if (!jobGroup.equals(g)) continue;
            int[] progressInfo = null;
            try {
                Object finalStage = job.getClass().getMethod("finalStage", new Class[0]).invoke((Object)job, new Object[0]);
                progressInfo = this.sparkVersion.getProgress1_0() ? this.getProgressFromStage_1_0x(sparkListener, finalStage) : this.getProgressFromStage_1_1x(sparkListener, finalStage);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                logger.error("Can't get progress info", e);
                return 0;
            }
            totalTasks += progressInfo[0];
            completedTasks += progressInfo[1];
        }
        if (totalTasks == 0) {
            return 0;
        }
        return completedTasks * 100 / totalTasks;
    }

    private int[] getProgressFromStage_1_0x(JobProgressListener sparkListener, Object stage) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        java.util.List parents;
        int numTasks = (Integer)stage.getClass().getMethod("numTasks", new Class[0]).invoke(stage, new Object[0]);
        int completedTasks = 0;
        int id = (Integer)stage.getClass().getMethod("id", new Class[0]).invoke(stage, new Object[0]);
        Object completedTaskInfo = null;
        completedTaskInfo = JavaConversions.mapAsJavaMap((Map)((scala.collection.mutable.HashMap)sparkListener.getClass().getMethod("stageIdToTasksComplete", new Class[0]).invoke((Object)sparkListener, new Object[0]))).get(id);
        if (completedTaskInfo != null) {
            completedTasks += ((Integer)completedTaskInfo).intValue();
        }
        if ((parents = JavaConversions.seqAsJavaList((Seq)((Seq)stage.getClass().getMethod("parents", new Class[0]).invoke(stage, new Object[0])))) != null) {
            for (Object s : parents) {
                int[] p = this.getProgressFromStage_1_0x(sparkListener, s);
                numTasks += p[0];
                completedTasks += p[1];
            }
        }
        return new int[]{numTasks, completedTasks};
    }

    private int[] getProgressFromStage_1_1x(JobProgressListener sparkListener, Object stage) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        int numTasks = (Integer)stage.getClass().getMethod("numTasks", new Class[0]).invoke(stage, new Object[0]);
        int completedTasks = 0;
        int id = (Integer)stage.getClass().getMethod("id", new Class[0]).invoke(stage, new Object[0]);
        try {
            Method stageIdToData = sparkListener.getClass().getMethod("stageIdToData", new Class[0]);
            scala.collection.mutable.HashMap stageIdData = (scala.collection.mutable.HashMap)stageIdToData.invoke((Object)sparkListener, new Object[0]);
            this.getClass();
            Class<?> stageUIDataClass = Class.forName("org.apache.spark.ui.jobs.UIData$StageUIData");
            Method numCompletedTasks = stageUIDataClass.getMethod("numCompleteTasks", new Class[0]);
            java.util.Set keys = (java.util.Set)JavaConverters.setAsJavaSetConverter((Set)stageIdData.keySet()).asJava();
            for (Tuple2 k : keys) {
                if (id != (Integer)k._1()) continue;
                Object uiData = stageIdData.get((Object)k).get();
                completedTasks += ((Integer)numCompletedTasks.invoke(uiData, new Object[0])).intValue();
            }
        }
        catch (Exception e) {
            logger.error("Error on getting progress information", e);
        }
        java.util.List parents = JavaConversions.seqAsJavaList((Seq)((Seq)stage.getClass().getMethod("parents", new Class[0]).invoke(stage, new Object[0])));
        if (parents != null) {
            for (Object s : parents) {
                int[] p = this.getProgressFromStage_1_1x(sparkListener, s);
                numTasks += p[0];
                completedTasks += p[1];
            }
        }
        return new int[]{numTasks, completedTasks};
    }

    private InterpreterResult.Code getResultCode(Results.Result r) {
        if (r instanceof Results.Success$) {
            return InterpreterResult.Code.SUCCESS;
        }
        if (r instanceof Results.Incomplete$) {
            return InterpreterResult.Code.INCOMPLETE;
        }
        return InterpreterResult.Code.ERROR;
    }

    @Override
    public void close() {
        logger.info("Close interpreter");
        if (numReferenceOfSparkContext.decrementAndGet() == 0) {
            if (sparkSession != null) {
                Utils.invokeMethod(sparkSession, "stop");
            } else if (sc != null) {
                sc.stop();
            }
            sparkSession = null;
            sc = null;
            this.jsc = null;
            if (this.classServer != null) {
                Utils.invokeMethod(this.classServer, "stop");
                this.classServer = null;
            }
        }
        Utils.invokeMethod(this.intp, "close");
    }

    @Override
    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.NATIVE;
    }

    public JobProgressListener getJobProgressListener() {
        return sparkListener;
    }

    @Override
    public Scheduler getScheduler() {
        return SchedulerFactory.singleton().createOrGetFIFOScheduler(SparkInterpreter.class.getName() + this.hashCode());
    }

    public ZeppelinContext getZeppelinContext() {
        return this.z;
    }

    public SparkVersion getSparkVersion() {
        return this.sparkVersion;
    }

    private File createTempDir(String dir) {
        File file = null;
        file = (File)Utils.invokeStaticMethod(Utils.findClass("org.apache.spark.util.Utils"), "createTempDir", new Class[]{String.class, String.class}, new Object[]{dir, "spark"});
        if (file == null) {
            file = (File)Utils.invokeStaticMethod(Utils.findClass("org.apache.spark.util.Utils"), "createTempDir", new Class[]{String.class}, new Object[]{dir});
        }
        return file;
    }

    private Object createHttpServer(File outputDir) {
        SparkConf conf = new SparkConf();
        try {
            Constructor<?> constructor = this.getClass().getClassLoader().loadClass("org.apache.spark.HttpServer").getConstructor(SparkConf.class, File.class, SecurityManager.class, Integer.TYPE, String.class);
            Object securityManager = this.createSecurityManager(conf);
            return constructor.newInstance(conf, outputDir, securityManager, 0, "HTTP Server");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Constructor<?> constructor = null;
            try {
                constructor = this.getClass().getClassLoader().loadClass("org.apache.spark.HttpServer").getConstructor(File.class, SecurityManager.class, Integer.TYPE, String.class);
                return constructor.newInstance(outputDir, this.createSecurityManager(conf), 0, "HTTP Server");
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e1) {
                logger.error(e1.getMessage(), e1);
                return null;
            }
        }
    }

    private Object createSecurityManager(SparkConf conf) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object securityManager = null;
        try {
            Constructor<?> smConstructor = this.getClass().getClassLoader().loadClass("org.apache.spark.SecurityManager").getConstructor(SparkConf.class, Option.class);
            securityManager = smConstructor.newInstance(conf, null);
        }
        catch (NoSuchMethodException e) {
            Constructor<?> smConstructor = this.getClass().getClassLoader().loadClass("org.apache.spark.SecurityManager").getConstructor(SparkConf.class);
            securityManager = smConstructor.newInstance(conf);
        }
        return securityManager;
    }

    static {
        sharedInterpreterLock = new Integer(0);
        numReferenceOfSparkContext = new AtomicInteger(0);
    }
}

