/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.spark;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkRBackend;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.r.RBackend;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.LazyOpenInterpreter;
import org.apache.zeppelin.interpreter.WrappedInterpreter;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.apache.zeppelin.spark.RDisplay;
import org.apache.zeppelin.spark.SparkInterpreter;
import org.apache.zeppelin.spark.SparkVersion;
import org.apache.zeppelin.spark.Utils;
import org.apache.zeppelin.spark.ZeppelinR;
import org.apache.zeppelin.spark.ZeppelinRContext;
import org.apache.zeppelin.spark.ZeppelinRDisplay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkRInterpreter
extends Interpreter {
    private static final Logger logger = LoggerFactory.getLogger(SparkRInterpreter.class);
    private static String renderOptions;
    private SparkInterpreter sparkInterpreter;
    private ZeppelinR zeppelinR;
    private SparkContext sc;
    private JavaSparkContext jsc;

    public SparkRInterpreter(Properties property) {
        super(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        String sparkRLibPath;
        String rCmdPath = this.getProperty("zeppelin.R.cmd");
        if (System.getenv("SPARK_HOME") != null) {
            sparkRLibPath = System.getenv("SPARK_HOME") + "/R/lib";
        } else {
            sparkRLibPath = System.getenv("ZEPPELIN_HOME") + "/interpreter/spark/R/lib";
            System.setProperty("spark.test.home", System.getenv("ZEPPELIN_HOME") + "/interpreter/spark");
        }
        RBackend rBackend = SparkRBackend.backend();
        synchronized (rBackend) {
            if (!SparkRBackend.isStarted()) {
                SparkRBackend.init();
                SparkRBackend.start();
            }
        }
        int port = SparkRBackend.port();
        this.sparkInterpreter = this.getSparkInterpreter();
        this.sc = this.sparkInterpreter.getSparkContext();
        this.jsc = this.sparkInterpreter.getJavaSparkContext();
        SparkVersion sparkVersion = new SparkVersion(this.sc.version());
        ZeppelinRContext.setSparkContext(this.sc);
        ZeppelinRContext.setJavaSparkContext(this.jsc);
        if (Utils.isSpark2()) {
            ZeppelinRContext.setSparkSession(this.sparkInterpreter.getSparkSession());
        }
        ZeppelinRContext.setSqlContext(this.sparkInterpreter.getSQLContext());
        ZeppelinRContext.setZeppelinContext(this.sparkInterpreter.getZeppelinContext());
        this.zeppelinR = new ZeppelinR(rCmdPath, sparkRLibPath, port, sparkVersion);
        try {
            this.zeppelinR.open();
        }
        catch (IOException e) {
            logger.error("Exception while opening SparkRInterpreter", e);
            throw new InterpreterException(e);
        }
        if (this.useKnitr()) {
            this.zeppelinR.eval("library('knitr')");
        }
        renderOptions = this.getProperty("zeppelin.R.render.options");
    }

    String getJobGroup(InterpreterContext context) {
        return "zeppelin-" + context.getParagraphId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InterpreterResult interpret(String lines, InterpreterContext interpreterContext) {
        Object html;
        block16: {
            this.getSparkInterpreter().populateSparkWebUrl(interpreterContext);
            String imageWidth = this.getProperty("zeppelin.R.image.width");
            String[] sl = lines.split("\n");
            if (sl[0].contains("{") && sl[0].contains("}")) {
                String jsonConfig = sl[0].substring(sl[0].indexOf("{"), sl[0].indexOf("}") + 1);
                ObjectMapper m = new ObjectMapper();
                try {
                    JsonNode rootNode = m.readTree(jsonConfig);
                    JsonNode imageWidthNode = rootNode.path("imageWidth");
                    if (!imageWidthNode.isMissingNode()) {
                        imageWidth = imageWidthNode.textValue();
                    }
                }
                catch (Exception e) {
                    logger.warn("Can not parse json config: " + jsonConfig, e);
                }
                finally {
                    lines = lines.replace(jsonConfig, "");
                }
            }
            String jobGroup = this.getJobGroup(interpreterContext);
            String setJobGroup = "";
            if (Utils.isSpark2()) {
                setJobGroup = "dummy__ <- setJobGroup(\"" + jobGroup + "\", \"zeppelin sparkR job group description\", TRUE)";
            } else if (this.getSparkInterpreter().getSparkVersion().newerThanEquals(SparkVersion.SPARK_1_5_0)) {
                setJobGroup = "dummy__ <- setJobGroup(sc, \"" + jobGroup + "\", \"zeppelin sparkR job group description\", TRUE)";
            }
            logger.debug("set JobGroup:" + setJobGroup);
            lines = setJobGroup + "\n" + lines;
            if (!this.useKnitr()) break block16;
            this.zeppelinR.setInterpreterOutput(null);
            this.zeppelinR.set(".zcmd", "\n```{r " + renderOptions + "}\n" + lines + "\n```");
            this.zeppelinR.eval(".zres <- knit2html(text=.zcmd)");
            html = this.zeppelinR.getS0(".zres");
            RDisplay rDisplay = ZeppelinRDisplay.render((String)html, imageWidth);
            InterpreterResult interpreterResult = new InterpreterResult(rDisplay.code(), rDisplay.type(), rDisplay.content());
            return interpreterResult;
        }
        try {
            this.zeppelinR.setInterpreterOutput(interpreterContext.out);
            this.zeppelinR.eval(lines);
            html = new InterpreterResult(InterpreterResult.Code.SUCCESS, "");
            return html;
        }
        catch (Exception e) {
            logger.error("Exception while connecting to R", e);
            InterpreterResult interpreterResult = new InterpreterResult(InterpreterResult.Code.ERROR, e.getMessage());
            return interpreterResult;
        }
    }

    @Override
    public void close() {
        this.zeppelinR.close();
    }

    @Override
    public void cancel(InterpreterContext context) {
        if (this.sc != null) {
            this.sc.cancelJobGroup(this.getJobGroup(context));
        }
    }

    @Override
    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.NONE;
    }

    @Override
    public int getProgress(InterpreterContext context) {
        if (this.sparkInterpreter != null) {
            return this.sparkInterpreter.getProgress(context);
        }
        return 0;
    }

    @Override
    public Scheduler getScheduler() {
        return SchedulerFactory.singleton().createOrGetFIFOScheduler(SparkRInterpreter.class.getName() + this.hashCode());
    }

    @Override
    public List<InterpreterCompletion> completion(String buf, int cursor) {
        return new ArrayList<InterpreterCompletion>();
    }

    private SparkInterpreter getSparkInterpreter() {
        LazyOpenInterpreter lazy = null;
        SparkInterpreter spark = null;
        Interpreter p = this.getInterpreterInTheSameSessionByClassName(SparkInterpreter.class.getName());
        while (p instanceof WrappedInterpreter) {
            if (p instanceof LazyOpenInterpreter) {
                lazy = (LazyOpenInterpreter)p;
            }
            p = ((WrappedInterpreter)((Object)p)).getInnerInterpreter();
        }
        spark = (SparkInterpreter)p;
        if (lazy != null) {
            lazy.open();
        }
        return spark;
    }

    private boolean useKnitr() {
        try {
            return Boolean.parseBoolean(this.getProperty("zeppelin.R.knitr"));
        }
        catch (Exception e) {
            return false;
        }
    }
}

