/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.user;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.zeppelin.user.CredentialsInfoSaving;
import org.apache.zeppelin.user.UserCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Credentials {
    private static final Logger LOG = LoggerFactory.getLogger(Credentials.class);
    private Map<String, UserCredentials> credentialsMap;
    private Gson gson;
    private Boolean credentialsPersist = true;
    File credentialsFile;

    public Credentials(Boolean credentialsPersist, String credentialsPath) {
        this.credentialsPersist = credentialsPersist;
        if (credentialsPath != null) {
            this.credentialsFile = new File(credentialsPath);
        }
        this.credentialsMap = new HashMap<String, UserCredentials>();
        if (credentialsPersist.booleanValue()) {
            GsonBuilder builder = new GsonBuilder();
            builder.setPrettyPrinting();
            this.gson = builder.create();
            this.loadFromFile();
        }
    }

    public UserCredentials getUserCredentials(String username) {
        UserCredentials uc = this.credentialsMap.get(username);
        if (uc == null) {
            uc = new UserCredentials();
        }
        return uc;
    }

    public void putUserCredentials(String username, UserCredentials uc) throws IOException {
        this.credentialsMap.put(username, uc);
        this.saveCredentials();
    }

    public UserCredentials removeUserCredentials(String username) throws IOException {
        UserCredentials uc = this.credentialsMap.remove(username);
        this.saveCredentials();
        return uc;
    }

    public boolean removeCredentialEntity(String username, String entity) throws IOException {
        UserCredentials uc = this.credentialsMap.get(username);
        if (uc != null && !uc.existUsernamePassword(entity)) {
            return false;
        }
        uc.removeUsernamePassword(entity);
        this.saveCredentials();
        return true;
    }

    public void saveCredentials() throws IOException {
        if (this.credentialsPersist.booleanValue()) {
            this.saveToFile();
        }
    }

    private void loadFromFile() {
        LOG.info(this.credentialsFile.getAbsolutePath());
        if (!this.credentialsFile.exists()) {
            return;
        }
        try {
            String line;
            FileInputStream fis = new FileInputStream(this.credentialsFile);
            InputStreamReader isr = new InputStreamReader(fis);
            BufferedReader bufferedReader = new BufferedReader(isr);
            StringBuilder sb = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line);
            }
            isr.close();
            fis.close();
            String json = sb.toString();
            CredentialsInfoSaving info = this.gson.fromJson(json, CredentialsInfoSaving.class);
            this.credentialsMap = info.credentialsMap;
        }
        catch (IOException e) {
            LOG.error("Error loading credentials file", e);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile() throws IOException {
        String jsonString;
        Map<String, UserCredentials> map = this.credentialsMap;
        synchronized (map) {
            CredentialsInfoSaving info = new CredentialsInfoSaving();
            info.credentialsMap = this.credentialsMap;
            jsonString = this.gson.toJson(info);
        }
        try {
            if (!this.credentialsFile.exists()) {
                this.credentialsFile.createNewFile();
                EnumSet<PosixFilePermission> permissions = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE);
                Files.setPosixFilePermissions(this.credentialsFile.toPath(), permissions);
            }
            FileOutputStream fos = new FileOutputStream(this.credentialsFile, false);
            OutputStreamWriter out = new OutputStreamWriter(fos);
            out.append(jsonString);
            out.close();
            fos.close();
        }
        catch (IOException e) {
            LOG.error("Error saving credentials file", e);
        }
    }
}

