/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.model.support.captcha.GoogleRecaptchaProperties;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.http.HttpStatus;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ValidateCaptchaAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidateCaptchaAction.class);
    private static final ObjectReader READER = new ObjectMapper().findAndRegisterModules().reader();
    private static final String CODE = "captchaError";
    private final GoogleRecaptchaProperties recaptchaProperties;

    public ValidateCaptchaAction(GoogleRecaptchaProperties recaptchaProperties) {
        this.recaptchaProperties = recaptchaProperties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Event doExecute(RequestContext requestContext) throws Exception {
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)requestContext);
        String gRecaptchaResponse = request.getParameter("g-recaptcha-response");
        if (StringUtils.isBlank((CharSequence)gRecaptchaResponse)) {
            LOGGER.warn("Recaptcha response is missing from the request");
            return this.getError(requestContext);
        }
        try {
            URL obj = new URL(this.recaptchaProperties.getVerifyUrl());
            HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("User-Agent", WebUtils.getHttpServletRequestUserAgent());
            con.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
            String postParams = "secret=" + this.recaptchaProperties.getSecret() + "&response=" + gRecaptchaResponse;
            LOGGER.debug("Sending 'POST' request to URL: [{}]", (Object)obj);
            con.setDoOutput(true);
            try (DataOutputStream wr = new DataOutputStream(con.getOutputStream());){
                wr.writeBytes(postParams);
                wr.flush();
            }
            int responseCode = con.getResponseCode();
            LOGGER.debug("Response Code: [{}]", (Object)responseCode);
            if (responseCode != HttpStatus.OK.value()) return this.getError(requestContext);
            try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream(), StandardCharsets.UTF_8));){
                String response = in.lines().collect(Collectors.joining());
                LOGGER.debug("Google captcha response received: [{}]", (Object)response);
                JsonNode node = READER.readTree(response);
                if (!node.has("success")) return this.getError(requestContext);
                if (!node.get("success").booleanValue()) return this.getError(requestContext);
                Event event = null;
                return event;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return this.getError(requestContext);
    }

    private Event getError(RequestContext requestContext) {
        MessageContext messageContext = requestContext.getMessageContext();
        messageContext.addMessage(new MessageBuilder().error().code(CODE).build());
        return this.getEventFactorySupport().event((Object)this, CODE);
    }
}

