/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.config;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.CasCaptchaWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.ValidateCaptchaAction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@Configuration(value="casCaptchaConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasCaptchaConfiguration {
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private FlowDefinitionRegistry loginFlowDefinitionRegistry;
    @Autowired
    private FlowBuilderServices flowBuilderServices;
    @Autowired
    private CasConfigurationProperties casProperties;

    @ConditionalOnMissingBean(name={"captchaWebflowConfigurer"})
    @Bean
    public CasWebflowConfigurer captchaWebflowConfigurer() {
        return new CasCaptchaWebflowConfigurer(this.flowBuilderServices, this.loginFlowDefinitionRegistry);
    }

    @RefreshScope
    @Bean
    public Action validateCaptchaAction() {
        return new ValidateCaptchaAction(this.casProperties.getGoogleRecaptcha());
    }
}

