/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.google.common.collect.Multimap;
import java.time.Period;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationAccountStateHandler;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationPasswordPolicyHandlingStrategy;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.LdapAuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalNameTransformerUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.support.DefaultLdapAccountStateHandler;
import org.apereo.cas.authentication.support.OptionalWarningLdapAccountStateHandler;
import org.apereo.cas.authentication.support.RejectResultCodeLdapPasswordPolicyHandlingStrategy;
import org.apereo.cas.authentication.support.password.DefaultPasswordPolicyHandlingStrategy;
import org.apereo.cas.authentication.support.password.GroovyPasswordPolicyHandlingStrategy;
import org.apereo.cas.authentication.support.password.PasswordEncoderUtils;
import org.apereo.cas.authentication.support.password.PasswordPolicyConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.core.authentication.PasswordPolicyProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapAuthenticationProperties;
import org.apereo.cas.configuration.model.support.ldap.LdapAuthenticationProperties;
import org.apereo.cas.configuration.model.support.ldap.LdapPasswordPolicyProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LdapUtils;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.AuthenticationResponseHandler;
import org.ldaptive.auth.Authenticator;
import org.ldaptive.auth.ext.ActiveDirectoryAuthenticationResponseHandler;
import org.ldaptive.auth.ext.EDirectoryAuthenticationResponseHandler;
import org.ldaptive.auth.ext.FreeIPAAuthenticationResponseHandler;
import org.ldaptive.auth.ext.PasswordExpirationAuthenticationResponseHandler;
import org.ldaptive.auth.ext.PasswordPolicyAuthenticationResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;

@Configuration(value="ldapAuthenticationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class LdapAuthenticationConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapAuthenticationConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="personDirectoryPrincipalResolver")
    private PrincipalResolver personDirectoryPrincipalResolver;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;

    @ConditionalOnMissingBean(name={"ldapPrincipalFactory"})
    @Bean
    public PrincipalFactory ldapPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @Bean
    public Collection<AuthenticationHandler> ldapAuthenticationHandlers() {
        HashSet<AuthenticationHandler> handlers = new HashSet<AuthenticationHandler>();
        this.casProperties.getAuthn().getLdap().stream().filter(LdapAuthenticationConfiguration.ldapInstanceConfigurationPredicate()).forEach(l -> {
            Multimap multiMapAttributes = CoreAuthenticationUtils.transformPrincipalAttributesListIntoMultiMap((List)l.getPrincipalAttributeList());
            LOGGER.debug("Created and mapped principal attributes [{}] for [{}]...", (Object)multiMapAttributes, (Object)l.getLdapUrl());
            LOGGER.debug("Creating LDAP authenticator for [{}] and baseDn [{}]", (Object)l.getLdapUrl(), (Object)l.getBaseDn());
            Authenticator authenticator = LdapUtils.newLdaptiveAuthenticator((AbstractLdapAuthenticationProperties)l);
            LOGGER.debug("Ldap authenticator configured with return attributes [{}] for [{}] and baseDn [{}]", new Object[]{multiMapAttributes.keySet(), l.getLdapUrl(), l.getBaseDn()});
            LOGGER.debug("Creating LDAP password policy handling strategy for [{}]", (Object)l.getLdapUrl());
            AuthenticationPasswordPolicyHandlingStrategy<AuthenticationResponse, PasswordPolicyConfiguration> strategy = this.createLdapPasswordPolicyHandlingStrategy((LdapAuthenticationProperties)l);
            LOGGER.debug("Creating LDAP authentication handler for [{}]", (Object)l.getLdapUrl());
            LdapAuthenticationHandler handler = new LdapAuthenticationHandler(l.getName(), this.servicesManager, this.ldapPrincipalFactory(), l.getOrder(), authenticator, strategy);
            handler.setCollectDnAttribute(l.isCollectDnAttribute());
            List additionalAttributes = l.getAdditionalAttributes();
            if (StringUtils.isNotBlank((CharSequence)l.getPrincipalAttributeId())) {
                additionalAttributes.add(l.getPrincipalAttributeId());
            }
            if (StringUtils.isNotBlank((CharSequence)l.getPrincipalDnAttributeName())) {
                handler.setPrincipalDnAttributeName(l.getPrincipalDnAttributeName());
            }
            handler.setAllowMultiplePrincipalAttributeValues(l.isAllowMultiplePrincipalAttributeValues());
            handler.setAllowMissingPrincipalAttributeValue(l.isAllowMissingPrincipalAttributeValue());
            handler.setPasswordEncoder(PasswordEncoderUtils.newPasswordEncoder((PasswordEncoderProperties)l.getPasswordEncoder()));
            handler.setPrincipalNameTransformer(PrincipalNameTransformerUtils.newPrincipalNameTransformer((PrincipalTransformationProperties)l.getPrincipalTransformation()));
            if (StringUtils.isNotBlank((CharSequence)l.getCredentialCriteria())) {
                LOGGER.debug("Ldap authentication for [{}] is filtering credentials by [{}]", (Object)l.getLdapUrl(), (Object)l.getCredentialCriteria());
                handler.setCredentialSelectionPredicate(CoreAuthenticationUtils.newCredentialSelectionPredicate((String)l.getCredentialCriteria()));
            }
            if (StringUtils.isBlank((CharSequence)l.getPrincipalAttributeId())) {
                LOGGER.debug("No principal id attribute is found for LDAP authentication via [{}]", (Object)l.getLdapUrl());
            } else {
                handler.setPrincipalIdAttribute(l.getPrincipalAttributeId());
                LOGGER.debug("Using principal id attribute [{}] for LDAP authentication via [{}]", (Object)l.getPrincipalAttributeId(), (Object)l.getLdapUrl());
            }
            LdapPasswordPolicyProperties passwordPolicy = l.getPasswordPolicy();
            if (passwordPolicy.isEnabled()) {
                LOGGER.debug("Password policy is enabled for [{}]. Constructing password policy configuration", (Object)l.getLdapUrl());
                PasswordPolicyConfiguration cfg = this.createLdapPasswordPolicyConfiguration(passwordPolicy, authenticator, (Multimap<String, Object>)multiMapAttributes);
                handler.setPasswordPolicyConfiguration(cfg);
            }
            Map attributes = CollectionUtils.wrap((Multimap)multiMapAttributes);
            handler.setPrincipalAttributeMap(attributes);
            LOGGER.debug("Initializing LDAP authentication handler for [{}]", (Object)l.getLdapUrl());
            handler.initialize();
            handlers.add((AuthenticationHandler)handler);
        });
        return handlers;
    }

    private static Predicate<LdapAuthenticationProperties> ldapInstanceConfigurationPredicate() {
        return l -> {
            if (l.getType() == null) {
                LOGGER.warn("Skipping LDAP authentication entry since no type is defined");
                return false;
            }
            if (StringUtils.isBlank((CharSequence)l.getLdapUrl())) {
                LOGGER.warn("Skipping LDAP authentication entry since no LDAP url is defined");
                return false;
            }
            return true;
        };
    }

    private AuthenticationPasswordPolicyHandlingStrategy<AuthenticationResponse, PasswordPolicyConfiguration> createLdapPasswordPolicyHandlingStrategy(LdapAuthenticationProperties l) {
        if (l.getPasswordPolicy().getStrategy() == PasswordPolicyProperties.PasswordPolicyHandlingOptions.REJECT_RESULT_CODE) {
            LOGGER.debug("Created LDAP password policy handling strategy based on blacklisted authentication result codes");
            return new RejectResultCodeLdapPasswordPolicyHandlingStrategy();
        }
        Resource location = l.getPasswordPolicy().getGroovy().getLocation();
        if (l.getPasswordPolicy().getStrategy() == PasswordPolicyProperties.PasswordPolicyHandlingOptions.GROOVY && location != null) {
            LOGGER.debug("Created LDAP password policy handling strategy based on Groovy script [{}]", (Object)location);
            return new GroovyPasswordPolicyHandlingStrategy(location);
        }
        LOGGER.debug("Created default LDAP password policy handling strategy");
        return new DefaultPasswordPolicyHandlingStrategy();
    }

    private PasswordPolicyConfiguration createLdapPasswordPolicyConfiguration(LdapPasswordPolicyProperties passwordPolicy, Authenticator authenticator, Multimap<String, Object> attributes) {
        DefaultLdapAccountStateHandler accountHandler;
        PasswordPolicyConfiguration cfg = new PasswordPolicyConfiguration((PasswordPolicyProperties)passwordPolicy);
        HashSet<Object> handlers = new HashSet<Object>();
        String customPolicyClass = passwordPolicy.getCustomPolicyClass();
        if (StringUtils.isNotBlank((CharSequence)customPolicyClass)) {
            try {
                LOGGER.debug("Configuration indicates use of a custom password policy handler [{}]", (Object)customPolicyClass);
                Class<?> clazz = Class.forName(customPolicyClass);
                handlers.add((AuthenticationResponseHandler)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                LOGGER.warn("Unable to construct an instance of the password policy handler", (Throwable)e);
            }
        }
        LOGGER.debug("Password policy authentication response handler is set to accommodate directory type: [{}]", (Object)passwordPolicy.getType());
        switch (passwordPolicy.getType()) {
            case AD: {
                handlers.add(new ActiveDirectoryAuthenticationResponseHandler(Period.ofDays(cfg.getPasswordWarningNumberOfDays())));
                Arrays.stream(ActiveDirectoryAuthenticationResponseHandler.ATTRIBUTES).forEach(a -> {
                    LOGGER.debug("Configuring authentication to retrieve password policy attribute [{}]", a);
                    attributes.put(a, a);
                });
                break;
            }
            case FreeIPA: {
                Arrays.stream(FreeIPAAuthenticationResponseHandler.ATTRIBUTES).forEach(a -> {
                    LOGGER.debug("Configuring authentication to retrieve password policy attribute [{}]", a);
                    attributes.put(a, a);
                });
                handlers.add(new FreeIPAAuthenticationResponseHandler(Period.ofDays(cfg.getPasswordWarningNumberOfDays()), cfg.getLoginFailures()));
                break;
            }
            case EDirectory: {
                Arrays.stream(EDirectoryAuthenticationResponseHandler.ATTRIBUTES).forEach(a -> {
                    LOGGER.debug("Configuring authentication to retrieve password policy attribute [{}]", a);
                    attributes.put(a, a);
                });
                handlers.add(new EDirectoryAuthenticationResponseHandler(Period.ofDays(cfg.getPasswordWarningNumberOfDays())));
                break;
            }
            default: {
                handlers.add(new PasswordPolicyAuthenticationResponseHandler());
                handlers.add(new PasswordExpirationAuthenticationResponseHandler());
            }
        }
        authenticator.setAuthenticationResponseHandlers(handlers.toArray(new AuthenticationResponseHandler[0]));
        LOGGER.debug("LDAP authentication response handlers configured are: [{}]", handlers);
        if (!passwordPolicy.isAccountStateHandlingEnabled()) {
            cfg.setAccountStateHandler((response, configuration) -> new ArrayList(0));
            LOGGER.debug("Handling LDAP account states is disabled via CAS configuration");
        } else if (StringUtils.isNotBlank((CharSequence)passwordPolicy.getWarningAttributeName()) && StringUtils.isNotBlank((CharSequence)passwordPolicy.getWarningAttributeValue())) {
            accountHandler = new OptionalWarningLdapAccountStateHandler();
            accountHandler.setDisplayWarningOnMatch(passwordPolicy.isDisplayWarningOnMatch());
            accountHandler.setWarnAttributeName(passwordPolicy.getWarningAttributeName());
            accountHandler.setWarningAttributeValue(passwordPolicy.getWarningAttributeValue());
            accountHandler.setAttributesToErrorMap(passwordPolicy.getPolicyAttributes());
            cfg.setAccountStateHandler((AuthenticationAccountStateHandler)accountHandler);
            LOGGER.debug("Configuring an warning account state handler for LDAP authentication for warning attribute [{}] and value [{}]", (Object)passwordPolicy.getWarningAttributeName(), (Object)passwordPolicy.getWarningAttributeValue());
        } else {
            accountHandler = new DefaultLdapAccountStateHandler();
            accountHandler.setAttributesToErrorMap(passwordPolicy.getPolicyAttributes());
            cfg.setAccountStateHandler((AuthenticationAccountStateHandler)accountHandler);
            LOGGER.debug("Configuring the default account state handler for LDAP authentication");
        }
        return cfg;
    }

    @ConditionalOnMissingBean(name={"ldapAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    public AuthenticationEventExecutionPlanConfigurer ldapAuthenticationEventExecutionPlanConfigurer() {
        return plan -> this.ldapAuthenticationHandlers().forEach(handler -> {
            LOGGER.info("Registering LDAP authentication for [{}]", (Object)handler.getName());
            plan.registerAuthenticationHandlerWithPrincipalResolver(handler, this.personDirectoryPrincipalResolver);
        });
    }
}

