/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.controllers;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.web.BaseOAuthWrapperController;
import org.jooq.lambda.Unchecked;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class OidcJwksEndpointController
extends BaseOAuthWrapperController {
    @Autowired
    protected ResourceLoader resourceLoader;
    private Resource jwksFile;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;

    @RequestMapping(value={"/oidc/jwks"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<String> handleRequestInternal(HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
        Assert.notNull((Object)this.jwksFile, (String)"JWKS file cannot be undefined or null.");
        try {
            String jsonJwks = IOUtils.toString((InputStream)this.jwksFile.getInputStream(), (Charset)StandardCharsets.UTF_8);
            JsonWebKeySet jsonWebKeySet = new JsonWebKeySet(jsonJwks);
            this.servicesManager.getAllServices().stream().filter(s -> s instanceof OidcRegisteredService && StringUtils.isNotBlank((CharSequence)((OidcRegisteredService)s).getJwks())).forEach(Unchecked.consumer(s -> {
                OidcRegisteredService service = (OidcRegisteredService)s;
                Resource resource = this.resourceLoader.getResource(service.getJwks());
                JsonWebKeySet set = new JsonWebKeySet(IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8));
                set.getJsonWebKeys().forEach(arg_0 -> ((JsonWebKeySet)jsonWebKeySet).addJsonWebKey(arg_0));
            }));
            String body = jsonWebKeySet.toJson(JsonWebKey.OutputControlLevel.PUBLIC_ONLY);
            response.setContentType("application/json");
            return new ResponseEntity((Object)body, HttpStatus.OK);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.BAD_REQUEST);
        }
    }

    public void setJwksFile(Resource jwksFile) {
        this.jwksFile = jwksFile;
    }
}

