/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.profile;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.oidc.claims.BaseOidcScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcAddressScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcCustomScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcEmailScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcPhoneScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcProfileScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.mapping.OidcAttributeToScopeClaimMapper;
import org.apereo.cas.services.ChainingAttributeReleasePolicy;
import org.apereo.cas.services.DenyAllAttributeReleasePolicy;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.profile.DefaultOAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.jooq.lambda.Unchecked;
import org.pac4j.core.context.J2EContext;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcProfileScopeToAttributesFilter
extends DefaultOAuth20ProfileScopeToAttributesFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcProfileScopeToAttributesFilter.class);
    private Map<String, BaseOidcScopeAttributeReleasePolicy> filters;
    private Collection<BaseOidcScopeAttributeReleasePolicy> userScopes;
    private final OidcAttributeToScopeClaimMapper attributeToScopeClaimMapper;
    private final PrincipalFactory principalFactory;
    private final ServicesManager servicesManager;

    public OidcProfileScopeToAttributesFilter(PrincipalFactory principalFactory, ServicesManager servicesManager, Collection<BaseOidcScopeAttributeReleasePolicy> userScopes, OidcAttributeToScopeClaimMapper attributeToScopeClaimMapper) {
        this.attributeToScopeClaimMapper = attributeToScopeClaimMapper;
        this.filters = new HashMap<String, BaseOidcScopeAttributeReleasePolicy>();
        String packageName = BaseOidcScopeAttributeReleasePolicy.class.getPackage().getName();
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().filterInputsBy((Predicate)new FilterBuilder().includePackage(new String[]{packageName})).setUrls(ClasspathHelper.forPackage((String)packageName, (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new SubTypesScanner(true)}));
        Set subTypes = reflections.getSubTypesOf(BaseOidcScopeAttributeReleasePolicy.class);
        subTypes.forEach(Unchecked.consumer(t -> {
            BaseOidcScopeAttributeReleasePolicy ex = (BaseOidcScopeAttributeReleasePolicy)t.newInstance();
            this.filters.put(ex.getScopeName(), ex);
        }));
        userScopes.forEach(t -> this.filters.put(t.getScopeName(), (BaseOidcScopeAttributeReleasePolicy)t));
        this.principalFactory = principalFactory;
        this.servicesManager = servicesManager;
        this.userScopes = userScopes;
    }

    public Principal filter(Service service, Principal profile, RegisteredService registeredService, J2EContext context) {
        Principal principal = super.filter(service, profile, registeredService, context);
        if (registeredService instanceof OidcRegisteredService) {
            OidcRegisteredService oidcService = (OidcRegisteredService)registeredService;
            ArrayList<String> scopes = new ArrayList<String>(OAuth20Utils.getRequestedScopes((J2EContext)context));
            scopes.addAll(oidcService.getScopes());
            if (!scopes.contains("openid")) {
                LOGGER.debug("Request does not indicate a scope [{}] that can identify OpenID Connect", scopes);
                return principal;
            }
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            this.filterAttributesByScope(scopes, attributes, principal, service, (RegisteredService)oidcService);
            return this.principalFactory.createPrincipal(profile.getId(), attributes);
        }
        return principal;
    }

    private void filterAttributesByScope(Collection<String> stream, Map<String, Object> attributes, Principal principal, Service service, RegisteredService registeredService) {
        stream.stream().distinct().filter(s -> this.filters.containsKey(s)).forEach(s -> {
            BaseOidcScopeAttributeReleasePolicy policy = this.filters.get(s);
            attributes.putAll(policy.getAttributes(principal, service, registeredService));
        });
    }

    public void reconcile(RegisteredService service) {
        if (!(service instanceof OidcRegisteredService)) {
            super.reconcile(service);
            return;
        }
        LOGGER.debug("Reconciling scopes and claims for [{}]", (Object)service.getServiceId());
        ArrayList otherScopes = new ArrayList();
        ChainingAttributeReleasePolicy policy = new ChainingAttributeReleasePolicy();
        OidcRegisteredService oidc = (OidcRegisteredService)OidcRegisteredService.class.cast(service);
        oidc.getScopes().forEach(s -> {
            LOGGER.debug("Reviewing scope [{}] for [{}]", s, (Object)service.getServiceId());
            switch (s.trim().toLowerCase()) {
                case "email": {
                    LOGGER.debug("Mapped [{}] to attribute release policy [{}]", s, (Object)OidcEmailScopeAttributeReleasePolicy.class.getSimpleName());
                    policy.getPolicies().add(new OidcEmailScopeAttributeReleasePolicy());
                    break;
                }
                case "address": {
                    LOGGER.debug("Mapped [{}] to attribute release policy [{}]", s, (Object)OidcAddressScopeAttributeReleasePolicy.class.getSimpleName());
                    policy.getPolicies().add(new OidcAddressScopeAttributeReleasePolicy());
                    break;
                }
                case "profile": {
                    LOGGER.debug("Mapped [{}] to attribute release policy [{}]", s, (Object)OidcProfileScopeAttributeReleasePolicy.class.getSimpleName());
                    policy.getPolicies().add(new OidcProfileScopeAttributeReleasePolicy());
                    break;
                }
                case "phone": {
                    LOGGER.debug("Mapped [{}] to attribute release policy [{}]", s, (Object)OidcProfileScopeAttributeReleasePolicy.class.getSimpleName());
                    policy.getPolicies().add(new OidcPhoneScopeAttributeReleasePolicy());
                    break;
                }
                case "offline_access": {
                    LOGGER.debug("Given scope [{}], service [{}] is marked to generate refresh tokens", s, (Object)service.getId());
                    oidc.setGenerateRefreshToken(Boolean.valueOf(true));
                    break;
                }
                case "custom": {
                    LOGGER.debug("Found custom scope [{}] for service [{}]", s, (Object)service.getId());
                    otherScopes.add(s.trim());
                    break;
                }
                default: {
                    LOGGER.debug("[{}] appears to be a user-defined scope and does not match any of the predefined standard scopes. Checking [{}] against user-defined scopes provided as [{}]", new Object[]{s, s, this.userScopes});
                    BaseOidcScopeAttributeReleasePolicy userPolicy = this.userScopes.stream().filter(t -> t.getScopeName().equals(s.trim())).findFirst().orElse(null);
                    if (userPolicy == null) break;
                    LOGGER.debug("Mapped user-defined scope [{}] to attribute release policy [{}]", s, (Object)userPolicy);
                    policy.getPolicies().add(userPolicy);
                }
            }
        });
        otherScopes.remove("openid");
        if (!otherScopes.isEmpty()) {
            LOGGER.debug("Mapped scopes [{}] to attribute release policy [{}]", otherScopes, (Object)OidcCustomScopeAttributeReleasePolicy.class.getSimpleName());
            policy.getPolicies().add(new OidcCustomScopeAttributeReleasePolicy(otherScopes));
        }
        if (policy.getPolicies().isEmpty()) {
            LOGGER.warn("No attribute release policy could be determined based on given scopes. No claims/attributes will be released to [{}]", (Object)service.getId());
            oidc.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new DenyAllAttributeReleasePolicy());
        } else {
            oidc.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)policy);
        }
        LOGGER.debug("Scope/claim reconciliation for service [{}] resulted in the following attribute release policy [{}]", (Object)service.getServiceId(), (Object)oidc.getAttributeReleasePolicy());
        if (!oidc.equals((Object)service)) {
            LOGGER.debug("Saving scope/claim reconciliation results for service [{}] into registry", (Object)service.getServiceId());
            this.servicesManager.save((RegisteredService)oidc);
            LOGGER.debug("Saved service [{}] into registry", (Object)service.getServiceId());
        } else {
            LOGGER.debug("No changes detected in service [{}] after scope/claim reconciliation", (Object)service.getId());
        }
    }
}

