/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.token;

import com.google.common.base.Throwables;
import com.google.common.cache.LoadingCache;
import java.security.Key;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.services.OidcRegisteredService;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcIdTokenSigningAndEncryptionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcIdTokenSigningAndEncryptionService.class);
    private final LoadingCache<String, Optional<RsaJsonWebKey>> defaultJsonWebKeystoreCache;
    private final LoadingCache<OidcRegisteredService, Optional<RsaJsonWebKey>> serviceJsonWebKeystoreCache;
    private final String issuer;

    public OidcIdTokenSigningAndEncryptionService(LoadingCache<String, Optional<RsaJsonWebKey>> defaultJsonWebKeystoreCache, LoadingCache<OidcRegisteredService, Optional<RsaJsonWebKey>> serviceJsonWebKeystoreCache, String issuer) {
        this.defaultJsonWebKeystoreCache = defaultJsonWebKeystoreCache;
        this.serviceJsonWebKeystoreCache = serviceJsonWebKeystoreCache;
        this.issuer = issuer;
    }

    public String encode(OidcRegisteredService svc, JwtClaims claims) throws JoseException {
        try {
            String innerJwt;
            LOGGER.debug("Attempting to produce id token generated for service [{}]", (Object)svc);
            JsonWebSignature jws = new JsonWebSignature();
            String jsonClaims = claims.toJson();
            jws.setPayload(jsonClaims);
            LOGGER.debug("Generated claims to put into id token are [{}]", (Object)jsonClaims);
            jws.setAlgorithmHeaderValue("none");
            jws.setAlgorithmConstraints(AlgorithmConstraints.NO_CONSTRAINTS);
            String string = innerJwt = svc.isSignIdToken() ? this.signIdToken(svc, jws) : jws.getCompactSerialization();
            if (svc.isEncryptIdToken() && StringUtils.isNotBlank((CharSequence)svc.getIdTokenEncryptionAlg()) && StringUtils.isNotBlank((CharSequence)svc.getIdTokenEncryptionEncoding())) {
                innerJwt = this.encryptIdToken(svc, jws, innerJwt);
            }
            return innerJwt;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    private String encryptIdToken(OidcRegisteredService svc, JsonWebSignature jws, String innerJwt) throws Exception {
        LOGGER.debug("Service [{}] is set to encrypt id tokens", (Object)svc);
        JsonWebEncryption jwe = new JsonWebEncryption();
        jwe.setAlgorithmHeaderValue(svc.getIdTokenEncryptionAlg());
        jwe.setEncryptionMethodHeaderParameter(svc.getIdTokenEncryptionEncoding());
        Optional jwks = (Optional)this.serviceJsonWebKeystoreCache.get((Object)svc);
        if (!jwks.isPresent()) {
            throw new IllegalArgumentException("Service " + svc.getServiceId() + " with client id " + svc.getClientId() + " is configured to encrypt id tokens, yet no JSON web key is available");
        }
        RsaJsonWebKey jsonWebKey = (RsaJsonWebKey)jwks.get();
        LOGGER.debug("Found JSON web key to encrypt the id token: [{}]", (Object)jsonWebKey);
        if (jsonWebKey.getPublicKey() == null) {
            throw new IllegalArgumentException("JSON web key used to sign the id token has no associated public key");
        }
        jwe.setKey((Key)jsonWebKey.getPublicKey());
        jwe.setKeyIdHeaderValue(jws.getKeyIdHeaderValue());
        jwe.setContentTypeHeaderValue("JWT");
        jwe.setPayload(innerJwt);
        return jwe.getCompactSerialization();
    }

    private String signIdToken(OidcRegisteredService svc, JsonWebSignature jws) throws Exception {
        Optional jwks = (Optional)this.defaultJsonWebKeystoreCache.get((Object)this.issuer);
        if (!jwks.isPresent()) {
            throw new IllegalArgumentException("Service " + svc.getServiceId() + " with client id " + svc.getClientId() + " is configured to sign id tokens, yet no JSON web key is available");
        }
        RsaJsonWebKey jsonWebKey = (RsaJsonWebKey)jwks.get();
        LOGGER.debug("Found JSON web key to sign the id token: [{}]", (Object)jsonWebKey);
        if (jsonWebKey.getPrivateKey() == null) {
            throw new IllegalArgumentException("JSON web key used to sign the id token has no associated private key");
        }
        this.prepareJsonWebSignatureForIdTokenSigning(svc, jws, jsonWebKey);
        return jws.getCompactSerialization();
    }

    private void prepareJsonWebSignatureForIdTokenSigning(OidcRegisteredService svc, JsonWebSignature jws, RsaJsonWebKey jsonWebKey) {
        LOGGER.debug("Service [{}] is set to sign id tokens", (Object)svc);
        jws.setKey((Key)jsonWebKey.getPrivateKey());
        jws.setAlgorithmConstraints(AlgorithmConstraints.DISALLOW_NONE);
        if (StringUtils.isBlank((CharSequence)jsonWebKey.getKeyId())) {
            jws.setKeyIdHeaderValue(UUID.randomUUID().toString());
        } else {
            jws.setKeyIdHeaderValue(jsonWebKey.getKeyId());
        }
        LOGGER.debug("Signing id token with key id header value [{}]", (Object)jws.getKeyIdHeaderValue());
        jws.setAlgorithmHeaderValue(this.getJsonWebKeySigningAlgorithm());
        LOGGER.debug("Signing id token with algorithm [{}]", (Object)jws.getAlgorithmHeaderValue());
    }

    public String getJsonWebKeySigningAlgorithm() {
        return "RS256";
    }
}

