/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.support.oauth.web.OAuth20HandlerInterceptorAdapter;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class OidcHandlerInterceptorAdapter
extends OAuth20HandlerInterceptorAdapter {
    private final HandlerInterceptorAdapter requiresAuthenticationDynamicRegistrationInterceptor;
    private OidcConstants.DynamicClientRegistrationMode dynamicClientRegistrationMode;

    public OidcHandlerInterceptorAdapter(HandlerInterceptorAdapter requiresAuthenticationAccessTokenInterceptor, HandlerInterceptorAdapter requiresAuthenticationAuthorizeInterceptor, HandlerInterceptorAdapter requiresAuthenticationDynamicRegistrationInterceptor, OidcConstants.DynamicClientRegistrationMode dynamicClientRegistrationMode) {
        super(requiresAuthenticationAccessTokenInterceptor, requiresAuthenticationAuthorizeInterceptor);
        this.requiresAuthenticationDynamicRegistrationInterceptor = requiresAuthenticationDynamicRegistrationInterceptor;
        this.dynamicClientRegistrationMode = dynamicClientRegistrationMode;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!super.preHandle(request, response, handler)) {
            return false;
        }
        if (this.isDynamicClientRegistrationRequest(request.getRequestURI()) && this.isDynamicClientRegistrationRequestProtected()) {
            return this.requiresAuthenticationDynamicRegistrationInterceptor.preHandle(request, response, handler);
        }
        return true;
    }

    private boolean isDynamicClientRegistrationRequestProtected() {
        return this.dynamicClientRegistrationMode == OidcConstants.DynamicClientRegistrationMode.PROTECTED;
    }

    protected boolean isDynamicClientRegistrationRequest(String requestPath) {
        return this.doesUriMatchPattern(requestPath, "register");
    }
}

