/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.token;

import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.oidc.token.OidcIdTokenSigningAndEncryptionService;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.ticket.accesstoken.AccessToken;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.web.support.WebUtils;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class OidcIdTokenGeneratorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcIdTokenGeneratorService.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    private final String issuer;
    private final int skew;
    private final OidcIdTokenSigningAndEncryptionService signingService;

    public OidcIdTokenGeneratorService(String issuer, int skew, OidcIdTokenSigningAndEncryptionService signingService) {
        this.signingService = signingService;
        this.issuer = issuer;
        this.skew = skew;
    }

    public String generate(HttpServletRequest request, HttpServletResponse response, AccessToken accessTokenId, long timeout, OAuth20ResponseTypes responseType, OAuthRegisteredService registeredService) throws Exception {
        OidcRegisteredService oidcRegisteredService = (OidcRegisteredService)registeredService;
        J2EContext context = WebUtils.getPac4jJ2EContext((HttpServletRequest)request, (HttpServletResponse)response);
        ProfileManager manager = WebUtils.getPac4jProfileManager((HttpServletRequest)request, (HttpServletResponse)response);
        Optional profile = manager.get(true);
        LOGGER.debug("Attempting to produce claims for the id token [{}]", (Object)accessTokenId);
        JwtClaims claims = this.produceIdTokenClaims(request, accessTokenId, timeout, oidcRegisteredService, (UserProfile)profile.get(), context, responseType);
        LOGGER.debug("Produce claims for the id token [{}] as [{}]", (Object)accessTokenId, (Object)claims);
        return this.signingService.encode(oidcRegisteredService, claims);
    }

    protected JwtClaims produceIdTokenClaims(HttpServletRequest request, AccessToken accessTokenId, long timeout, OidcRegisteredService service, UserProfile profile, J2EContext context, OAuth20ResponseTypes responseType) {
        Set val;
        Authentication authentication = accessTokenId.getAuthentication();
        Principal principal = authentication.getPrincipal();
        JwtClaims claims = new JwtClaims();
        claims.setJwtId(UUID.randomUUID().toString());
        claims.setIssuer(this.issuer);
        claims.setAudience(service.getClientId());
        NumericDate expirationDate = NumericDate.now();
        expirationDate.addSeconds(timeout);
        claims.setExpirationTime(expirationDate);
        claims.setIssuedAtToNow();
        claims.setNotBeforeMinutesInThePast((float)this.skew);
        claims.setSubject(principal.getId());
        if (authentication.getAttributes().containsKey(this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute())) {
            val = CollectionUtils.toCollection(authentication.getAttributes().get(this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute()));
            claims.setStringClaim("acr", val.iterator().next().toString());
        }
        if (authentication.getAttributes().containsKey("successfulAuthenticationHandlers")) {
            val = CollectionUtils.toCollection(authentication.getAttributes().get("successfulAuthenticationHandlers"));
            claims.setStringListClaim("amr", val.toArray(new String[0]));
        }
        claims.setClaim("state", authentication.getAttributes().get("state"));
        claims.setClaim("nonce", authentication.getAttributes().get("nonce"));
        claims.setClaim("at_hash", (Object)this.generateAccessTokenHash(accessTokenId, service));
        principal.getAttributes().entrySet().stream().filter(entry -> this.casProperties.getAuthn().getOidc().getClaims().contains(entry.getKey())).forEach(entry -> claims.setClaim((String)entry.getKey(), entry.getValue()));
        if (!claims.hasClaim("preferred_username")) {
            claims.setClaim("preferred_username", (Object)profile.getId());
        }
        return claims;
    }

    private String generateAccessTokenHash(AccessToken accessTokenId, OidcRegisteredService service) {
        String hashAlg;
        byte[] tokenBytes = accessTokenId.getId().getBytes();
        switch (this.signingService.getJsonWebKeySigningAlgorithm()) {
            case "RS512": {
                hashAlg = "SHA-512";
                break;
            }
            default: {
                hashAlg = "SHA-256";
            }
        }
        LOGGER.debug("Digesting access token hash via algorithm [{}]", (Object)hashAlg);
        byte[] digested = DigestUtils.rawDigest((String)hashAlg, (byte[])tokenBytes);
        byte[] hashBytesLeftHalf = Arrays.copyOf(digested, digested.length / 2);
        return EncodingUtils.encodeBase64((byte[])hashBytesLeftHalf);
    }
}

