/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.util;

import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.apereo.cas.web.support.WebUtils;
import org.jasig.cas.client.util.URIBuilder;
import org.pac4j.cas.client.CasClient;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class OidcAuthorizationRequestSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcAuthorizationRequestSupport.class);
    private final CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator;
    private final TicketRegistrySupport ticketRegistrySupport;

    public OidcAuthorizationRequestSupport(CookieRetrievingCookieGenerator tgtCookieGenerator, TicketRegistrySupport ticketRegistrySupport) {
        this.ticketGrantingTicketCookieGenerator = tgtCookieGenerator;
        this.ticketRegistrySupport = ticketRegistrySupport;
    }

    public static Set<String> getOidcPromptFromAuthorizationRequest(String url) {
        Assert.notNull((Object)url, (String)"URL cannot be null");
        return new URIBuilder(url).getQueryParams().stream().filter(p -> "prompt".equals(p.getName())).map(param -> param.getValue().split(" ")).flatMap(Arrays::stream).collect(Collectors.toSet());
    }

    public static Set<String> getOidcPromptFromAuthorizationRequest(WebContext context) {
        return OidcAuthorizationRequestSupport.getOidcPromptFromAuthorizationRequest(context.getFullRequestURL());
    }

    public static Optional<Long> getOidcMaxAgeFromAuthorizationRequest(WebContext context) {
        URIBuilder builderContext = new URIBuilder(context.getFullRequestURL());
        Optional<URIBuilder.BasicNameValuePair> parameter = builderContext.getQueryParams().stream().filter(p -> "max_age".equals(p.getName())).findFirst();
        if (parameter.isPresent()) {
            long maxAge = NumberUtils.toLong((String)parameter.get().getValue(), (long)-1L);
            return Optional.of(maxAge);
        }
        return Optional.empty();
    }

    public static Optional<UserProfile> isAuthenticationProfileAvailable(WebContext context) {
        ProfileManager manager = WebUtils.getPac4jProfileManager((WebContext)context);
        return manager.get(true);
    }

    public Optional<Authentication> isCasAuthenticationAvailable(WebContext context) {
        Authentication authentication;
        String tgtId;
        J2EContext j2EContext = (J2EContext)context;
        if (j2EContext != null && StringUtils.isNotBlank((CharSequence)(tgtId = this.ticketGrantingTicketCookieGenerator.retrieveCookieValue(j2EContext.getRequest()))) && (authentication = this.ticketRegistrySupport.getAuthenticationFrom(tgtId)) != null) {
            return Optional.of(authentication);
        }
        return Optional.empty();
    }

    public boolean isCasAuthenticationOldForMaxAgeAuthorizationRequest(WebContext context, ZonedDateTime authenticationDate) {
        long authTime;
        long now;
        long diffInSeconds;
        Optional<Long> maxAge = OidcAuthorizationRequestSupport.getOidcMaxAgeFromAuthorizationRequest(context);
        if (maxAge.isPresent() && maxAge.get() > 0L && (diffInSeconds = (now = ZonedDateTime.now().toEpochSecond()) - (authTime = authenticationDate.toEpochSecond())) > maxAge.get()) {
            LOGGER.info("Authentication is too old: [{}] and was created [{}] seconds ago.", (Object)authTime, (Object)diffInSeconds);
            return true;
        }
        return false;
    }

    public boolean isCasAuthenticationOldForMaxAgeAuthorizationRequest(WebContext context, Authentication authentication) {
        return this.isCasAuthenticationOldForMaxAgeAuthorizationRequest(context, authentication.getAuthenticationDate());
    }

    public boolean isCasAuthenticationOldForMaxAgeAuthorizationRequest(WebContext context, UserProfile profile) {
        Object authTime = profile.getAttribute("authenticationDate");
        if (authTime == null) {
            return false;
        }
        ZonedDateTime dt = ZonedDateTime.parse(authTime.toString());
        return this.isCasAuthenticationOldForMaxAgeAuthorizationRequest(context, dt);
    }

    public void configureClientForMaxAgeAuthorizationRequest(CasClient casClient, WebContext context, Authentication authentication) {
        if (this.isCasAuthenticationOldForMaxAgeAuthorizationRequest(context, authentication)) {
            casClient.getConfiguration().setRenew(true);
        }
    }

    public static void configureClientForPromptLoginAuthorizationRequest(CasClient casClient, WebContext context) {
        Set<String> prompts = OidcAuthorizationRequestSupport.getOidcPromptFromAuthorizationRequest(context);
        if (prompts.contains("login")) {
            casClient.getConfiguration().setRenew(true);
        }
    }

    public static void configureClientForPromptNoneAuthorizationRequest(CasClient casClient, WebContext context) {
        Set<String> prompts = OidcAuthorizationRequestSupport.getOidcPromptFromAuthorizationRequest(context);
        if (prompts.contains("none")) {
            casClient.getConfiguration().setRenew(false);
            casClient.getConfiguration().setGateway(true);
        }
    }
}

