/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.flow;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.web.flow.authentication.BaseMultifactorAuthenticationProviderEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.jasig.cas.client.util.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class OidcAuthenticationContextWebflowEventEventResolver
extends BaseMultifactorAuthenticationProviderEventResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcAuthenticationContextWebflowEventEventResolver.class);

    public OidcAuthenticationContextWebflowEventEventResolver(AuthenticationSystemSupport authenticationSystemSupport, CentralAuthenticationService centralAuthenticationService, ServicesManager servicesManager, TicketRegistrySupport ticketRegistrySupport, CookieGenerator warnCookieGenerator, AuthenticationServiceSelectionPlan authenticationSelectionStrategies, MultifactorAuthenticationProviderSelector selector) {
        super(authenticationSystemSupport, centralAuthenticationService, servicesManager, ticketRegistrySupport, warnCookieGenerator, authenticationSelectionStrategies, selector);
    }

    public Set<Event> resolveInternal(RequestContext context) {
        URIBuilder builderContext;
        Optional<URIBuilder.BasicNameValuePair> parameter;
        RegisteredService service = this.resolveRegisteredServiceInRequestContext(context);
        Authentication authentication = WebUtils.getAuthentication((RequestContext)context);
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)context);
        if (service == null || authentication == null) {
            LOGGER.debug("No service or authentication is available to determine event for principal");
            return null;
        }
        String acr = request.getParameter("acr_values");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)acr) && (parameter = (builderContext = new URIBuilder(org.apache.commons.lang3.StringUtils.trimToEmpty((String)context.getFlowExecutionUrl()))).getQueryParams().stream().filter(p -> p.getName().equals("acr_values")).findFirst()).isPresent()) {
            acr = parameter.get().getValue();
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)acr)) {
            LOGGER.debug("No ACR provided in the authentication request");
            return null;
        }
        Set values = StringUtils.commaDelimitedListToSet((String)acr);
        if (values.isEmpty()) {
            LOGGER.debug("No ACR provided in the authentication request");
            return null;
        }
        Map providerMap = WebUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)this.applicationContext);
        if (providerMap == null || providerMap.isEmpty()) {
            LOGGER.error("No multifactor authentication providers are available in the application context to handle [{}]", (Object)values);
            throw new AuthenticationException();
        }
        Collection flattenedProviders = this.flattenProviders(providerMap.values());
        Optional<MultifactorAuthenticationProvider> provider = flattenedProviders.stream().filter(v -> values.contains(v.getId())).findAny();
        if (provider.isPresent()) {
            return Collections.singleton(new Event((Object)this, provider.get().getId()));
        }
        LOGGER.warn("The requested authentication class [{}] cannot be satisfied by any of the MFA providers available", (Object)values);
        throw new AuthenticationException();
    }
}

