/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.discovery;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.apereo.cas.configuration.CasConfigurationProperties;

public class OidcServerDiscoverySettings {
    @JsonProperty(value="scopes_supported")
    private List<String> scopesSupported;
    @JsonProperty(value="response_types_supported")
    private List<String> responseTypesSupported;
    @JsonProperty(value="subject_types_supported")
    private List<String> subjectTypesSupported;
    @JsonProperty(value="claim_types_supported")
    private List<String> claimTypesSupported;
    @JsonProperty(value="claims_supported")
    private List<String> claimsSupported;
    @JsonProperty(value="grant_types_supported")
    private List<String> grantTypesSupported;
    @JsonProperty(value="id_token_signing_alg_values_supported")
    private List<String> idTokenSigningAlgValuesSupported;
    private CasConfigurationProperties casProperties;
    private final String issuer;
    private final String serverPrefix;

    public OidcServerDiscoverySettings(CasConfigurationProperties casProperties, String issuer) {
        this.issuer = issuer;
        this.serverPrefix = casProperties.getServer().getPrefix();
        this.casProperties = casProperties;
    }

    public String getIssuer() {
        return this.issuer;
    }

    @JsonProperty(value="authorization_endpoint")
    public String getAuthorizationEndpoint() {
        return this.serverPrefix.concat("/oidc/authorize");
    }

    @JsonProperty(value="token_endpoint")
    public String getTokenEndpoint() {
        return this.serverPrefix.concat("/oidc/accessToken");
    }

    @JsonProperty(value="userinfo_endpoint")
    public String getUserinfoEndpoint() {
        return this.serverPrefix.concat("/oidc/profile");
    }

    @JsonProperty(value="jwks_uri")
    public String getJwksUri() {
        return this.serverPrefix.concat("/oidc/jwks");
    }

    @JsonProperty(value="registration_endpoint")
    public String getRegistrationEndpoint() {
        return this.serverPrefix.concat("/oidc/register");
    }

    @JsonProperty(value="end_session_endpoint")
    public String getEndSessionEndpoint() {
        return this.casProperties.getServer().getLogoutUrl();
    }

    public List<String> getScopesSupported() {
        return this.scopesSupported;
    }

    public List<String> getResponseTypesSupported() {
        return this.responseTypesSupported;
    }

    public List<String> getSubjectTypesSupported() {
        return this.subjectTypesSupported;
    }

    public List<String> getClaimTypesSupported() {
        return this.claimTypesSupported;
    }

    public List<String> getClaimsSupported() {
        return this.claimsSupported;
    }

    public void setScopesSupported(List<String> scopesSupported) {
        this.scopesSupported = scopesSupported;
    }

    public void setResponseTypesSupported(List<String> responseTypesSupported) {
        this.responseTypesSupported = responseTypesSupported;
    }

    public void setSubjectTypesSupported(List<String> supportedSubjectResponseTypes) {
        this.subjectTypesSupported = supportedSubjectResponseTypes;
    }

    public void setClaimTypesSupported(List<String> claimTypesSupported) {
        this.claimTypesSupported = claimTypesSupported;
    }

    public void setClaimsSupported(List<String> claimsSupported) {
        this.claimsSupported = claimsSupported;
    }

    public List<String> getGrantTypesSupported() {
        return this.grantTypesSupported;
    }

    public void setGrantTypesSupported(List<String> grantTypesSupported) {
        this.grantTypesSupported = grantTypesSupported;
    }

    public List<String> getIdTokenSigningAlgValuesSupported() {
        return this.idTokenSigningAlgValuesSupported;
    }

    public void setIdTokenSigningAlgValuesSupported(List<String> idTokenSigningAlgValuesSupported) {
        this.idTokenSigningAlgValuesSupported = idTokenSigningAlgValuesSupported;
    }
}

