/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.jwks;

import com.google.common.base.Throwables;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.PostConstruct;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.jwk.RsaJwkGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcJsonWebKeystoreGeneratorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcJsonWebKeystoreGeneratorService.class);
    private final OidcProperties oidcProperties;

    public OidcJsonWebKeystoreGeneratorService(OidcProperties oidcProperties) {
        this.oidcProperties = oidcProperties;
    }

    @PostConstruct
    public void generate() {
        try {
            File file = this.oidcProperties.getJwksFile().getFile();
            if (!file.exists()) {
                RsaJsonWebKey rsaJsonWebKey = RsaJwkGenerator.generateJwk((int)2048);
                JsonWebKeySet jsonWebKeySet = new JsonWebKeySet(new JsonWebKey[]{rsaJsonWebKey});
                String data = jsonWebKeySet.toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE);
                FileUtils.write((File)file, (CharSequence)data, (Charset)StandardCharsets.UTF_8);
                LOGGER.debug("Generated JSON web keystore at [{}]", (Object)file);
            } else {
                LOGGER.debug("Located JSON web keystore at [{}]", (Object)file);
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

