/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.profile;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.oidc.claims.BaseOidcScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcAddressScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcCustomScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcEmailScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcPhoneScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcProfileScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.mapping.OidcAttributeToScopeClaimMapper;
import org.apereo.cas.services.ChainingAttributeReleasePolicy;
import org.apereo.cas.services.DenyAllAttributeReleasePolicy;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.profile.DefaultOAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.jooq.lambda.Unchecked;
import org.pac4j.core.context.J2EContext;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcProfileScopeToAttributesFilter
extends DefaultOAuth20ProfileScopeToAttributesFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcProfileScopeToAttributesFilter.class);
    private final Map<String, BaseOidcScopeAttributeReleasePolicy> filters;
    private final Collection<BaseOidcScopeAttributeReleasePolicy> userScopes;
    private final OidcAttributeToScopeClaimMapper attributeToScopeClaimMapper;
    private final PrincipalFactory principalFactory;
    private final ServicesManager servicesManager;
    private final CasConfigurationProperties casProperties;

    public OidcProfileScopeToAttributesFilter(PrincipalFactory principalFactory, ServicesManager servicesManager, Collection<BaseOidcScopeAttributeReleasePolicy> userScopes, OidcAttributeToScopeClaimMapper attributeToScopeClaimMapper, CasConfigurationProperties casProperties) {
        this.attributeToScopeClaimMapper = attributeToScopeClaimMapper;
        this.casProperties = casProperties;
        this.filters = new HashMap<String, BaseOidcScopeAttributeReleasePolicy>();
        this.principalFactory = principalFactory;
        this.servicesManager = servicesManager;
        this.userScopes = userScopes;
        this.configureAttributeReleasePoliciesByScope();
    }

    private void configureAttributeReleasePoliciesByScope() {
        OidcProperties oidc = this.casProperties.getAuthn().getOidc();
        String packageName = BaseOidcScopeAttributeReleasePolicy.class.getPackage().getName();
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().filterInputsBy((Predicate)new FilterBuilder().includePackage(new String[]{packageName})).setUrls(ClasspathHelper.forPackage((String)packageName, (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new SubTypesScanner(true)}));
        Set subTypes = reflections.getSubTypesOf(BaseOidcScopeAttributeReleasePolicy.class);
        subTypes.forEach(Unchecked.consumer(t -> {
            BaseOidcScopeAttributeReleasePolicy ex = (BaseOidcScopeAttributeReleasePolicy)t.newInstance();
            if (oidc.getScopes().contains(ex.getScopeName())) {
                LOGGER.debug("Found OpenID Connect scope [{}] to filter attributes", (Object)ex.getScopeName());
                this.filters.put(ex.getScopeName(), ex);
            } else {
                LOGGER.debug("OpenID Connect scope [{}] is not configured for use and will be ignored", (Object)ex.getScopeName());
            }
        }));
        if (!this.userScopes.isEmpty()) {
            LOGGER.debug("Configuring attributes release policies for user-defined scopes [{}]", this.userScopes);
            this.userScopes.forEach(t -> this.filters.put(t.getScopeName(), (BaseOidcScopeAttributeReleasePolicy)t));
        }
    }

    public Principal filter(Service service, Principal profile, RegisteredService registeredService, J2EContext context) {
        Principal principal = super.filter(service, profile, registeredService, context);
        if (registeredService instanceof OidcRegisteredService) {
            OidcRegisteredService oidcService = (OidcRegisteredService)registeredService;
            ArrayList<String> scopes = new ArrayList<String>(OAuth20Utils.getRequestedScopes((J2EContext)context));
            scopes.addAll(oidcService.getScopes());
            if (!scopes.contains(OidcConstants.StandardScopes.OPENID.getScope())) {
                LOGGER.debug("Request does not indicate a scope [{}] that can identify an OpenID Connect request. This is a REQUIRED scope that MUST be present in the request. Given its absence, CAS will not process any attribute claims and will return the authenticated principal as is.", scopes);
                return principal;
            }
            Map<String, Object> attributes = this.filterAttributesByScope(scopes, principal, service, (RegisteredService)oidcService);
            return this.principalFactory.createPrincipal(profile.getId(), attributes);
        }
        return principal;
    }

    private Map<String, Object> filterAttributesByScope(Collection<String> stream, Principal principal, Service service, RegisteredService registeredService) {
        OidcProperties oidc = this.casProperties.getAuthn().getOidc();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        stream.stream().distinct().filter(this.filters::containsKey).forEach(s -> {
            BaseOidcScopeAttributeReleasePolicy policy = this.filters.get(s);
            policy.setSupportedClaims(oidc.getClaims());
            attributes.putAll(policy.getAttributes(principal, service, registeredService));
        });
        return attributes;
    }

    public void reconcile(RegisteredService service) {
        if (!(service instanceof OidcRegisteredService)) {
            super.reconcile(service);
            return;
        }
        LOGGER.debug("Reconciling OpenId Connect scopes and claims for [{}]", (Object)service.getServiceId());
        ArrayList otherScopes = new ArrayList();
        ChainingAttributeReleasePolicy policy = new ChainingAttributeReleasePolicy();
        OidcRegisteredService oidc = (OidcRegisteredService)OidcRegisteredService.class.cast(service);
        oidc.getScopes().forEach(s -> {
            block10: {
                LOGGER.debug("Reviewing scope [{}] for [{}]", s, (Object)service.getServiceId());
                try {
                    OidcConstants.StandardScopes scope = OidcConstants.StandardScopes.valueOf((String)s.trim().toLowerCase().toUpperCase());
                    switch (scope) {
                        case EMAIL: {
                            LOGGER.debug("Mapped [{}] to attribute release policy [{}]", s, (Object)OidcEmailScopeAttributeReleasePolicy.class.getSimpleName());
                            policy.getPolicies().add(new OidcEmailScopeAttributeReleasePolicy());
                            break;
                        }
                        case ADDRESS: {
                            LOGGER.debug("Mapped [{}] to attribute release policy [{}]", s, (Object)OidcAddressScopeAttributeReleasePolicy.class.getSimpleName());
                            policy.getPolicies().add(new OidcAddressScopeAttributeReleasePolicy());
                            break;
                        }
                        case PROFILE: {
                            LOGGER.debug("Mapped [{}] to attribute release policy [{}]", s, (Object)OidcProfileScopeAttributeReleasePolicy.class.getSimpleName());
                            policy.getPolicies().add(new OidcProfileScopeAttributeReleasePolicy());
                            break;
                        }
                        case PHONE: {
                            LOGGER.debug("Mapped [{}] to attribute release policy [{}]", s, (Object)OidcProfileScopeAttributeReleasePolicy.class.getSimpleName());
                            policy.getPolicies().add(new OidcPhoneScopeAttributeReleasePolicy());
                            break;
                        }
                        case OFFLINE_ACCESS: {
                            LOGGER.debug("Given scope [{}], service [{}] is marked to generate refresh tokens", s, (Object)service.getId());
                            oidc.setGenerateRefreshToken(Boolean.TRUE);
                            break;
                        }
                        case CUSTOM: {
                            LOGGER.debug("Found custom scope [{}] for service [{}]", s, (Object)service.getId());
                            otherScopes.add(s.trim());
                            break;
                        }
                        default: {
                            LOGGER.debug("Scope [{}] is unsupported for service [{}]", s, (Object)service.getId());
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("[{}] appears to be a user-defined scope and does not match any of the predefined standard scopes. Checking [{}] against user-defined scopes provided as [{}]", new Object[]{s, s, this.userScopes});
                    BaseOidcScopeAttributeReleasePolicy userPolicy = this.userScopes.stream().filter(t -> t.getScopeName().equals(s.trim())).findFirst().orElse(null);
                    if (userPolicy == null) break block10;
                    LOGGER.debug("Mapped user-defined scope [{}] to attribute release policy [{}]", s, (Object)userPolicy);
                    policy.getPolicies().add(userPolicy);
                }
            }
        });
        otherScopes.remove(OidcConstants.StandardScopes.OPENID.getScope());
        if (!otherScopes.isEmpty()) {
            LOGGER.debug("Mapped scopes [{}] to attribute release policy [{}]", otherScopes, (Object)OidcCustomScopeAttributeReleasePolicy.class.getSimpleName());
            policy.getPolicies().add(new OidcCustomScopeAttributeReleasePolicy(otherScopes));
        }
        if (policy.getPolicies().isEmpty()) {
            LOGGER.warn("No attribute release policy could be determined based on given scopes. No claims/attributes will be released to [{}]", (Object)service.getId());
            oidc.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new DenyAllAttributeReleasePolicy());
        } else {
            oidc.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)policy);
        }
        LOGGER.debug("Scope/claim reconciliation for service [{}] resulted in the following attribute release policy [{}]", (Object)service.getServiceId(), (Object)oidc.getAttributeReleasePolicy());
        if (!oidc.equals((Object)service)) {
            LOGGER.debug("Saving scope/claim reconciliation results for service [{}] into registry", (Object)service.getServiceId());
            this.servicesManager.save((RegisteredService)oidc);
            LOGGER.debug("Saved service [{}] into registry", (Object)service.getServiceId());
        } else {
            LOGGER.debug("No changes detected in service [{}] after scope/claim reconciliation", (Object)service.getId());
        }
    }
}

