/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.profile;

import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.support.events.service.CasRegisteredServicesLoadedEvent;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;

public class OidcRegisteredServicePreProcessorEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcRegisteredServicePreProcessorEventListener.class);
    private final OAuth20ProfileScopeToAttributesFilter scopeToAttributesFilter;

    public OidcRegisteredServicePreProcessorEventListener(OAuth20ProfileScopeToAttributesFilter scopeToAttributesFilter) {
        this.scopeToAttributesFilter = scopeToAttributesFilter;
    }

    @EventListener
    public void handleRegisteredServicesLoadedEvent(CasRegisteredServicesLoadedEvent event) {
        event.getServices().stream().filter(OidcRegisteredService.class::isInstance).forEach(s -> {
            LOGGER.debug("Attempting to reconcile scopes and attributes for service [{}] of type [{}]", (Object)s.getServiceId(), (Object)s.getClass().getSimpleName());
            this.scopeToAttributesFilter.reconcile(s);
        });
    }
}

