/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.apereo.cas.oidc.token.OidcIdTokenGeneratorService;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestDataHolder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20TokenAuthorizationResponseBuilder;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.accesstoken.AccessToken;
import org.apereo.cas.ticket.refreshtoken.RefreshToken;
import org.pac4j.core.context.J2EContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.View;

public class OidcImplicitIdTokenAuthorizationResponseBuilder
extends OAuth20TokenAuthorizationResponseBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcImplicitIdTokenAuthorizationResponseBuilder.class);
    private final OidcIdTokenGeneratorService idTokenGenerator;
    private final ExpirationPolicy idTokenExpirationPolicy;

    public OidcImplicitIdTokenAuthorizationResponseBuilder(OidcIdTokenGeneratorService idTokenGenerator, OAuth20TokenGenerator accessTokenGenerator, ExpirationPolicy accessTokenExpirationPolicy, ExpirationPolicy idTokenExpirationPolicy) {
        super(accessTokenGenerator, accessTokenExpirationPolicy);
        this.idTokenGenerator = idTokenGenerator;
        this.idTokenExpirationPolicy = idTokenExpirationPolicy;
    }

    protected View buildCallbackUrlResponseType(AccessTokenRequestDataHolder holder, String redirectUri, AccessToken accessToken, List<NameValuePair> params, RefreshToken refreshToken, J2EContext context) throws Exception {
        String idToken = this.idTokenGenerator.generate(context.getRequest(), context.getResponse(), accessToken, this.idTokenExpirationPolicy.getTimeToLive(), OAuth20ResponseTypes.IDTOKEN_TOKEN, holder.getRegisteredService());
        LOGGER.debug("Generated id token [{}]", (Object)idToken);
        params.add((NameValuePair)new BasicNameValuePair("id_token", idToken));
        return super.buildCallbackUrlResponseType(holder, redirectUri, accessToken, params, refreshToken, context);
    }

    public boolean supports(J2EContext context) {
        String responseType = context.getRequestParameter("response_type");
        return OAuth20Utils.isResponseType((String)responseType, (OAuth20ResponseTypes)OAuth20ResponseTypes.IDTOKEN_TOKEN);
    }
}

