/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.token;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.oidc.token.OidcIdTokenSigningAndEncryptionService;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.accesstoken.AccessToken;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.Pac4jUtils;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcIdTokenGeneratorService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcIdTokenGeneratorService.class);
    private final CasConfigurationProperties casProperties;
    private final OidcIdTokenSigningAndEncryptionService signingService;
    private final ServicesManager servicesManager;
    private final String oAuthCallbackUrl;

    public OidcIdTokenGeneratorService(CasConfigurationProperties casProperties, OidcIdTokenSigningAndEncryptionService signingService, ServicesManager servicesManager) {
        this.casProperties = casProperties;
        this.signingService = signingService;
        this.servicesManager = servicesManager;
        this.oAuthCallbackUrl = casProperties.getServer().getPrefix() + "/oauth2.0" + '/' + "callbackAuthorize.*";
    }

    public String generate(HttpServletRequest request, HttpServletResponse response, AccessToken accessTokenId, long timeoutInSeconds, OAuth20ResponseTypes responseType, OAuthRegisteredService registeredService) {
        if (!(registeredService instanceof OidcRegisteredService)) {
            throw new IllegalArgumentException("Registered service instance is not an OIDC service");
        }
        OidcRegisteredService oidcRegisteredService = (OidcRegisteredService)registeredService;
        J2EContext context = Pac4jUtils.getPac4jJ2EContext((HttpServletRequest)request, (HttpServletResponse)response);
        ProfileManager manager = Pac4jUtils.getPac4jProfileManager((HttpServletRequest)request, (HttpServletResponse)response);
        Optional profile = manager.get(true);
        if (!profile.isPresent()) {
            throw new IllegalArgumentException("Unable to determine the user profile from the context");
        }
        LOGGER.debug("Attempting to produce claims for the id token [{}]", (Object)accessTokenId);
        JwtClaims claims = this.produceIdTokenClaims(request, accessTokenId, timeoutInSeconds, oidcRegisteredService, (UserProfile)profile.get(), context, responseType);
        LOGGER.debug("Produce claims for the id token [{}] as [{}]", (Object)accessTokenId, (Object)claims);
        return this.signingService.encode(oidcRegisteredService, claims);
    }

    protected JwtClaims produceIdTokenClaims(HttpServletRequest request, AccessToken accessTokenId, long timeoutInSeconds, OidcRegisteredService service, UserProfile profile, J2EContext context, OAuth20ResponseTypes responseType) {
        Set val;
        Authentication authentication = accessTokenId.getAuthentication();
        Principal principal = authentication.getPrincipal();
        OidcProperties oidc = this.casProperties.getAuthn().getOidc();
        JwtClaims claims = new JwtClaims();
        claims.setJwtId(this.getJwtId(accessTokenId.getTicketGrantingTicket()));
        claims.setIssuer(oidc.getIssuer());
        claims.setAudience(service.getClientId());
        NumericDate expirationDate = NumericDate.now();
        expirationDate.addSeconds(timeoutInSeconds);
        claims.setExpirationTime(expirationDate);
        claims.setIssuedAtToNow();
        claims.setNotBeforeMinutesInThePast((float)oidc.getSkew());
        claims.setSubject(principal.getId());
        MultifactorAuthenticationProperties mfa = this.casProperties.getAuthn().getMfa();
        Map attributes = authentication.getAttributes();
        if (attributes.containsKey(mfa.getAuthenticationContextAttribute())) {
            val = CollectionUtils.toCollection(attributes.get(mfa.getAuthenticationContextAttribute()));
            claims.setStringClaim("acr", val.iterator().next().toString());
        }
        if (attributes.containsKey("successfulAuthenticationHandlers")) {
            val = CollectionUtils.toCollection(attributes.get("successfulAuthenticationHandlers"));
            claims.setStringListClaim("amr", val.toArray(new String[0]));
        }
        claims.setClaim("state", attributes.get("state"));
        claims.setClaim("nonce", attributes.get("nonce"));
        claims.setClaim("at_hash", (Object)this.generateAccessTokenHash(accessTokenId, service));
        principal.getAttributes().entrySet().stream().filter(entry -> oidc.getClaims().contains(entry.getKey())).forEach(entry -> claims.setClaim((String)entry.getKey(), entry.getValue()));
        if (!claims.hasClaim("preferred_username")) {
            claims.setClaim("preferred_username", (Object)profile.getId());
        }
        return claims;
    }

    private String getJwtId(TicketGrantingTicket tgt) {
        Optional<Map.Entry> oAuthServiceTicket = Stream.concat(tgt.getServices().entrySet().stream(), tgt.getProxyGrantingTickets().entrySet().stream()).filter(e -> this.servicesManager.findServiceBy((Service)e.getValue()).getServiceId().equals(this.oAuthCallbackUrl)).findFirst();
        if (oAuthServiceTicket.isPresent()) {
            return (String)oAuthServiceTicket.get().getKey();
        }
        return tgt.getId();
    }

    private String generateAccessTokenHash(AccessToken accessTokenId, OidcRegisteredService service) {
        String hashAlg;
        byte[] tokenBytes = accessTokenId.getId().getBytes(StandardCharsets.UTF_8);
        switch (this.signingService.getJsonWebKeySigningAlgorithm()) {
            case "RS512": {
                hashAlg = "SHA-512";
                break;
            }
            default: {
                hashAlg = "SHA-256";
            }
        }
        LOGGER.debug("Digesting access token hash via algorithm [{}]", (Object)hashAlg);
        byte[] digested = DigestUtils.rawDigest((String)hashAlg, (byte[])tokenBytes);
        byte[] hashBytesLeftHalf = Arrays.copyOf(digested, digested.length / 2);
        return EncodingUtils.encodeUrlSafeBase64((byte[])hashBytesLeftHalf);
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }

    @Generated
    public OidcIdTokenSigningAndEncryptionService getSigningService() {
        return this.signingService;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public String getOAuthCallbackUrl() {
        return this.oAuthCallbackUrl;
    }
}

