/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.oidc.introspection.OidcIntrospectionAccessTokenResponse;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.BaseOAuth20Controller;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.accesstoken.AccessToken;
import org.apereo.cas.ticket.accesstoken.AccessTokenFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.HttpRequestUtils;
import org.apereo.cas.util.Pac4jUtils;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.extractor.BasicAuthExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

public class OidcIntrospectionEndpointController
extends BaseOAuth20Controller {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcIntrospectionEndpointController.class);
    private final CentralAuthenticationService centralAuthenticationService;
    private final AuditableExecution registeredServiceAccessStrategyEnforcer;

    public OidcIntrospectionEndpointController(ServicesManager servicesManager, TicketRegistry ticketRegistry, AccessTokenFactory accessTokenFactory, PrincipalFactory principalFactory, ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory, OAuth20ProfileScopeToAttributesFilter scopeToAttributesFilter, CasConfigurationProperties casProperties, CookieRetrievingCookieGenerator cookieGenerator, CentralAuthenticationService centralAuthenticationService, AuditableExecution registeredServiceAccessStrategyEnforcer) {
        super(servicesManager, ticketRegistry, accessTokenFactory, principalFactory, webApplicationServiceServiceFactory, scopeToAttributesFilter, casProperties, cookieGenerator);
        this.centralAuthenticationService = centralAuthenticationService;
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
    }

    @GetMapping(consumes={"application/x-www-form-urlencoded"}, produces={"application/json"}, value={"/oidc/introspect"})
    public ResponseEntity<OidcIntrospectionAccessTokenResponse> handleRequest(HttpServletRequest request, HttpServletResponse response) {
        return this.handlePostRequest(request, response);
    }

    @PostMapping(consumes={"application/x-www-form-urlencoded"}, produces={"application/json"}, value={"/oidc/introspect"})
    public ResponseEntity<OidcIntrospectionAccessTokenResponse> handlePostRequest(HttpServletRequest request, HttpServletResponse response) {
        try {
            ResponseEntity<OidcIntrospectionAccessTokenResponse> result;
            BasicAuthExtractor authExtractor = new BasicAuthExtractor();
            UsernamePasswordCredentials credentials = (UsernamePasswordCredentials)authExtractor.extract((WebContext)Pac4jUtils.getPac4jJ2EContext((HttpServletRequest)request, (HttpServletResponse)response));
            if (credentials == null) {
                result = OidcIntrospectionEndpointController.buildUnauthorizedResponseEntity("invalid_client", true);
            } else {
                OAuthRegisteredService service = OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)this.servicesManager, (String)credentials.getUsername());
                Optional<ResponseEntity<OidcIntrospectionAccessTokenResponse>> validationError = this.validateIntrospectionRequest(service, credentials, request);
                if (validationError.isPresent()) {
                    result = validationError.get();
                } else {
                    String accessToken = (String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("token"), (CharSequence)request.getParameter("access_token"));
                    LOGGER.debug("Located access token [{}] in the request", (Object)accessToken);
                    AccessToken ticket = null;
                    try {
                        ticket = (AccessToken)this.centralAuthenticationService.getTicket(accessToken, AccessToken.class);
                    }
                    catch (InvalidTicketException ite) {
                        LOGGER.info("No ticket for supplied access token");
                    }
                    result = this.createIntrospectionResponse(service, ticket);
                }
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private Optional<ResponseEntity<OidcIntrospectionAccessTokenResponse>> validateIntrospectionRequest(OAuthRegisteredService registeredService, UsernamePasswordCredentials credentials, HttpServletRequest request) {
        boolean tokenExists;
        boolean bl = tokenExists = HttpRequestUtils.doesParameterExist((HttpServletRequest)request, (String)"token") || HttpRequestUtils.doesParameterExist((HttpServletRequest)request, (String)"access_token");
        if (!tokenExists) {
            return Optional.of(OidcIntrospectionEndpointController.buildBadRequestResponseEntity("missing_accessToken"));
        }
        if (OAuth20Utils.checkClientSecret((OAuthRegisteredService)registeredService, (String)credentials.getPassword())) {
            WebApplicationService service = (WebApplicationService)this.webApplicationServiceServiceFactory.createService(registeredService.getServiceId());
            AuditableContext audit = AuditableContext.builder().service((Service)service).registeredService((RegisteredService)registeredService).build();
            AuditableExecutionResult accessResult = this.registeredServiceAccessStrategyEnforcer.execute(audit);
            return accessResult.isExecutionFailure() ? Optional.of(OidcIntrospectionEndpointController.buildUnauthorizedResponseEntity("unauthorized_client", false)) : Optional.empty();
        }
        return Optional.of(OidcIntrospectionEndpointController.buildUnauthorizedResponseEntity("invalid_client", true));
    }

    private ResponseEntity<OidcIntrospectionAccessTokenResponse> createIntrospectionResponse(OAuthRegisteredService service, AccessToken ticket) {
        OidcIntrospectionAccessTokenResponse introspect = new OidcIntrospectionAccessTokenResponse();
        if (ticket != null) {
            introspect.setActive(true);
            introspect.setClientId(service.getClientId());
            Authentication authentication = ticket.getAuthentication();
            String subject = authentication.getPrincipal().getId();
            introspect.setSub(subject);
            introspect.setUniqueSecurityName(subject);
            introspect.setExp(ticket.getExpirationPolicy().getTimeToLive());
            introspect.setIat(ticket.getCreationTime().toInstant().getEpochSecond());
            Object methods = authentication.getAttributes().get("authenticationMethod");
            String realmNames = CollectionUtils.toCollection(methods).stream().map(Object::toString).collect(Collectors.joining(","));
            introspect.setRealmName(realmNames);
            introspect.setTokenType("bearer");
            String grant = authentication.getAttributes().getOrDefault("grant_type", "").toString().toLowerCase();
            introspect.setGrantType(grant);
            introspect.setScope(OidcConstants.StandardScopes.OPENID.getScope());
            introspect.setAud(service.getServiceId());
            introspect.setIss(this.casProperties.getAuthn().getOidc().getIssuer());
        } else {
            introspect.setActive(false);
        }
        return new ResponseEntity((Object)introspect, HttpStatus.OK);
    }

    private static ResponseEntity<OidcIntrospectionAccessTokenResponse> buildUnauthorizedResponseEntity(String code, boolean isAuthenticationFailure) {
        LinkedMultiValueMap map = new LinkedMultiValueMap(1);
        map.add((Object)"error", (Object)code);
        String value = OAuth20Utils.jsonify((Map)map);
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        if (isAuthenticationFailure) {
            headers.add((Object)"WWW-Authenticate", (Object)"Basic");
        }
        ResponseEntity result = new ResponseEntity((Object)value, (MultiValueMap)headers, HttpStatus.UNAUTHORIZED);
        return result;
    }

    private static ResponseEntity<OidcIntrospectionAccessTokenResponse> buildBadRequestResponseEntity(String code) {
        LinkedMultiValueMap map = new LinkedMultiValueMap(1);
        map.add((Object)"error", (Object)code);
        String value = OAuth20Utils.jsonify((Map)map);
        ResponseEntity result = new ResponseEntity((Object)value, HttpStatus.BAD_REQUEST);
        return result;
    }
}

