/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.jwks;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.jwk.RsaJwkGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcJsonWebKeystoreGeneratorService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcJsonWebKeystoreGeneratorService.class);
    private static final int DEFAULT_KEYSTORE_BITS = 2048;
    private final OidcProperties oidcProperties;

    public void generate() {
        File file = this.oidcProperties.getJwksFile().getFile();
        this.generate(file, 2048);
    }

    public void generate(File file) {
        this.generate(file, 2048);
    }

    protected void generate(File file, int bits) {
        if (!file.exists()) {
            RsaJsonWebKey rsaJsonWebKey = RsaJwkGenerator.generateJwk((int)bits);
            JsonWebKeySet jsonWebKeySet = new JsonWebKeySet(new JsonWebKey[]{rsaJsonWebKey});
            String data = jsonWebKeySet.toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE);
            FileUtils.write((File)file, (CharSequence)data, (Charset)StandardCharsets.UTF_8);
            LOGGER.debug("Generated JSON web keystore at [{}]", (Object)file);
        } else {
            LOGGER.debug("Located JSON web keystore at [{}]", (Object)file);
        }
    }

    @Generated
    public OidcJsonWebKeystoreGeneratorService(OidcProperties oidcProperties) {
        this.oidcProperties = oidcProperties;
    }
}

