/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.discovery;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcServerDiscoverySettings {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcServerDiscoverySettings.class);
    @JsonProperty(value="scopes_supported")
    private List<String> scopesSupported;
    @JsonProperty(value="response_types_supported")
    private List<String> responseTypesSupported;
    @JsonProperty(value="subject_types_supported")
    private List<String> subjectTypesSupported;
    @JsonProperty(value="claim_types_supported")
    private List<String> claimTypesSupported;
    @JsonProperty(value="claims_supported")
    private List<String> claimsSupported;
    @JsonProperty(value="grant_types_supported")
    private List<String> grantTypesSupported;
    @JsonProperty(value="id_token_signing_alg_values_supported")
    private List<String> idTokenSigningAlgValuesSupported;
    @JsonProperty(value="introspection_endpoint_auth_methods_supported")
    private List<String> introspectionSupportedAuthenticationMethods;
    @JsonIgnore
    private final CasConfigurationProperties casProperties;
    @JsonProperty
    private final String issuer;
    @JsonIgnore
    private final String serverPrefix;

    public OidcServerDiscoverySettings(CasConfigurationProperties casProperties, String issuer) {
        this.issuer = issuer;
        this.serverPrefix = casProperties.getServer().getPrefix();
        this.casProperties = casProperties;
    }

    @JsonProperty(value="authorization_endpoint")
    public String getAuthorizationEndpoint() {
        return this.serverPrefix.concat("/oidc/authorize");
    }

    @JsonProperty(value="token_endpoint")
    public String getTokenEndpoint() {
        return this.serverPrefix.concat("/oidc/accessToken");
    }

    @JsonProperty(value="userinfo_endpoint")
    public String getUserinfoEndpoint() {
        return this.serverPrefix.concat("/oidc/profile");
    }

    @JsonProperty(value="jwks_uri")
    public String getJwksUri() {
        return this.serverPrefix.concat("/oidc/jwks");
    }

    @JsonProperty(value="registration_endpoint")
    public String getRegistrationEndpoint() {
        return this.serverPrefix.concat("/oidc/register");
    }

    @JsonProperty(value="end_session_endpoint")
    public String getEndSessionEndpoint() {
        return this.casProperties.getServer().getLogoutUrl();
    }

    @JsonProperty(value="introspection_endpoint")
    public String getIntrospectionEndpoint() {
        return this.serverPrefix.concat("/oidc/introspect");
    }

    @JsonProperty(value="revocation_endpoint")
    public String getRevocationEndpoint() {
        return this.serverPrefix.concat("/oidc/revoke");
    }

    @Generated
    public List<String> getScopesSupported() {
        return this.scopesSupported;
    }

    @Generated
    public List<String> getResponseTypesSupported() {
        return this.responseTypesSupported;
    }

    @Generated
    public List<String> getSubjectTypesSupported() {
        return this.subjectTypesSupported;
    }

    @Generated
    public List<String> getClaimTypesSupported() {
        return this.claimTypesSupported;
    }

    @Generated
    public List<String> getClaimsSupported() {
        return this.claimsSupported;
    }

    @Generated
    public List<String> getGrantTypesSupported() {
        return this.grantTypesSupported;
    }

    @Generated
    public List<String> getIdTokenSigningAlgValuesSupported() {
        return this.idTokenSigningAlgValuesSupported;
    }

    @Generated
    public List<String> getIntrospectionSupportedAuthenticationMethods() {
        return this.introspectionSupportedAuthenticationMethods;
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }

    @Generated
    public String getIssuer() {
        return this.issuer;
    }

    @Generated
    public String getServerPrefix() {
        return this.serverPrefix;
    }

    @Generated
    public void setScopesSupported(List<String> scopesSupported) {
        this.scopesSupported = scopesSupported;
    }

    @Generated
    public void setResponseTypesSupported(List<String> responseTypesSupported) {
        this.responseTypesSupported = responseTypesSupported;
    }

    @Generated
    public void setSubjectTypesSupported(List<String> subjectTypesSupported) {
        this.subjectTypesSupported = subjectTypesSupported;
    }

    @Generated
    public void setClaimTypesSupported(List<String> claimTypesSupported) {
        this.claimTypesSupported = claimTypesSupported;
    }

    @Generated
    public void setClaimsSupported(List<String> claimsSupported) {
        this.claimsSupported = claimsSupported;
    }

    @Generated
    public void setGrantTypesSupported(List<String> grantTypesSupported) {
        this.grantTypesSupported = grantTypesSupported;
    }

    @Generated
    public void setIdTokenSigningAlgValuesSupported(List<String> idTokenSigningAlgValuesSupported) {
        this.idTokenSigningAlgValuesSupported = idTokenSigningAlgValuesSupported;
    }

    @Generated
    public void setIntrospectionSupportedAuthenticationMethods(List<String> introspectionSupportedAuthenticationMethods) {
        this.introspectionSupportedAuthenticationMethods = introspectionSupportedAuthenticationMethods;
    }
}

