/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.discovery;

import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettings;
import org.springframework.beans.factory.FactoryBean;

public class OidcServerDiscoverySettingsFactory
implements FactoryBean<OidcServerDiscoverySettings> {
    private final CasConfigurationProperties casProperties;

    public OidcServerDiscoverySettings getObject() {
        OidcProperties oidc = this.casProperties.getAuthn().getOidc();
        OidcServerDiscoverySettings discoveryProperties = new OidcServerDiscoverySettings(this.casProperties, oidc.getIssuer());
        discoveryProperties.setClaimsSupported(oidc.getClaims());
        discoveryProperties.setScopesSupported(oidc.getScopes());
        discoveryProperties.setResponseTypesSupported(oidc.getResponseTypesSupported());
        discoveryProperties.setSubjectTypesSupported(oidc.getSubjectTypes());
        discoveryProperties.setClaimTypesSupported(oidc.getClaimTypesSupported());
        discoveryProperties.setIntrospectionSupportedAuthenticationMethods(oidc.getIntrospectionSupportedAuthenticationMethods());
        discoveryProperties.setGrantTypesSupported(oidc.getGrantTypesSupported());
        discoveryProperties.setIdTokenSigningAlgValuesSupported(oidc.getIdTokenSigningAlgValuesSupported());
        discoveryProperties.setTokenEndpointAuthMethodsSupported(oidc.getTokenEndpointAuthMethodsSupported());
        return discoveryProperties;
    }

    public Class<?> getObjectType() {
        return OidcServerDiscoverySettings.class;
    }

    public boolean isSingleton() {
        return true;
    }

    @Generated
    public OidcServerDiscoverySettingsFactory(CasConfigurationProperties casProperties) {
        this.casProperties = casProperties;
    }
}

