/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.token;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.ticket.BaseIdTokenSigningAndEncryptionService;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcIdTokenSigningAndEncryptionService
extends BaseIdTokenSigningAndEncryptionService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcIdTokenSigningAndEncryptionService.class);
    private final LoadingCache<String, Optional<RsaJsonWebKey>> defaultJsonWebKeystoreCache;
    private final LoadingCache<OidcRegisteredService, Optional<RsaJsonWebKey>> serviceJsonWebKeystoreCache;

    public OidcIdTokenSigningAndEncryptionService(LoadingCache<String, Optional<RsaJsonWebKey>> defaultJsonWebKeystoreCache, LoadingCache<OidcRegisteredService, Optional<RsaJsonWebKey>> serviceJsonWebKeystoreCache, String issuer) {
        super(issuer);
        this.defaultJsonWebKeystoreCache = defaultJsonWebKeystoreCache;
        this.serviceJsonWebKeystoreCache = serviceJsonWebKeystoreCache;
    }

    public String encode(OAuthRegisteredService service, JwtClaims claims) {
        String innerJwt;
        OidcRegisteredService svc = (OidcRegisteredService)OidcRegisteredService.class.cast(service);
        LOGGER.debug("Attempting to produce id token generated for service [{}]", (Object)svc);
        JsonWebSignature jws = this.createJsonWebSignature(claims);
        LOGGER.debug("Generated claims to put into id token are [{}]", (Object)claims.toJson());
        String string = innerJwt = svc.isSignIdToken() ? this.signIdToken(svc, jws) : jws.getCompactSerialization();
        if (svc.isEncryptIdToken() && StringUtils.isNotBlank((CharSequence)svc.getIdTokenEncryptionAlg()) && StringUtils.isNotBlank((CharSequence)svc.getIdTokenEncryptionEncoding())) {
            innerJwt = this.encryptIdToken(svc, jws, innerJwt);
        }
        return innerJwt;
    }

    private String encryptIdToken(OidcRegisteredService svc, JsonWebSignature jws, String innerJwt) {
        LOGGER.debug("Service [{}] is set to encrypt id tokens", (Object)svc);
        Optional jwks = (Optional)this.serviceJsonWebKeystoreCache.get((Object)svc);
        if (jwks.isEmpty()) {
            throw new IllegalArgumentException("Service " + svc.getServiceId() + " with client id " + svc.getClientId() + " is configured to encrypt id tokens, yet no JSON web key is available");
        }
        RsaJsonWebKey jsonWebKey = (RsaJsonWebKey)jwks.get();
        LOGGER.debug("Found JSON web key to encrypt the id token: [{}]", (Object)jsonWebKey);
        if (jsonWebKey.getPublicKey() == null) {
            throw new IllegalArgumentException("JSON web key used to sign the id token has no associated public key");
        }
        return this.encryptIdToken(svc.getIdTokenEncryptionAlg(), svc.getIdTokenEncryptionEncoding(), jws.getKeyIdHeaderValue(), jsonWebKey.getPublicKey(), innerJwt);
    }

    private String signIdToken(OidcRegisteredService svc, JsonWebSignature jws) throws Exception {
        LOGGER.debug("Fetching JSON web key to sign the id token for : [{}]", (Object)svc.getClientId());
        PublicJsonWebKey jsonWebKey = this.getSigningKey();
        LOGGER.debug("Found JSON web key to sign the id token: [{}]", (Object)jsonWebKey);
        if (jsonWebKey.getPrivateKey() == null) {
            throw new IllegalArgumentException("JSON web key used to sign the id token has no associated private key");
        }
        this.configureJsonWebSignatureForIdTokenSigning((OAuthRegisteredService)svc, jws, jsonWebKey);
        return jws.getCompactSerialization();
    }

    protected PublicJsonWebKey getSigningKey() {
        Optional jwks = (Optional)this.defaultJsonWebKeystoreCache.get((Object)this.getIssuer());
        if (jwks.isEmpty()) {
            throw new IllegalArgumentException("No signing key could be found for issuer " + this.getIssuer());
        }
        return (PublicJsonWebKey)jwks.get();
    }

    public String getJsonWebKeySigningAlgorithm(OAuthRegisteredService service) {
        OidcRegisteredService svc = (OidcRegisteredService)OidcRegisteredService.class.cast(service);
        if (StringUtils.isBlank((CharSequence)svc.getIdTokenSigningAlg())) {
            return super.getJsonWebKeySigningAlgorithm(service);
        }
        return svc.getIdTokenSigningAlg();
    }
}

