/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseResult;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20DefaultAccessTokenResponseGenerator;
import org.apereo.cas.ticket.IdTokenGeneratorService;
import org.apereo.cas.ticket.accesstoken.AccessToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcAccessTokenResponseGenerator
extends OAuth20DefaultAccessTokenResponseGenerator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcAccessTokenResponseGenerator.class);
    private final IdTokenGeneratorService idTokenGenerator;

    protected Map getAccessTokenResponseModel(HttpServletRequest request, HttpServletResponse response, OAuth20AccessTokenResponseResult result) {
        Map model = super.getAccessTokenResponseModel(request, response, result);
        Optional accessToken = result.getGeneratedToken().getAccessToken();
        accessToken.ifPresent(token -> {
            OidcRegisteredService oidcRegisteredService = (OidcRegisteredService)result.getRegisteredService();
            String idToken = this.idTokenGenerator.generate(request, response, (AccessToken)accessToken.get(), result.getAccessTokenTimeout(), result.getResponseType(), (OAuthRegisteredService)oidcRegisteredService);
            LOGGER.debug("Generated ID token [{}]", (Object)idToken);
            model.put("id_token", idToken);
        });
        return model;
    }

    @Generated
    public OidcAccessTokenResponseGenerator(IdTokenGeneratorService idTokenGenerator) {
        this.idTokenGenerator = idTokenGenerator;
    }
}

