/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.flow;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderResolver;
import org.apereo.cas.authentication.MultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

public class OidcMultifactorAuthenticationTrigger
implements MultifactorAuthenticationTrigger {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcMultifactorAuthenticationTrigger.class);
    private final CasConfigurationProperties casProperties;
    private final MultifactorAuthenticationProviderResolver multifactorAuthenticationProviderResolver;
    private int order = Integer.MAX_VALUE;

    public Optional<MultifactorAuthenticationProvider> isActivated(Authentication authentication, RegisteredService registeredService, HttpServletRequest request, Service service) {
        if (registeredService == null || authentication == null) {
            LOGGER.debug("No service or authentication is available to determine event for principal");
            return Optional.empty();
        }
        String acr = request.getParameter("acr_values");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)acr)) {
            Optional<NameValuePair> parameter;
            String url = request.getRequestURL() + "?" + request.getQueryString();
            URIBuilder builderContext = new URIBuilder(url);
            Optional<NameValuePair> idx = builderContext.getQueryParams().stream().filter(p -> p.getName().equals("service")).findFirst();
            if (idx.isPresent()) {
                builderContext = new URIBuilder(idx.get().getValue());
            }
            if ((parameter = builderContext.getQueryParams().stream().filter(p -> p.getName().equals("acr_values")).findFirst()).isPresent()) {
                acr = parameter.get().getValue();
            }
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)acr)) {
            LOGGER.debug("No ACR provided in the authentication request");
            return Optional.empty();
        }
        Set values = StringUtils.commaDelimitedListToSet((String)acr);
        if (values.isEmpty()) {
            LOGGER.trace("No ACR values are provided in the authentication request");
            return Optional.empty();
        }
        Map providerMap = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)ApplicationContextProvider.getApplicationContext());
        if (providerMap.isEmpty()) {
            LOGGER.error("No multifactor authentication providers are available in the application context to handle [{}]", (Object)values);
            throw new AuthenticationException();
        }
        return providerMap.values().stream().filter(v -> values.contains(v.getId())).findAny();
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }

    @Generated
    public MultifactorAuthenticationProviderResolver getMultifactorAuthenticationProviderResolver() {
        return this.multifactorAuthenticationProviderResolver;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public OidcMultifactorAuthenticationTrigger(CasConfigurationProperties casProperties, MultifactorAuthenticationProviderResolver multifactorAuthenticationProviderResolver) {
        this.casProperties = casProperties;
        this.multifactorAuthenticationProviderResolver = multifactorAuthenticationProviderResolver;
    }
}

