/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.config;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderResolver;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.authentication.MultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.logout.slo.SingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.oidc.claims.BaseOidcScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcCustomScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.mapping.DefaultOidcAttributeToScopeClaimMapper;
import org.apereo.cas.oidc.claims.mapping.OidcAttributeToScopeClaimMapper;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettings;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettingsFactory;
import org.apereo.cas.oidc.dynareg.OidcClientRegistrationRequest;
import org.apereo.cas.oidc.dynareg.OidcClientRegistrationRequestSerializer;
import org.apereo.cas.oidc.jwks.OidcDefaultJsonWebKeystoreCacheLoader;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeystoreGeneratorService;
import org.apereo.cas.oidc.jwks.OidcServiceJsonWebKeystoreCacheLoader;
import org.apereo.cas.oidc.profile.OidcProfileScopeToAttributesFilter;
import org.apereo.cas.oidc.profile.OidcRegisteredServicePreProcessorEventListener;
import org.apereo.cas.oidc.profile.OidcUserProfileDataCreator;
import org.apereo.cas.oidc.token.OidcIdTokenGeneratorService;
import org.apereo.cas.oidc.token.OidcIdTokenSigningAndEncryptionService;
import org.apereo.cas.oidc.util.OidcAuthorizationRequestSupport;
import org.apereo.cas.oidc.web.OidcAccessTokenResponseGenerator;
import org.apereo.cas.oidc.web.OidcCallbackAuthorizeViewResolver;
import org.apereo.cas.oidc.web.OidcCasClientRedirectActionBuilder;
import org.apereo.cas.oidc.web.OidcConsentApprovalViewResolver;
import org.apereo.cas.oidc.web.OidcHandlerInterceptorAdapter;
import org.apereo.cas.oidc.web.OidcImplicitIdTokenAuthorizationResponseBuilder;
import org.apereo.cas.oidc.web.OidcSecurityInterceptor;
import org.apereo.cas.oidc.web.controllers.authorize.OidcAuthorizeEndpointController;
import org.apereo.cas.oidc.web.controllers.discovery.OidcWellKnownEndpointController;
import org.apereo.cas.oidc.web.controllers.dynareg.OidcDynamicClientRegistrationEndpointController;
import org.apereo.cas.oidc.web.controllers.introspection.OidcIntrospectionEndpointController;
import org.apereo.cas.oidc.web.controllers.jwks.OidcJwksEndpointController;
import org.apereo.cas.oidc.web.controllers.logout.OidcLogoutEndpointController;
import org.apereo.cas.oidc.web.controllers.profile.OidcUserProfileEndpointController;
import org.apereo.cas.oidc.web.controllers.token.OidcAccessTokenEndpointController;
import org.apereo.cas.oidc.web.controllers.token.OidcRevocationEndpointController;
import org.apereo.cas.oidc.web.flow.OidcMultifactorAuthenticationTrigger;
import org.apereo.cas.oidc.web.flow.OidcRegisteredServiceUIAction;
import org.apereo.cas.oidc.web.flow.OidcWebflowConfigurer;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.authenticator.OAuth20CasAuthenticationBuilder;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.profile.OAuth20UserProfileDataCreator;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20AuthorizationRequestValidator;
import org.apereo.cas.support.oauth.validator.token.OAuth20TokenRequestValidator;
import org.apereo.cas.support.oauth.web.response.OAuth20CasClientRedirectActionBuilder;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenGrantRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.views.ConsentApprovalViewResolver;
import org.apereo.cas.support.oauth.web.views.OAuth20CallbackAuthorizeViewResolver;
import org.apereo.cas.support.oauth.web.views.OAuth20UserProfileViewRenderer;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.IdTokenGeneratorService;
import org.apereo.cas.ticket.IdTokenSigningAndEncryptionService;
import org.apereo.cas.ticket.accesstoken.AccessTokenFactory;
import org.apereo.cas.ticket.code.OAuthCodeFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.gen.DefaultRandomStringGenerator;
import org.apereo.cas.util.gen.RandomStringGenerator;
import org.apereo.cas.util.serialization.StringSerializer;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlan;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.mfa.DefaultMultifactorAuthenticationProviderEventResolver;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.jose4j.jwk.RsaJsonWebKey;
import org.pac4j.cas.client.CasClient;
import org.pac4j.core.config.Config;
import org.pac4j.springframework.web.SecurityInterceptor;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@Configuration(value="oidcConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class OidcConfiguration
implements WebMvcConfigurer,
CasWebflowExecutionPlanConfigurer {
    @Autowired
    @Qualifier(value="accessTokenGrantAuditableRequestExtractor")
    private ObjectProvider<AuditableExecution> accessTokenGrantAuditableRequestExtractor;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private ObjectProvider<AuthenticationSystemSupport> authenticationSystemSupport;
    @Autowired
    @Qualifier(value="registeredServiceAccessStrategyEnforcer")
    private ObjectProvider<AuditableExecution> registeredServiceAccessStrategyEnforcer;
    @Autowired
    @Qualifier(value="oauthAuthorizationRequestValidators")
    private ObjectProvider<Set<OAuth20AuthorizationRequestValidator>> oauthRequestValidators;
    @Autowired
    @Qualifier(value="grantingTicketExpirationPolicy")
    private ObjectProvider<ExpirationPolicy> grantingTicketExpirationPolicy;
    @Autowired
    @Qualifier(value="oauthTokenGenerator")
    private ObjectProvider<OAuth20TokenGenerator> oauthTokenGenerator;
    @Autowired
    @Qualifier(value="oauthAuthorizationResponseBuilders")
    private ObjectProvider<Set<OAuth20AuthorizationResponseBuilder>> oauthAuthorizationResponseBuilders;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ObjectProvider<ServiceFactory<WebApplicationService>> webApplicationServiceFactory;
    @Autowired
    @Qualifier(value="accessTokenExpirationPolicy")
    private ObjectProvider<ExpirationPolicy> accessTokenExpirationPolicy;
    @Autowired
    @Qualifier(value="deviceTokenExpirationPolicy")
    private ObjectProvider<ExpirationPolicy> deviceTokenExpirationPolicy;
    @Autowired
    @Qualifier(value="requiresAuthenticationAccessTokenInterceptor")
    private ObjectProvider<SecurityInterceptor> requiresAuthenticationAccessTokenInterceptor;
    @Autowired
    @Qualifier(value="multifactorAuthenticationProviderSelector")
    private ObjectProvider<MultifactorAuthenticationProviderSelector> multifactorAuthenticationProviderSelector;
    @Autowired
    @Qualifier(value="oauthCasAuthenticationBuilder")
    private ObjectProvider<OAuth20CasAuthenticationBuilder> authenticationBuilder;
    @Autowired
    @Qualifier(value="warnCookieGenerator")
    private ObjectProvider<CookieGenerator> warnCookieGenerator;
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private ObjectProvider<FlowDefinitionRegistry> loginFlowDefinitionRegistry;
    @Autowired
    @Qualifier(value="logoutFlowRegistry")
    private ObjectProvider<FlowDefinitionRegistry> logoutFlowDefinitionRegistry;
    @Autowired
    private ObjectProvider<FlowBuilderServices> flowBuilderServices;
    @Autowired
    @Qualifier(value="initialAuthenticationAttemptWebflowEventResolver")
    private ObjectProvider<CasDelegatingWebflowEventResolver> initialAuthenticationAttemptWebflowEventResolver;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private ObjectProvider<CentralAuthenticationService> centralAuthenticationService;
    @Autowired
    @Qualifier(value="oauth20AuthenticationRequestServiceSelectionStrategy")
    private ObjectProvider<AuthenticationServiceSelectionStrategy> oauth20AuthenticationServiceSelectionStrategy;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ResourceLoader resourceLoader;
    @Autowired
    @Qualifier(value="singleLogoutServiceLogoutUrlBuilder")
    private ObjectProvider<SingleLogoutServiceLogoutUrlBuilder> singleLogoutServiceLogoutUrlBuilder;
    @Autowired
    @Qualifier(value="oauthSecConfig")
    private ObjectProvider<Config> oauthSecConfig;
    @Autowired
    @Qualifier(value="ticketGrantingTicketCookieGenerator")
    private ObjectProvider<CookieRetrievingCookieGenerator> ticketGrantingTicketCookieGenerator;
    @Autowired
    @Qualifier(value="defaultTicketRegistrySupport")
    private ObjectProvider<TicketRegistrySupport> ticketRegistrySupport;
    @Autowired
    @Qualifier(value="defaultAccessTokenFactory")
    private ObjectProvider<AccessTokenFactory> defaultAccessTokenFactory;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="ticketRegistry")
    private ObjectProvider<TicketRegistry> ticketRegistry;
    @Autowired
    @Qualifier(value="defaultOAuthCodeFactory")
    private ObjectProvider<OAuthCodeFactory> defaultOAuthCodeFactory;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    @Autowired
    @Qualifier(value="authenticationServiceSelectionPlan")
    private ObjectProvider<AuthenticationServiceSelectionPlan> authenticationRequestServiceSelectionStrategies;
    @Autowired
    @Qualifier(value="oauthUserProfileViewRenderer")
    private ObjectProvider<OAuth20UserProfileViewRenderer> oauthUserProfileViewRenderer;
    @Autowired
    @Qualifier(value="accessTokenGrantRequestExtractors")
    private ObjectProvider<Collection<AccessTokenGrantRequestExtractor>> accessTokenGrantRequestExtractors;
    @Autowired
    @Qualifier(value="oauthTokenRequestValidators")
    private ObjectProvider<Collection<OAuth20TokenRequestValidator>> oauthTokenRequestValidators;
    @Autowired
    @Qualifier(value="multifactorAuthenticationProviderResolver")
    private ObjectProvider<MultifactorAuthenticationProviderResolver> multifactorAuthenticationProviderResolver;

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.oauthInterceptor()).addPathPatterns(new String[]{"/" + "oidc".concat("/").concat("*")});
    }

    @Bean
    public ConsentApprovalViewResolver consentApprovalViewResolver() {
        return new OidcConsentApprovalViewResolver(this.casProperties);
    }

    @Bean
    public OAuth20CallbackAuthorizeViewResolver callbackAuthorizeViewResolver() {
        return new OidcCallbackAuthorizeViewResolver();
    }

    @Bean
    public OAuth20CasClientRedirectActionBuilder oauthCasClientRedirectActionBuilder() {
        return new OidcCasClientRedirectActionBuilder(this.oidcAuthorizationRequestSupport());
    }

    @Bean
    public HandlerInterceptorAdapter requiresAuthenticationDynamicRegistrationInterceptor() {
        String clients = String.join((CharSequence)",", "clientBasicAuth", "clientForm", "userForm");
        return new SecurityInterceptor((Config)this.oauthSecConfig.getIfAvailable(), clients);
    }

    @Bean
    public HandlerInterceptorAdapter requiresAuthenticationAuthorizeInterceptor() {
        String name = ((CasClient)((Config)this.oauthSecConfig.getIfAvailable()).getClients().findClient(CasClient.class)).getName();
        return new OidcSecurityInterceptor((Config)this.oauthSecConfig.getIfAvailable(), name, this.oidcAuthorizationRequestSupport());
    }

    @Bean
    public OAuth20CasClientRedirectActionBuilder oidcCasClientRedirectActionBuilder() {
        return new OidcCasClientRedirectActionBuilder(this.oidcAuthorizationRequestSupport());
    }

    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcIdTokenGenerator"})
    @Bean
    public IdTokenGeneratorService oidcIdTokenGenerator() {
        return new OidcIdTokenGeneratorService(this.casProperties, this.oidcTokenSigningAndEncryptionService(), (ServicesManager)this.servicesManager.getIfAvailable(), (TicketRegistry)this.ticketRegistry.getIfAvailable());
    }

    @ConditionalOnMissingBean(name={"oidcAccessTokenResponseGenerator"})
    @Bean
    @RefreshScope
    public OAuth20AccessTokenResponseGenerator oidcAccessTokenResponseGenerator() {
        return new OidcAccessTokenResponseGenerator(this.oidcIdTokenGenerator());
    }

    @Bean
    public OidcAuthorizationRequestSupport oidcAuthorizationRequestSupport() {
        return new OidcAuthorizationRequestSupport((CookieRetrievingCookieGenerator)this.ticketGrantingTicketCookieGenerator.getIfAvailable(), (TicketRegistrySupport)this.ticketRegistrySupport.getIfAvailable());
    }

    @ConditionalOnMissingBean(name={"oidcPrincipalFactory"})
    @Bean
    public PrincipalFactory oidcPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @Bean
    public OidcAttributeToScopeClaimMapper oidcAttributeToScopeClaimMapper() {
        Map mappings = this.casProperties.getAuthn().getOidc().getClaimsMap();
        return new DefaultOidcAttributeToScopeClaimMapper(mappings);
    }

    @Bean
    public OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter() {
        return new OidcProfileScopeToAttributesFilter(this.oidcPrincipalFactory(), (ServicesManager)this.servicesManager.getIfAvailable(), this.userDefinedScopeBasedAttributeReleasePolicies(), this.casProperties);
    }

    @RefreshScope
    @Bean
    public OidcIntrospectionEndpointController oidcIntrospectionEndpointController() {
        return new OidcIntrospectionEndpointController((ServicesManager)this.servicesManager.getIfAvailable(), (TicketRegistry)this.ticketRegistry.getIfAvailable(), (AccessTokenFactory)this.defaultAccessTokenFactory.getIfAvailable(), this.oidcPrincipalFactory(), (ServiceFactory<WebApplicationService>)((ServiceFactory)this.webApplicationServiceFactory.getIfAvailable()), this.profileScopeToAttributesFilter(), this.casProperties, (CookieRetrievingCookieGenerator)this.ticketGrantingTicketCookieGenerator.getIfAvailable(), (CentralAuthenticationService)this.centralAuthenticationService.getIfAvailable(), (AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getIfAvailable());
    }

    @RefreshScope
    @Bean
    public OidcLogoutEndpointController oidcLogoutEndpointController() {
        return new OidcLogoutEndpointController((ServicesManager)this.servicesManager.getIfAvailable(), (TicketRegistry)this.ticketRegistry.getIfAvailable(), (AccessTokenFactory)this.defaultAccessTokenFactory.getIfAvailable(), this.oidcPrincipalFactory(), (ServiceFactory<WebApplicationService>)((ServiceFactory)this.webApplicationServiceFactory.getIfAvailable()), this.profileScopeToAttributesFilter(), this.casProperties, (CookieRetrievingCookieGenerator)this.ticketGrantingTicketCookieGenerator.getIfAvailable(), (AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getIfAvailable(), this.oidcTokenSigningAndEncryptionService(), (SingleLogoutServiceLogoutUrlBuilder)this.singleLogoutServiceLogoutUrlBuilder.getIfAvailable());
    }

    @RefreshScope
    @Bean
    public OidcRevocationEndpointController oidcRevocationEndpointController() {
        return new OidcRevocationEndpointController((ServicesManager)this.servicesManager.getIfAvailable(), (TicketRegistry)this.ticketRegistry.getIfAvailable(), (AccessTokenFactory)this.defaultAccessTokenFactory.getIfAvailable(), this.oidcPrincipalFactory(), (ServiceFactory<WebApplicationService>)((ServiceFactory)this.webApplicationServiceFactory.getIfAvailable()), this.profileScopeToAttributesFilter(), this.casProperties, (CookieRetrievingCookieGenerator)this.ticketGrantingTicketCookieGenerator.getIfAvailable(), (AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getIfAvailable());
    }

    @RefreshScope
    @Bean
    public OidcAccessTokenEndpointController oidcAccessTokenController() {
        return new OidcAccessTokenEndpointController((ServicesManager)this.servicesManager.getIfAvailable(), (TicketRegistry)this.ticketRegistry.getIfAvailable(), (AccessTokenFactory)this.defaultAccessTokenFactory.getIfAvailable(), this.oidcPrincipalFactory(), (ServiceFactory<WebApplicationService>)((ServiceFactory)this.webApplicationServiceFactory.getIfAvailable()), (OAuth20TokenGenerator)this.oauthTokenGenerator.getIfAvailable(), this.oidcAccessTokenResponseGenerator(), this.profileScopeToAttributesFilter(), this.casProperties, (CookieRetrievingCookieGenerator)this.ticketGrantingTicketCookieGenerator.getIfAvailable(), (ExpirationPolicy)this.accessTokenExpirationPolicy.getIfAvailable(), (ExpirationPolicy)this.deviceTokenExpirationPolicy.getIfAvailable(), (Collection)this.oauthTokenRequestValidators.getIfAvailable(), (AuditableExecution)this.accessTokenGrantAuditableRequestExtractor.getIfAvailable());
    }

    @ConditionalOnMissingBean(name={"clientRegistrationRequestSerializer"})
    @Bean
    public StringSerializer<OidcClientRegistrationRequest> clientRegistrationRequestSerializer() {
        return new OidcClientRegistrationRequestSerializer();
    }

    @RefreshScope
    @Bean
    public OidcDynamicClientRegistrationEndpointController oidcDynamicClientRegistrationEndpointController() {
        return new OidcDynamicClientRegistrationEndpointController((ServicesManager)this.servicesManager.getIfAvailable(), (TicketRegistry)this.ticketRegistry.getIfAvailable(), (AccessTokenFactory)this.defaultAccessTokenFactory.getIfAvailable(), this.oidcPrincipalFactory(), (ServiceFactory<WebApplicationService>)((ServiceFactory)this.webApplicationServiceFactory.getIfAvailable()), this.clientRegistrationRequestSerializer(), (RandomStringGenerator)new DefaultRandomStringGenerator(), (RandomStringGenerator)new DefaultRandomStringGenerator(), this.profileScopeToAttributesFilter(), this.casProperties, (CookieRetrievingCookieGenerator)this.ticketGrantingTicketCookieGenerator.getIfAvailable());
    }

    @RefreshScope
    @Bean
    public OidcJwksEndpointController oidcJwksController() {
        return new OidcJwksEndpointController((ServicesManager)this.servicesManager.getIfAvailable(), (TicketRegistry)this.ticketRegistry.getIfAvailable(), (AccessTokenFactory)this.defaultAccessTokenFactory.getIfAvailable(), this.oidcPrincipalFactory(), (ServiceFactory<WebApplicationService>)((ServiceFactory)this.webApplicationServiceFactory.getIfAvailable()), this.profileScopeToAttributesFilter(), this.casProperties, (CookieRetrievingCookieGenerator)this.ticketGrantingTicketCookieGenerator.getIfAvailable());
    }

    @Autowired
    @RefreshScope
    @Bean
    public OidcWellKnownEndpointController oidcWellKnownController(@Qualifier(value="oidcServerDiscoverySettingsFactory") OidcServerDiscoverySettings discoverySettings) {
        return new OidcWellKnownEndpointController((ServicesManager)this.servicesManager.getIfAvailable(), (TicketRegistry)this.ticketRegistry.getIfAvailable(), (AccessTokenFactory)this.defaultAccessTokenFactory.getIfAvailable(), this.oidcPrincipalFactory(), (ServiceFactory<WebApplicationService>)((ServiceFactory)this.webApplicationServiceFactory.getIfAvailable()), discoverySettings, this.profileScopeToAttributesFilter(), this.casProperties, (CookieRetrievingCookieGenerator)this.ticketGrantingTicketCookieGenerator.getIfAvailable());
    }

    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcProfileController"})
    @Bean
    public OidcUserProfileEndpointController oidcProfileController() {
        return new OidcUserProfileEndpointController((ServicesManager)this.servicesManager.getIfAvailable(), (TicketRegistry)this.ticketRegistry.getIfAvailable(), (AccessTokenFactory)this.defaultAccessTokenFactory.getIfAvailable(), this.oidcPrincipalFactory(), (ServiceFactory<WebApplicationService>)((ServiceFactory)this.webApplicationServiceFactory.getIfAvailable()), this.profileScopeToAttributesFilter(), this.casProperties, (CookieRetrievingCookieGenerator)this.ticketGrantingTicketCookieGenerator.getIfAvailable(), (OAuth20UserProfileViewRenderer)this.oauthUserProfileViewRenderer.getIfAvailable(), this.oidcUserProfileDataCreator());
    }

    @Bean
    public OAuth20UserProfileDataCreator oidcUserProfileDataCreator() {
        return new OidcUserProfileDataCreator((ServicesManager)this.servicesManager.getIfAvailable(), this.profileScopeToAttributesFilter());
    }

    @RefreshScope
    @Bean
    public OidcAuthorizeEndpointController oidcAuthorizeController() {
        return new OidcAuthorizeEndpointController((ServicesManager)this.servicesManager.getIfAvailable(), (TicketRegistry)this.ticketRegistry.getIfAvailable(), (AccessTokenFactory)this.defaultAccessTokenFactory.getIfAvailable(), this.oidcPrincipalFactory(), (ServiceFactory<WebApplicationService>)((ServiceFactory)this.webApplicationServiceFactory.getIfAvailable()), (OAuthCodeFactory)this.defaultOAuthCodeFactory.getIfAvailable(), this.consentApprovalViewResolver(), this.profileScopeToAttributesFilter(), this.casProperties, (CookieRetrievingCookieGenerator)this.ticketGrantingTicketCookieGenerator.getIfAvailable(), (OAuth20CasAuthenticationBuilder)this.authenticationBuilder.getIfAvailable(), (Set)this.oauthAuthorizationResponseBuilders.getIfAvailable(), (Set)this.oauthRequestValidators.getIfAvailable(), (AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getIfAvailable());
    }

    @Bean
    @RefreshScope
    public MultifactorAuthenticationTrigger oidcMultifactorAuthenticationTrigger() {
        return new OidcMultifactorAuthenticationTrigger(this.casProperties, (MultifactorAuthenticationProviderResolver)this.multifactorAuthenticationProviderResolver.getIfAvailable());
    }

    @RefreshScope
    @Bean
    public CasWebflowEventResolver oidcAuthenticationContextWebflowEventResolver() {
        DefaultMultifactorAuthenticationProviderEventResolver r = new DefaultMultifactorAuthenticationProviderEventResolver((AuthenticationSystemSupport)this.authenticationSystemSupport.getIfAvailable(), (CentralAuthenticationService)this.centralAuthenticationService.getIfAvailable(), (ServicesManager)this.servicesManager.getIfAvailable(), (TicketRegistrySupport)this.ticketRegistrySupport.getIfAvailable(), (CookieGenerator)this.warnCookieGenerator.getIfAvailable(), (AuthenticationServiceSelectionPlan)this.authenticationRequestServiceSelectionStrategies.getIfAvailable(), (MultifactorAuthenticationProviderSelector)this.multifactorAuthenticationProviderSelector.getIfAvailable(), this.oidcMultifactorAuthenticationTrigger(), this.applicationEventPublisher, this.applicationContext);
        ((CasDelegatingWebflowEventResolver)this.initialAuthenticationAttemptWebflowEventResolver.getIfAvailable()).addDelegate((CasWebflowEventResolver)r);
        return r;
    }

    @ConditionalOnMissingBean(name={"oidcWebflowConfigurer"})
    @Bean
    @DependsOn(value={"defaultWebflowConfigurer"})
    public CasWebflowConfigurer oidcWebflowConfigurer() {
        OidcWebflowConfigurer cfg = new OidcWebflowConfigurer((FlowBuilderServices)this.flowBuilderServices.getIfAvailable(), (FlowDefinitionRegistry)this.loginFlowDefinitionRegistry.getIfAvailable(), this.oidcRegisteredServiceUIAction(), (ApplicationContext)this.applicationContext, this.casProperties);
        cfg.setLogoutFlowDefinitionRegistry((FlowDefinitionRegistry)this.logoutFlowDefinitionRegistry.getIfAvailable());
        return cfg;
    }

    @ConditionalOnMissingBean(name={"oidcRegisteredServiceUIAction"})
    @Bean
    public Action oidcRegisteredServiceUIAction() {
        return new OidcRegisteredServiceUIAction((ServicesManager)this.servicesManager.getIfAvailable(), (AuthenticationServiceSelectionStrategy)this.oauth20AuthenticationServiceSelectionStrategy.getIfAvailable());
    }

    @Bean
    public IdTokenSigningAndEncryptionService oidcTokenSigningAndEncryptionService() {
        OidcProperties oidc = this.casProperties.getAuthn().getOidc();
        return new OidcIdTokenSigningAndEncryptionService(this.oidcDefaultJsonWebKeystoreCache(), this.oidcServiceJsonWebKeystoreCache(), oidc.getIssuer());
    }

    @Bean
    public LoadingCache<OidcRegisteredService, Optional<RsaJsonWebKey>> oidcServiceJsonWebKeystoreCache() {
        OidcProperties oidc = this.casProperties.getAuthn().getOidc();
        return Caffeine.newBuilder().maximumSize(1L).expireAfterWrite((long)oidc.getJwksCacheInMinutes(), TimeUnit.MINUTES).build(this.oidcServiceJsonWebKeystoreCacheLoader());
    }

    @Bean
    public LoadingCache<String, Optional<RsaJsonWebKey>> oidcDefaultJsonWebKeystoreCache() {
        OidcProperties oidc = this.casProperties.getAuthn().getOidc();
        return Caffeine.newBuilder().maximumSize(1L).expireAfterWrite((long)oidc.getJwksCacheInMinutes(), TimeUnit.MINUTES).build((CacheLoader)this.oidcDefaultJsonWebKeystoreCacheLoader());
    }

    @Bean
    public OidcDefaultJsonWebKeystoreCacheLoader oidcDefaultJsonWebKeystoreCacheLoader() {
        return new OidcDefaultJsonWebKeystoreCacheLoader(this.casProperties.getAuthn().getOidc().getJwksFile());
    }

    @Bean
    public CacheLoader<OidcRegisteredService, Optional<RsaJsonWebKey>> oidcServiceJsonWebKeystoreCacheLoader() {
        return new OidcServiceJsonWebKeystoreCacheLoader(this.resourceLoader);
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcServerDiscoverySettingsFactory"})
    public FactoryBean<OidcServerDiscoverySettings> oidcServerDiscoverySettingsFactory() {
        return new OidcServerDiscoverySettingsFactory(this.casProperties);
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcJsonWebKeystoreGeneratorService"})
    public OidcJsonWebKeystoreGeneratorService oidcJsonWebKeystoreGeneratorService() {
        OidcJsonWebKeystoreGeneratorService s = new OidcJsonWebKeystoreGeneratorService(this.casProperties.getAuthn().getOidc());
        s.generate();
        return s;
    }

    @Bean
    public HandlerInterceptorAdapter oauthInterceptor() {
        OidcProperties oidc = this.casProperties.getAuthn().getOidc();
        OidcConstants.DynamicClientRegistrationMode mode = OidcConstants.DynamicClientRegistrationMode.valueOf((String)((String)StringUtils.defaultIfBlank((CharSequence)oidc.getDynamicClientRegistrationMode(), (CharSequence)OidcConstants.DynamicClientRegistrationMode.PROTECTED.name())));
        return new OidcHandlerInterceptorAdapter((HandlerInterceptorAdapter)this.requiresAuthenticationAccessTokenInterceptor.getIfAvailable(), this.requiresAuthenticationAuthorizeInterceptor(), this.requiresAuthenticationDynamicRegistrationInterceptor(), mode, (Collection)this.accessTokenGrantRequestExtractors.getIfAvailable());
    }

    @RefreshScope
    @Bean
    public Collection<BaseOidcScopeAttributeReleasePolicy> userDefinedScopeBasedAttributeReleasePolicies() {
        OidcProperties oidc = this.casProperties.getAuthn().getOidc();
        return oidc.getUserDefinedScopes().entrySet().stream().map(k -> new OidcCustomScopeAttributeReleasePolicy((String)k.getKey(), CollectionUtils.wrapList((Object[])((String)k.getValue()).split(",")))).collect(Collectors.toSet());
    }

    @Bean
    public OidcRegisteredServicePreProcessorEventListener oidcRegisteredServicePreProcessorEventListener() {
        return new OidcRegisteredServicePreProcessorEventListener(this.profileScopeToAttributesFilter());
    }

    @Bean
    public OAuth20AuthorizationResponseBuilder oidcImplicitIdTokenCallbackUrlBuilder() {
        return new OidcImplicitIdTokenAuthorizationResponseBuilder(this.oidcIdTokenGenerator(), (OAuth20TokenGenerator)this.oauthTokenGenerator.getIfAvailable(), (ExpirationPolicy)this.accessTokenExpirationPolicy.getIfAvailable(), (ExpirationPolicy)this.grantingTicketExpirationPolicy.getIfAvailable());
    }

    public void configureWebflowExecutionPlan(CasWebflowExecutionPlan plan) {
        plan.registerWebflowConfigurer(this.oidcWebflowConfigurer());
    }
}

