/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.token;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.ticket.BaseIdTokenGeneratorService;
import org.apereo.cas.ticket.IdTokenSigningAndEncryptionService;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.accesstoken.AccessToken;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.Pac4jUtils;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcIdTokenGeneratorService
extends BaseIdTokenGeneratorService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcIdTokenGeneratorService.class);

    public OidcIdTokenGeneratorService(CasConfigurationProperties casProperties, IdTokenSigningAndEncryptionService signingService, ServicesManager servicesManager, TicketRegistry ticketRegistry) {
        super(casProperties, signingService, servicesManager, ticketRegistry);
    }

    public String generate(HttpServletRequest request, HttpServletResponse response, AccessToken accessToken, long timeoutInSeconds, OAuth20ResponseTypes responseType, OAuthRegisteredService registeredService) {
        if (!(registeredService instanceof OidcRegisteredService)) {
            throw new IllegalArgumentException("Registered service instance is not an OIDC service");
        }
        OidcRegisteredService oidcRegisteredService = (OidcRegisteredService)registeredService;
        J2EContext context = Pac4jUtils.getPac4jJ2EContext((HttpServletRequest)request, (HttpServletResponse)response);
        LOGGER.trace("Attempting to produce claims for the id token [{}]", (Object)accessToken);
        CommonProfile authenticatedProfile = this.getAuthenticatedProfile(request, response);
        JwtClaims claims = this.buildJwtClaims(request, accessToken, timeoutInSeconds, oidcRegisteredService, (UserProfile)authenticatedProfile, context, responseType);
        return this.encodeAndFinalizeToken(claims, (OAuthRegisteredService)oidcRegisteredService, accessToken);
    }

    protected JwtClaims buildJwtClaims(HttpServletRequest request, AccessToken accessTokenId, long timeoutInSeconds, OidcRegisteredService service, UserProfile profile, J2EContext context, OAuth20ResponseTypes responseType) {
        Set val;
        Authentication authentication = accessTokenId.getAuthentication();
        Principal principal = authentication.getPrincipal();
        OidcProperties oidc = this.casProperties.getAuthn().getOidc();
        JwtClaims claims = new JwtClaims();
        String jwtId = this.getJwtId(accessTokenId.getTicketGrantingTicket());
        claims.setJwtId(jwtId);
        claims.setIssuer(oidc.getIssuer());
        claims.setAudience(service.getClientId());
        NumericDate expirationDate = NumericDate.now();
        expirationDate.addSeconds(timeoutInSeconds);
        claims.setExpirationTime(expirationDate);
        claims.setIssuedAtToNow();
        claims.setNotBeforeMinutesInThePast((float)oidc.getSkew());
        claims.setSubject(principal.getId());
        MultifactorAuthenticationProperties mfa = this.casProperties.getAuthn().getMfa();
        Map attributes = authentication.getAttributes();
        if (attributes.containsKey(mfa.getAuthenticationContextAttribute())) {
            val = CollectionUtils.toCollection(attributes.get(mfa.getAuthenticationContextAttribute()));
            claims.setStringClaim("acr", val.iterator().next().toString());
        }
        if (attributes.containsKey("successfulAuthenticationHandlers")) {
            val = CollectionUtils.toCollection(attributes.get("successfulAuthenticationHandlers"));
            claims.setStringListClaim("amr", val.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
        }
        claims.setStringClaim("client_id", service.getClientId());
        claims.setClaim("state", attributes.get("state"));
        claims.setClaim("nonce", attributes.get("nonce"));
        claims.setClaim("at_hash", (Object)this.generateAccessTokenHash(accessTokenId, service));
        principal.getAttributes().entrySet().stream().filter(entry -> oidc.getClaims().contains(entry.getKey())).forEach(entry -> claims.setClaim((String)entry.getKey(), entry.getValue()));
        if (!claims.hasClaim("preferred_username")) {
            claims.setClaim("preferred_username", (Object)profile.getId());
        }
        return claims;
    }

    protected String getJwtId(TicketGrantingTicket tgt) {
        String oAuthCallbackUrl = this.casProperties.getServer().getPrefix() + "/oauth2.0/callbackAuthorize.*";
        Optional<Map.Entry> oAuthServiceTicket = Stream.concat(tgt.getServices().entrySet().stream(), tgt.getProxyGrantingTickets().entrySet().stream()).filter(e -> {
            RegisteredService service = this.servicesManager.findServiceBy((Service)e.getValue());
            return service != null && service.getServiceId().equals(oAuthCallbackUrl);
        }).findFirst();
        if (oAuthServiceTicket.isEmpty()) {
            LOGGER.trace("Cannot find ticket issued to [{}] as part of the authentication context", (Object)oAuthCallbackUrl);
            return tgt.getId();
        }
        return (String)oAuthServiceTicket.get().getKey();
    }

    protected String generateAccessTokenHash(AccessToken accessTokenId, OidcRegisteredService service) {
        byte[] tokenBytes = accessTokenId.getId().getBytes(StandardCharsets.UTF_8);
        String hashAlg = this.getSigningHashAlgorithm(service);
        LOGGER.debug("Digesting access token hash via algorithm [{}]", (Object)hashAlg);
        byte[] digested = DigestUtils.rawDigest((String)hashAlg, (byte[])tokenBytes);
        byte[] hashBytesLeftHalf = Arrays.copyOf(digested, digested.length / 2);
        return EncodingUtils.encodeUrlSafeBase64((byte[])hashBytesLeftHalf);
    }

    protected String getSigningHashAlgorithm(OidcRegisteredService service) {
        String alg = this.signingService.getJsonWebKeySigningAlgorithm((OAuthRegisteredService)service);
        LOGGER.debug("Signing algorithm specified by service [{}] is [{}]", (Object)service.getServiceId(), (Object)alg);
        if ("RS512".equalsIgnoreCase(alg)) {
            return "SHA-512";
        }
        if ("RS384".equalsIgnoreCase(alg)) {
            return "SHA-384";
        }
        if ("RS256".equalsIgnoreCase(alg)) {
            return "SHA-256";
        }
        throw new IllegalArgumentException("Could not determine the hash algorithm for the id token issued to service " + service.getServiceId());
    }
}

