/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.util;

import java.net.URISyntaxException;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.Pac4jUtils;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcAuthorizationRequestSupport {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcAuthorizationRequestSupport.class);
    private final CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator;
    private final TicketRegistrySupport ticketRegistrySupport;

    public static Set<String> getOidcPromptFromAuthorizationRequest(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked @NonNull but is null");
        }
        return new URIBuilder(url).getQueryParams().stream().filter(p -> "prompt".equals(p.getName())).map(param -> param.getValue().split(" ")).flatMap(Arrays::stream).collect(Collectors.toSet());
    }

    public static Set<String> getOidcPromptFromAuthorizationRequest(WebContext context) {
        return OidcAuthorizationRequestSupport.getOidcPromptFromAuthorizationRequest(context.getFullRequestURL());
    }

    public static Optional<Long> getOidcMaxAgeFromAuthorizationRequest(WebContext context) {
        URIBuilder builderContext = new URIBuilder(context.getFullRequestURL());
        Optional<NameValuePair> parameter = builderContext.getQueryParams().stream().filter(p -> "max_age".equals(p.getName())).findFirst();
        if (parameter.isPresent()) {
            long maxAge = NumberUtils.toLong((String)parameter.get().getValue(), (long)-1L);
            return Optional.of(maxAge);
        }
        return Optional.empty();
    }

    public static Optional<UserProfile> isAuthenticationProfileAvailable(WebContext context) {
        ProfileManager manager = Pac4jUtils.getPac4jProfileManager((WebContext)context);
        return manager.get(true);
    }

    public Optional<Authentication> isCasAuthenticationAvailable(WebContext context) {
        Authentication authentication;
        String tgtId;
        J2EContext j2EContext = (J2EContext)context;
        if (j2EContext != null && StringUtils.isNotBlank((CharSequence)(tgtId = this.ticketGrantingTicketCookieGenerator.retrieveCookieValue(j2EContext.getRequest()))) && (authentication = this.ticketRegistrySupport.getAuthenticationFrom(tgtId)) != null) {
            return Optional.of(authentication);
        }
        return Optional.empty();
    }

    public static boolean isCasAuthenticationOldForMaxAgeAuthorizationRequest(WebContext context, ZonedDateTime authenticationDate) {
        long authTime;
        long now;
        long diffInSeconds;
        Optional<Long> maxAge = OidcAuthorizationRequestSupport.getOidcMaxAgeFromAuthorizationRequest(context);
        if (maxAge.isPresent() && maxAge.get() > 0L && (diffInSeconds = (now = ZonedDateTime.now().toEpochSecond()) - (authTime = authenticationDate.toEpochSecond())) > maxAge.get()) {
            LOGGER.info("Authentication is too old: [{}] and was created [{}] seconds ago.", (Object)authTime, (Object)diffInSeconds);
            return true;
        }
        return false;
    }

    public static boolean isCasAuthenticationOldForMaxAgeAuthorizationRequest(WebContext context, Authentication authentication) {
        return OidcAuthorizationRequestSupport.isCasAuthenticationOldForMaxAgeAuthorizationRequest(context, authentication.getAuthenticationDate());
    }

    public boolean isCasAuthenticationOldForMaxAgeAuthorizationRequest(WebContext context) {
        return this.isCasAuthenticationAvailable(context).filter(a -> OidcAuthorizationRequestSupport.isCasAuthenticationOldForMaxAgeAuthorizationRequest(context, a)).isPresent();
    }

    public static boolean isCasAuthenticationOldForMaxAgeAuthorizationRequest(WebContext context, UserProfile profile) {
        Object authTime = profile.getAttribute("authenticationDate");
        if (authTime == null) {
            return false;
        }
        ZonedDateTime dt = ZonedDateTime.parse(authTime.toString());
        return OidcAuthorizationRequestSupport.isCasAuthenticationOldForMaxAgeAuthorizationRequest(context, dt);
    }

    public static String removeOidcPromptFromAuthorizationRequest(String url, String prompt) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(url);
        List currentQueryParams = uriBuilder.getQueryParams();
        List newParams = currentQueryParams.stream().filter(p -> !"prompt".equals(p.getName()) || !p.getValue().equalsIgnoreCase(prompt)).collect(Collectors.toList());
        if (newParams.size() != currentQueryParams.size()) {
            return uriBuilder.removeQuery().addParameters(newParams).build().toASCIIString();
        }
        return url;
    }

    @Generated
    public OidcAuthorizationRequestSupport(CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator, TicketRegistrySupport ticketRegistrySupport) {
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
        this.ticketRegistrySupport = ticketRegistrySupport;
    }
}

