/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.oidc.util.OidcAuthorizationRequestSupport;
import org.apereo.cas.support.oauth.web.views.OAuth20CallbackAuthorizeViewResolver;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.profile.ProfileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

public class OidcCallbackAuthorizeViewResolver
implements OAuth20CallbackAuthorizeViewResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcCallbackAuthorizeViewResolver.class);

    public ModelAndView resolve(J2EContext ctx, ProfileManager manager, String url) {
        Set<String> prompt = OidcAuthorizationRequestSupport.getOidcPromptFromAuthorizationRequest(url);
        if (prompt.contains("login")) {
            LOGGER.trace("Removing prompt query parameter from URL [{}]", (Object)url);
            try {
                String newUrl = OidcAuthorizationRequestSupport.removeOidcPromptFromAuthorizationRequest(url, "login");
                LOGGER.trace("Redirecting to URL [{}]", (Object)newUrl);
                return new ModelAndView((View)new RedirectView(newUrl));
            }
            catch (URISyntaxException e) {
                LOGGER.error("Error removing prompt query parameter from URL [{}]", (Object)e.getMessage());
                return null;
            }
        }
        if (prompt.contains("none")) {
            Optional result = manager.get(true);
            if (result.isPresent()) {
                return new ModelAndView(url);
            }
            HashMap<String, String> model = new HashMap<String, String>();
            model.put("error", "login_required");
            return new ModelAndView((View)new MappingJackson2JsonView(), model);
        }
        return new ModelAndView((View)new RedirectView(url));
    }

    @Generated
    public OidcCallbackAuthorizeViewResolver() {
    }
}

