/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.config;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.RestEndpointProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcWebFingerProperties;
import org.apereo.cas.logout.slo.SingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.authn.OidcAccessTokenAuthenticator;
import org.apereo.cas.oidc.authn.OidcCasCallbackUrlResolver;
import org.apereo.cas.oidc.authn.OidcClientConfigurationAccessTokenAuthenticator;
import org.apereo.cas.oidc.authn.OidcClientSecretJwtAuthenticator;
import org.apereo.cas.oidc.authn.OidcPrivateKeyJwtAuthenticator;
import org.apereo.cas.oidc.claims.mapping.OidcAttributeToScopeClaimMapper;
import org.apereo.cas.oidc.claims.mapping.OidcDefaultAttributeToScopeClaimMapper;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettings;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettingsFactory;
import org.apereo.cas.oidc.discovery.webfinger.OidcWebFingerDiscoveryService;
import org.apereo.cas.oidc.discovery.webfinger.OidcWebFingerUserInfoRepository;
import org.apereo.cas.oidc.discovery.webfinger.userinfo.OidcEchoingWebFingerUserInfoRepository;
import org.apereo.cas.oidc.discovery.webfinger.userinfo.OidcGroovyWebFingerUserInfoRepository;
import org.apereo.cas.oidc.discovery.webfinger.userinfo.OidcRestfulWebFingerUserInfoRepository;
import org.apereo.cas.oidc.dynareg.OidcClientRegistrationRequest;
import org.apereo.cas.oidc.dynareg.OidcClientRegistrationRequestSerializer;
import org.apereo.cas.oidc.issuer.OidcDefaultIssuerService;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.oidc.jwks.OidcRegisteredServiceJsonWebKeystoreCacheLoader;
import org.apereo.cas.oidc.jwks.OidcServiceJsonWebKeystoreCacheExpirationPolicy;
import org.apereo.cas.oidc.profile.OidcProfileScopeToAttributesFilter;
import org.apereo.cas.oidc.profile.OidcUserProfileDataCreator;
import org.apereo.cas.oidc.profile.OidcUserProfileSigningAndEncryptionService;
import org.apereo.cas.oidc.profile.OidcUserProfileViewRenderer;
import org.apereo.cas.oidc.scopes.DefaultOidcAttributeReleasePolicyFactory;
import org.apereo.cas.oidc.scopes.OidcAttributeReleasePolicyFactory;
import org.apereo.cas.oidc.services.OidcServiceRegistryListener;
import org.apereo.cas.oidc.services.OidcServicesManagerRegisteredServiceLocator;
import org.apereo.cas.oidc.token.OidcIdTokenSigningAndEncryptionService;
import org.apereo.cas.oidc.token.OidcJwtAccessTokenCipherExecutor;
import org.apereo.cas.oidc.token.OidcRegisteredServiceJwtAccessTokenCipherExecutor;
import org.apereo.cas.oidc.util.OidcRequestSupport;
import org.apereo.cas.oidc.web.OidcAuthenticationAuthorizeSecurityLogic;
import org.apereo.cas.oidc.web.OidcCasClientRedirectActionBuilder;
import org.apereo.cas.oidc.web.OidcConsentApprovalViewResolver;
import org.apereo.cas.services.RegisteredServiceCipherExecutor;
import org.apereo.cas.services.ServiceRegistryListener;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.ServicesManagerRegisteredServiceLocator;
import org.apereo.cas.support.oauth.authenticator.OAuth20AuthenticationClientProvider;
import org.apereo.cas.support.oauth.authenticator.OAuth20CasAuthenticationBuilder;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.profile.OAuth20UserProfileDataCreator;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20AuthorizationRequestValidator;
import org.apereo.cas.support.oauth.validator.token.OAuth20TokenRequestValidator;
import org.apereo.cas.support.oauth.web.response.OAuth20CasClientRedirectActionBuilder;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20InvalidAuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.views.ConsentApprovalViewResolver;
import org.apereo.cas.support.oauth.web.views.OAuth20CallbackAuthorizeViewResolver;
import org.apereo.cas.support.oauth.web.views.OAuth20UserProfileViewRenderer;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.OAuth20TokenSigningAndEncryptionService;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessTokenFactory;
import org.apereo.cas.ticket.accesstoken.OAuth20JwtBuilder;
import org.apereo.cas.ticket.code.OAuth20CodeFactory;
import org.apereo.cas.ticket.device.OAuth20DeviceTokenFactory;
import org.apereo.cas.ticket.device.OAuth20DeviceUserCodeFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.gen.DefaultRandomStringGenerator;
import org.apereo.cas.util.gen.RandomStringGenerator;
import org.apereo.cas.util.serialization.StringSerializer;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.jose4j.jwk.PublicJsonWebKey;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.extractor.BearerAuthExtractor;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.engine.SecurityLogic;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.http.adapter.JEEHttpActionAdapter;
import org.pac4j.core.http.url.UrlResolver;
import org.pac4j.http.client.direct.DirectFormClient;
import org.pac4j.http.client.direct.HeaderClient;
import org.pac4j.springframework.web.SecurityInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;

@Configuration(value="oidcConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class OidcConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcConfiguration.class);
    @Autowired
    @Qualifier(value="oidcAuthorizationResponseBuilders")
    private ObjectProvider<Set<OAuth20AuthorizationResponseBuilder>> oidcAuthorizationResponseBuilders;
    @Autowired
    @Qualifier(value="oauthRegisteredServiceCipherExecutor")
    private ObjectProvider<CipherExecutor> oauthRegisteredServiceCipherExecutor;
    @Autowired
    @Qualifier(value="oauthDistributedSessionStore")
    private ObjectProvider<SessionStore> oauthDistributedSessionStore;
    @Autowired
    @Qualifier(value="oidcDefaultJsonWebKeystoreCache")
    private ObjectProvider<LoadingCache<String, Optional<PublicJsonWebKey>>> oidcDefaultJsonWebKeystoreCache;
    @Autowired
    @Qualifier(value="registeredServiceAccessStrategyEnforcer")
    private ObjectProvider<AuditableExecution> registeredServiceAccessStrategyEnforcer;
    @Autowired
    @Qualifier(value="oauthAuthorizationRequestValidators")
    private ObjectProvider<Set<OAuth20AuthorizationRequestValidator>> oauthRequestValidators;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ObjectProvider<ServiceFactory<WebApplicationService>> webApplicationServiceFactory;
    @Autowired
    @Qualifier(value="deviceTokenExpirationPolicy")
    private ObjectProvider<ExpirationPolicyBuilder> deviceTokenExpirationPolicy;
    @Autowired
    @Qualifier(value="oauthCasAuthenticationBuilder")
    private ObjectProvider<OAuth20CasAuthenticationBuilder> authenticationBuilder;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private ObjectProvider<CentralAuthenticationService> centralAuthenticationService;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="singleLogoutServiceLogoutUrlBuilder")
    private ObjectProvider<SingleLogoutServiceLogoutUrlBuilder> singleLogoutServiceLogoutUrlBuilder;
    @Autowired
    @Qualifier(value="oauthSecConfig")
    private ObjectProvider<Config> oauthSecConfig;
    @Autowired
    @Qualifier(value="ticketGrantingTicketCookieGenerator")
    private ObjectProvider<CasCookieBuilder> ticketGrantingTicketCookieGenerator;
    @Autowired
    @Qualifier(value="defaultTicketRegistrySupport")
    private ObjectProvider<TicketRegistrySupport> ticketRegistrySupport;
    @Autowired
    @Qualifier(value="defaultDeviceTokenFactory")
    private ObjectProvider<OAuth20DeviceTokenFactory> defaultDeviceTokenFactory;
    @Autowired
    @Qualifier(value="defaultDeviceUserCodeFactory")
    private ObjectProvider<OAuth20DeviceUserCodeFactory> defaultDeviceUserCodeFactory;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="ticketRegistry")
    private ObjectProvider<TicketRegistry> ticketRegistry;
    @Autowired
    @Qualifier(value="callbackAuthorizeViewResolver")
    private ObjectProvider<OAuth20CallbackAuthorizeViewResolver> callbackAuthorizeViewResolver;
    @Autowired
    @Qualifier(value="defaultOAuthCodeFactory")
    private ObjectProvider<OAuth20CodeFactory> defaultOAuthCodeFactory;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="oidcAccessTokenResponseGenerator")
    private ObjectProvider<OAuth20AccessTokenResponseGenerator> oidcAccessTokenResponseGenerator;
    @Autowired
    @Qualifier(value="oauthTokenRequestValidators")
    private ObjectProvider<Collection<OAuth20TokenRequestValidator>> oauthTokenRequestValidators;
    @Autowired
    @Qualifier(value="oauthDistributedSessionCookieGenerator")
    private ObjectProvider<CasCookieBuilder> oauthDistributedSessionCookieGenerator;
    @Autowired
    @Qualifier(value="oauthInvalidAuthorizationBuilder")
    private ObjectProvider<OAuth20InvalidAuthorizationResponseBuilder> oauthInvalidAuthorizationBuilder;
    @Autowired
    @Qualifier(value="defaultAccessTokenFactory")
    private ObjectProvider<OAuth20AccessTokenFactory> defaultAccessTokenFactory;
    @Autowired
    @Qualifier(value="oauthTokenGenerator")
    private ObjectProvider<OAuth20TokenGenerator> oauthTokenGenerator;

    @Bean
    public ConsentApprovalViewResolver consentApprovalViewResolver() {
        return new OidcConsentApprovalViewResolver(this.casProperties, (SessionStore)this.oauthDistributedSessionStore.getObject());
    }

    @Bean
    public OAuth20CasClientRedirectActionBuilder oauthCasClientRedirectActionBuilder() {
        return new OidcCasClientRedirectActionBuilder(this.oidcRequestSupport());
    }

    @Bean
    public HandlerInterceptor requiresAuthenticationAuthorizeInterceptor() {
        SecurityInterceptor interceptor = new SecurityInterceptor((Config)this.oauthSecConfig.getObject(), "CasOAuthClient", (HttpActionAdapter)JEEHttpActionAdapter.INSTANCE);
        interceptor.setMatchers("securityheaders");
        interceptor.setAuthorizers("isFullyAuthenticated");
        interceptor.setSecurityLogic((SecurityLogic)new OidcAuthenticationAuthorizeSecurityLogic());
        return interceptor;
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcCasClientRedirectActionBuilder"})
    @RefreshScope
    public OAuth20CasClientRedirectActionBuilder oidcCasClientRedirectActionBuilder() {
        return new OidcCasClientRedirectActionBuilder(this.oidcRequestSupport());
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcRequestSupport"})
    @RefreshScope
    public OidcRequestSupport oidcRequestSupport() {
        return new OidcRequestSupport((CasCookieBuilder)this.ticketGrantingTicketCookieGenerator.getObject(), (TicketRegistrySupport)this.ticketRegistrySupport.getObject(), this.oidcIssuerService());
    }

    @ConditionalOnMissingBean(name={"oidcPrincipalFactory"})
    @Bean
    @RefreshScope
    public PrincipalFactory oidcPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcAttributeToScopeClaimMapper"})
    public OidcAttributeToScopeClaimMapper oidcAttributeToScopeClaimMapper() {
        Map mappings = this.casProperties.getAuthn().getOidc().getCore().getClaimsMap();
        return new OidcDefaultAttributeToScopeClaimMapper(mappings);
    }

    @Bean
    @RefreshScope
    public OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter() {
        return new OidcProfileScopeToAttributesFilter(this.oidcPrincipalFactory(), this.casProperties, this.oidcAttributeReleasePolicyFactory());
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcServiceRegistryListener"})
    public ServiceRegistryListener oidcServiceRegistryListener() {
        return new OidcServiceRegistryListener(this.oidcAttributeReleasePolicyFactory());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcAttributeReleasePolicyFactory"})
    public OidcAttributeReleasePolicyFactory oidcAttributeReleasePolicyFactory() {
        return new DefaultOidcAttributeReleasePolicyFactory(this.casProperties);
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcServicesManagerRegisteredServiceLocator"})
    public ServicesManagerRegisteredServiceLocator oidcServicesManagerRegisteredServiceLocator() {
        return new OidcServicesManagerRegisteredServiceLocator();
    }

    @ConditionalOnMissingBean(name={"clientRegistrationRequestSerializer"})
    @Bean
    @RefreshScope
    public StringSerializer<OidcClientRegistrationRequest> clientRegistrationRequestSerializer() {
        return new OidcClientRegistrationRequestSerializer();
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"oidcWebFingerDiscoveryService"})
    public OidcWebFingerDiscoveryService oidcWebFingerDiscoveryService() throws Exception {
        return new OidcWebFingerDiscoveryService(this.oidcWebFingerUserInfoRepository(), (OidcServerDiscoverySettings)this.oidcServerDiscoverySettingsFactory().getObject());
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcWebFingerUserInfoRepository"})
    public OidcWebFingerUserInfoRepository oidcWebFingerUserInfoRepository() {
        OidcWebFingerProperties.UserInfoRepository userInfo = this.casProperties.getAuthn().getOidc().getWebfinger().getUserInfo();
        if (userInfo.getGroovy().getLocation() != null) {
            return new OidcGroovyWebFingerUserInfoRepository(userInfo.getGroovy().getLocation());
        }
        if (StringUtils.isNotBlank((CharSequence)userInfo.getRest().getUrl())) {
            return new OidcRestfulWebFingerUserInfoRepository((RestEndpointProperties)userInfo.getRest());
        }
        LOGGER.info("Using [{}] to locate webfinger resources, which is NOT appropriate for production purposes, as it will always echo back the given username/email address and is only useful for testing/demo purposes. Consider choosing and configuring a different repository implementation for locating and fetching user information for webfinger resources, etc.", (Object)OidcEchoingWebFingerUserInfoRepository.class.getSimpleName());
        return new OidcEchoingWebFingerUserInfoRepository();
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcUserProfileDataCreator"})
    @RefreshScope
    public OAuth20UserProfileDataCreator oidcUserProfileDataCreator() {
        return new OidcUserProfileDataCreator((ServicesManager)this.servicesManager.getObject(), this.profileScopeToAttributesFilter());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcTokenSigningAndEncryptionService"})
    public OAuth20TokenSigningAndEncryptionService oidcTokenSigningAndEncryptionService() throws Exception {
        return new OidcIdTokenSigningAndEncryptionService((LoadingCache)this.oidcDefaultJsonWebKeystoreCache.getObject(), this.oidcServiceJsonWebKeystoreCache(), this.oidcIssuerService(), (OidcServerDiscoverySettings)this.oidcServerDiscoverySettingsFactory().getObject());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcUserProfileSigningAndEncryptionService"})
    public OAuth20TokenSigningAndEncryptionService oidcUserProfileSigningAndEncryptionService() throws Exception {
        return new OidcUserProfileSigningAndEncryptionService((LoadingCache)this.oidcDefaultJsonWebKeystoreCache.getObject(), this.oidcServiceJsonWebKeystoreCache(), this.oidcIssuerService(), (OidcServerDiscoverySettings)this.oidcServerDiscoverySettingsFactory().getObject());
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcServiceJsonWebKeystoreCache"})
    @RefreshScope
    public LoadingCache<OAuthRegisteredService, Optional<PublicJsonWebKey>> oidcServiceJsonWebKeystoreCache() {
        return Caffeine.newBuilder().maximumSize(1L).expireAfter((Expiry)new OidcServiceJsonWebKeystoreCacheExpirationPolicy(this.casProperties)).build(this.oidcServiceJsonWebKeystoreCacheLoader());
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcServiceJsonWebKeystoreCacheLoader"})
    public CacheLoader<OAuthRegisteredService, Optional<PublicJsonWebKey>> oidcServiceJsonWebKeystoreCacheLoader() {
        return new OidcRegisteredServiceJsonWebKeystoreCacheLoader((ApplicationContext)this.applicationContext);
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcServerDiscoverySettingsFactory"})
    public FactoryBean<OidcServerDiscoverySettings> oidcServerDiscoverySettingsFactory() {
        return new OidcServerDiscoverySettingsFactory(this.casProperties, this.oidcIssuerService(), this.applicationContext);
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcRegisteredServiceJwtAccessTokenCipherExecutor"})
    public RegisteredServiceCipherExecutor oidcRegisteredServiceJwtAccessTokenCipherExecutor() {
        return new OidcRegisteredServiceJwtAccessTokenCipherExecutor((LoadingCache)this.oidcDefaultJsonWebKeystoreCache.getObject(), this.oidcServiceJsonWebKeystoreCache(), this.oidcIssuerService());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcAccessTokenJwtCipherExecutor"})
    public CipherExecutor<Serializable, String> oidcAccessTokenJwtCipherExecutor() {
        return new OidcJwtAccessTokenCipherExecutor((LoadingCache)this.oidcDefaultJsonWebKeystoreCache.getObject(), this.oidcIssuerService());
    }

    @Bean
    public OAuth20AuthenticationClientProvider oidcClientConfigurationAuthenticationClientProvider() {
        return () -> {
            HeaderClient accessTokenClient = new HeaderClient();
            accessTokenClient.setCredentialsExtractor((CredentialsExtractor)new BearerAuthExtractor());
            accessTokenClient.setAuthenticator((Authenticator)new OidcClientConfigurationAccessTokenAuthenticator((TicketRegistry)this.ticketRegistry.getObject(), this.accessTokenJwtBuilder()));
            accessTokenClient.setName("ClientRegistrationClient");
            accessTokenClient.init();
            return accessTokenClient;
        };
    }

    @Bean
    public OAuth20AuthenticationClientProvider oidcPrivateKeyJwtClientProvider() {
        return () -> {
            DirectFormClient privateKeyJwtClient = new DirectFormClient((Authenticator)new OidcPrivateKeyJwtAuthenticator((ServicesManager)this.servicesManager.getObject(), (AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject(), (TicketRegistry)this.ticketRegistry.getObject(), (ServiceFactory)this.webApplicationServiceFactory.getObject(), this.casProperties, (ApplicationContext)this.applicationContext));
            privateKeyJwtClient.setName("ClientPrivateKeyJwtClient");
            privateKeyJwtClient.setUsernameParameter("client_assertion_type");
            privateKeyJwtClient.setPasswordParameter("client_assertion");
            privateKeyJwtClient.init();
            return privateKeyJwtClient;
        };
    }

    @Bean
    public OAuth20AuthenticationClientProvider oidcClientSecretJwtClientProvider() {
        return () -> {
            DirectFormClient client = new DirectFormClient((Authenticator)new OidcClientSecretJwtAuthenticator((ServicesManager)this.servicesManager.getObject(), (AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject(), (TicketRegistry)this.ticketRegistry.getObject(), (ServiceFactory)this.webApplicationServiceFactory.getObject(), this.casProperties, (ApplicationContext)this.applicationContext));
            client.setName("ClientSecretJwtClient");
            client.setUsernameParameter("client_assertion_type");
            client.setPasswordParameter("client_assertion");
            client.init();
            return client;
        };
    }

    @Bean
    public Authenticator oAuthAccessTokenAuthenticator() throws Exception {
        return new OidcAccessTokenAuthenticator((TicketRegistry)this.ticketRegistry.getObject(), this.oidcTokenSigningAndEncryptionService(), (ServicesManager)this.servicesManager.getObject(), this.accessTokenJwtBuilder());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcCasCallbackUrlResolver"})
    public UrlResolver casCallbackUrlResolver() {
        return new OidcCasCallbackUrlResolver(this.casProperties);
    }

    @ConditionalOnMissingBean(name={"oidcUserProfileViewRenderer"})
    @Bean
    @RefreshScope
    public OAuth20UserProfileViewRenderer oidcUserProfileViewRenderer() throws Exception {
        return new OidcUserProfileViewRenderer(this.casProperties.getAuthn().getOauth(), (ServicesManager)this.servicesManager.getObject(), this.oidcUserProfileSigningAndEncryptionService());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcAccessTokenJwtBuilder"})
    public JwtBuilder accessTokenJwtBuilder() {
        return new OAuth20JwtBuilder(this.oidcAccessTokenJwtCipherExecutor(), (ServicesManager)this.servicesManager.getObject(), this.oidcRegisteredServiceJwtAccessTokenCipherExecutor());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcIssuerService"})
    public OidcIssuerService oidcIssuerService() {
        return new OidcDefaultIssuerService(this.casProperties.getAuthn().getOidc());
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcConfigurationContext"})
    public OidcConfigurationContext oidcConfigurationContext() {
        return (OidcConfigurationContext)((OidcConfigurationContext.OidcConfigurationContextBuilder)((OidcConfigurationContext.OidcConfigurationContextBuilder)OidcConfigurationContext.builder().oidcRequestSupport(this.oidcRequestSupport()).issuerService(this.oidcIssuerService()).attributeToScopeClaimMapper(this.oidcAttributeToScopeClaimMapper()).applicationContext(this.applicationContext)).registeredServiceCipherExecutor((CipherExecutor)this.oauthRegisteredServiceCipherExecutor.getObject())).sessionStore((SessionStore)this.oauthDistributedSessionStore.getObject()).servicesManager((ServicesManager)this.servicesManager.getObject()).ticketRegistry((TicketRegistry)this.ticketRegistry.getObject()).accessTokenFactory((OAuth20AccessTokenFactory)this.defaultAccessTokenFactory.getObject()).deviceTokenFactory((OAuth20DeviceTokenFactory)this.defaultDeviceTokenFactory.getObject()).deviceUserCodeFactory((OAuth20DeviceUserCodeFactory)this.defaultDeviceUserCodeFactory.getObject()).clientRegistrationRequestSerializer(this.clientRegistrationRequestSerializer()).clientIdGenerator((RandomStringGenerator)new DefaultRandomStringGenerator()).clientSecretGenerator((RandomStringGenerator)new DefaultRandomStringGenerator()).principalFactory(this.oidcPrincipalFactory()).webApplicationServiceServiceFactory((ServiceFactory)this.webApplicationServiceFactory.getObject()).casProperties(this.casProperties).ticketGrantingTicketCookieGenerator((CasCookieBuilder)this.ticketGrantingTicketCookieGenerator.getObject()).oauthDistributedSessionCookieGenerator((CasCookieBuilder)this.oauthDistributedSessionCookieGenerator.getObject()).oauthConfig((Config)this.oauthSecConfig.getObject()).registeredServiceAccessStrategyEnforcer((AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject()).centralAuthenticationService((CentralAuthenticationService)this.centralAuthenticationService.getObject()).callbackAuthorizeViewResolver((OAuth20CallbackAuthorizeViewResolver)this.callbackAuthorizeViewResolver.getObject()).profileScopeToAttributesFilter(this.profileScopeToAttributesFilter()).accessTokenGenerator((OAuth20TokenGenerator)this.oauthTokenGenerator.getObject()).accessTokenResponseGenerator((OAuth20AccessTokenResponseGenerator)this.oidcAccessTokenResponseGenerator.getObject()).deviceTokenExpirationPolicy((ExpirationPolicyBuilder)this.deviceTokenExpirationPolicy.getObject()).accessTokenGrantRequestValidators((Collection)this.oauthTokenRequestValidators.getObject()).userProfileDataCreator(this.oidcUserProfileDataCreator()).userProfileViewRenderer(this.oidcUserProfileViewRenderer()).oAuthCodeFactory((OAuth20CodeFactory)this.defaultOAuthCodeFactory.getObject()).consentApprovalViewResolver(this.consentApprovalViewResolver()).authenticationBuilder((OAuth20CasAuthenticationBuilder)this.authenticationBuilder.getObject()).oauthAuthorizationResponseBuilders((Set)this.oidcAuthorizationResponseBuilders.getObject()).oauthInvalidAuthorizationResponseBuilder((OAuth20InvalidAuthorizationResponseBuilder)this.oauthInvalidAuthorizationBuilder.getObject()).oauthRequestValidators((Set)this.oauthRequestValidators.getObject()).singleLogoutServiceLogoutUrlBuilder((SingleLogoutServiceLogoutUrlBuilder)this.singleLogoutServiceLogoutUrlBuilder.getObject()).idTokenSigningAndEncryptionService(this.oidcTokenSigningAndEncryptionService()).accessTokenJwtBuilder(this.accessTokenJwtBuilder()).build();
    }
}

