/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.config;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.oidc.token.OidcIdTokenGeneratorService;
import org.apereo.cas.oidc.web.OidcAccessTokenResponseGenerator;
import org.apereo.cas.oidc.web.OidcAuthorizationModelAndViewBuilder;
import org.apereo.cas.oidc.web.OidcCallbackAuthorizeViewResolver;
import org.apereo.cas.oidc.web.OidcImplicitIdTokenAndTokenAuthorizationResponseBuilder;
import org.apereo.cas.oidc.web.OidcImplicitIdTokenAuthorizationResponseBuilder;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationCodeAuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationModelAndViewBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20ClientCredentialsResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20ResourceOwnerCredentialsResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20TokenAuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.views.OAuth20CallbackAuthorizeViewResolver;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.IdTokenGeneratorService;
import org.apereo.cas.ticket.code.OAuth20CodeFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.token.JwtBuilder;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="oidcResponseConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class OidcResponseConfiguration {
    @Autowired
    @Qualifier(value="defaultOAuthCodeFactory")
    private ObjectProvider<OAuth20CodeFactory> defaultOAuthCodeFactory;
    @Autowired
    @Qualifier(value="oauthTokenGenerator")
    private ObjectProvider<OAuth20TokenGenerator> oauthTokenGenerator;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="ticketRegistry")
    private ObjectProvider<TicketRegistry> ticketRegistry;
    @Autowired
    @Qualifier(value="accessTokenJwtBuilder")
    private ObjectProvider<JwtBuilder> accessTokenJwtBuilder;
    @Autowired
    @Qualifier(value="oidcConfigurationContext")
    private ObjectProvider<OidcConfigurationContext> oidcConfigurationContext;
    @Autowired
    @Qualifier(value="grantingTicketExpirationPolicy")
    private ObjectProvider<ExpirationPolicyBuilder> grantingTicketExpirationPolicy;
    @Autowired
    @Qualifier(value="oidcIssuerService")
    private ObjectProvider<OidcIssuerService> oidcIssuerService;

    @ConditionalOnMissingBean(name={"oidcAccessTokenResponseGenerator"})
    @Bean
    @RefreshScope
    public OAuth20AccessTokenResponseGenerator oidcAccessTokenResponseGenerator() {
        return new OidcAccessTokenResponseGenerator(this.oidcIdTokenGenerator(), (JwtBuilder)this.accessTokenJwtBuilder.getObject(), this.casProperties, (OidcIssuerService)this.oidcIssuerService.getObject());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcClientCredentialsResponseBuilder"})
    public OAuth20AuthorizationResponseBuilder oidcClientCredentialsResponseBuilder() {
        return new OAuth20ClientCredentialsResponseBuilder((ServicesManager)this.servicesManager.getObject(), this.oidcAccessTokenResponseGenerator(), (OAuth20TokenGenerator)this.oauthTokenGenerator.getObject(), this.casProperties, this.oauthAuthorizationModelAndViewBuilder());
    }

    @Bean
    public OAuth20CallbackAuthorizeViewResolver callbackAuthorizeViewResolver() {
        return new OidcCallbackAuthorizeViewResolver((ServicesManager)this.servicesManager.getObject(), this.oauthAuthorizationModelAndViewBuilder());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcTokenResponseBuilder"})
    public OAuth20AuthorizationResponseBuilder oidcTokenResponseBuilder() {
        return new OAuth20TokenAuthorizationResponseBuilder((ServicesManager)this.servicesManager.getObject(), this.casProperties, (OAuth20TokenGenerator)this.oauthTokenGenerator.getObject(), (JwtBuilder)this.accessTokenJwtBuilder.getObject(), this.oauthAuthorizationModelAndViewBuilder());
    }

    @Bean
    @RefreshScope
    public OAuth20AuthorizationModelAndViewBuilder oauthAuthorizationModelAndViewBuilder() {
        return new OidcAuthorizationModelAndViewBuilder((OidcIssuerService)this.oidcIssuerService.getObject(), this.casProperties);
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcAuthorizationCodeResponseBuilder"})
    public OAuth20AuthorizationResponseBuilder oidcAuthorizationCodeResponseBuilder() {
        return new OAuth20AuthorizationCodeAuthorizationResponseBuilder((ServicesManager)this.servicesManager.getObject(), this.casProperties, (TicketRegistry)this.ticketRegistry.getObject(), (OAuth20CodeFactory)this.defaultOAuthCodeFactory.getObject(), this.oauthAuthorizationModelAndViewBuilder());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcAuthorizationResponseBuilders"})
    public Set<OAuth20AuthorizationResponseBuilder> oidcAuthorizationResponseBuilders() {
        Map builders = this.applicationContext.getBeansOfType(OAuth20AuthorizationResponseBuilder.class, false, true);
        return builders.entrySet().stream().filter(e -> !((String)e.getKey()).startsWith("oauth")).map(Map.Entry::getValue).collect(Collectors.toSet());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcImplicitIdTokenCallbackUrlBuilder"})
    public OAuth20AuthorizationResponseBuilder oidcImplicitIdTokenCallbackUrlBuilder() {
        return new OidcImplicitIdTokenAuthorizationResponseBuilder(this.oidcIdTokenGenerator(), (OAuth20TokenGenerator)this.oauthTokenGenerator.getObject(), (ExpirationPolicyBuilder)this.grantingTicketExpirationPolicy.getObject(), (ServicesManager)this.servicesManager.getObject(), (JwtBuilder)this.accessTokenJwtBuilder.getObject(), this.casProperties, this.oauthAuthorizationModelAndViewBuilder());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcImplicitIdTokenAndTokenCallbackUrlBuilder"})
    public OAuth20AuthorizationResponseBuilder oidcImplicitIdTokenAndTokenCallbackUrlBuilder() {
        return new OidcImplicitIdTokenAndTokenAuthorizationResponseBuilder(this.oidcIdTokenGenerator(), (OAuth20TokenGenerator)this.oauthTokenGenerator.getObject(), (ExpirationPolicyBuilder)this.grantingTicketExpirationPolicy.getObject(), (ServicesManager)this.servicesManager.getObject(), (JwtBuilder)this.accessTokenJwtBuilder.getObject(), this.casProperties, this.oauthAuthorizationModelAndViewBuilder());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcResourceOwnerCredentialsResponseBuilder"})
    public OAuth20AuthorizationResponseBuilder oidcResourceOwnerCredentialsResponseBuilder() {
        return new OAuth20ResourceOwnerCredentialsResponseBuilder((ServicesManager)this.servicesManager.getObject(), this.casProperties, this.oidcAccessTokenResponseGenerator(), (OAuth20TokenGenerator)this.oauthTokenGenerator.getObject(), this.oauthAuthorizationModelAndViewBuilder());
    }

    @RefreshScope
    @ConditionalOnMissingBean(name={"oidcIdTokenGenerator"})
    @Bean
    public IdTokenGeneratorService oidcIdTokenGenerator() {
        return new OidcIdTokenGeneratorService((OidcConfigurationContext)this.oidcConfigurationContext.getObject());
    }
}

