/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.config;

import java.util.List;
import org.apereo.cas.oidc.config.OidcConfiguration;
import org.apereo.cas.oidc.util.OidcRequestSupport;
import org.apereo.cas.throttle.AuthenticationThrottlingExecutionPlan;
import org.apereo.cas.throttle.AuthenticationThrottlingExecutionPlanConfigurer;
import org.apereo.cas.throttle.ThrottledRequestFilter;
import org.pac4j.core.context.JEEContext;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(value="oidcThrottleConfiguration", proxyBeanMethods=true)
@AutoConfigureBefore(value={OidcConfiguration.class})
public class OidcThrottleConfiguration {
    private static final List<String> THROTTLED_ENDPOINTS = List.of("oidcAccessToken", "oidcAuthorize", "oidcToken", "oidcProfile", "jwks", "clientConfig", "revoke", "introspect");
    @Autowired
    @Qualifier(value="authenticationThrottlingExecutionPlan")
    private ObjectProvider<AuthenticationThrottlingExecutionPlan> authenticationThrottlingExecutionPlan;
    @Autowired
    @Qualifier(value="oidcRequestSupport")
    private ObjectProvider<OidcRequestSupport> oidcRequestSupport;

    @Bean
    @ConditionalOnMissingBean(name={"oidcThrottleWebMvcConfigurer"})
    public WebMvcConfigurer oidcThrottleWebMvcConfigurer() {
        return new WebMvcConfigurer(){

            public void addInterceptors(InterceptorRegistry registry) {
                List interceptors = ((AuthenticationThrottlingExecutionPlan)OidcThrottleConfiguration.this.authenticationThrottlingExecutionPlan.getObject()).getAuthenticationThrottleInterceptors();
                interceptors.forEach(handler -> registry.addInterceptor(handler).order(0).addPathPatterns(new String[]{"/oidc/**"}));
            }
        };
    }

    @ConditionalOnMissingBean(name={"oidcAuthenticationThrottlingExecutionPlanConfigurer"})
    @Bean
    public AuthenticationThrottlingExecutionPlanConfigurer oidcAuthenticationThrottlingExecutionPlanConfigurer() {
        return plan -> plan.registerAuthenticationThrottleFilter(this.oidcThrottledRequestFilter());
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcThrottledRequestFilter"})
    public ThrottledRequestFilter oidcThrottledRequestFilter() {
        return (request, response) -> {
            JEEContext webContext = new JEEContext(request, response);
            return THROTTLED_ENDPOINTS.stream().anyMatch(endpoint -> ((OidcRequestSupport)this.oidcRequestSupport.getObject()).isValidIssuerForEndpoint(webContext, endpoint));
        };
    }
}

