/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.nativex;

import java.util.Collection;
import java.util.List;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.oidc.claims.OidcRegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyCacheKey;
import org.apereo.cas.oidc.jwks.generator.OidcJsonWebKeystoreEntity;
import org.apereo.cas.oidc.jwks.generator.OidcJsonWebKeystoreGeneratorService;
import org.apereo.cas.oidc.ticket.OidcDefaultPushedAuthorizationRequest;
import org.apereo.cas.oidc.token.OidcJwtAccessTokenCipherExecutor;
import org.apereo.cas.oidc.web.response.OidcJwtResponseModeCipherExecutor;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.util.nativex.CasRuntimeHintsRegistrar;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.beans.factory.DisposableBean;

public class OidcRuntimeHints
implements CasRuntimeHintsRegistrar {
    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        OidcRuntimeHints.registerSerializationHints(hints, List.of(OidcRegisteredService.class, OidcJsonWebKeyCacheKey.class, OidcDefaultPushedAuthorizationRequest.class, OidcJsonWebKeystoreEntity.class));
        OidcRuntimeHints.registerReflectionHints(hints, List.of(OidcJsonWebKeystoreEntity.class, OidcJsonWebKeystoreGeneratorService.class, OidcRegisteredService.class, OidcJwtAccessTokenCipherExecutor.class, OidcJwtResponseModeCipherExecutor.class));
        Collection releasePolicies = this.findSubclassesInPackage(OidcRegisteredServiceAttributeReleasePolicy.class, new String[]{CentralAuthenticationService.NAMESPACE});
        OidcRuntimeHints.registerReflectionHints(hints, releasePolicies);
        OidcRuntimeHints.registerSerializationHints(hints, releasePolicies);
        Collection entries = this.findSubclassesInPackage(OidcJsonWebKeystoreGeneratorService.class, new String[]{CentralAuthenticationService.NAMESPACE});
        OidcRuntimeHints.registerReflectionHints(hints, entries);
        this.registerSpringProxy(hints, new Class[]{OidcJsonWebKeystoreGeneratorService.class, DisposableBean.class});
    }

    private static void registerSerializationHints(RuntimeHints hints, Collection<Class> entries) {
        entries.forEach(el -> hints.serialization().registerType(el));
    }

    private static void registerReflectionHints(RuntimeHints hints, Collection entries) {
        entries.forEach(el -> hints.reflection().registerType((Class)el, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_PUBLIC_METHODS, MemberCategory.DECLARED_FIELDS, MemberCategory.PUBLIC_FIELDS}));
    }
}

