/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.shell.cli;

import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.shell.cli.CommandLineOptions;
import org.apereo.cas.util.RegexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.Banner;
import org.springframework.core.env.Environment;

/*
 * Exception performing whole class analysis ignored.
 */
public class CasCommandLineParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCommandLineParser.class);
    private static final int WIDTH = 120;
    private final CommandLineParser parser;
    private final Options options = new Options();

    public CasCommandLineParser() {
        this.options.addOption(CommandLineOptions.OPTION_PROPERTY);
        this.options.addOption(CommandLineOptions.OPTION_HELP);
        this.options.addOption(CommandLineOptions.OPTION_SUMMARY);
        this.options.addOption(CommandLineOptions.OPTION_STRICT_MATCH);
        this.options.addOption(CommandLineOptions.OPTION_SKIP_BANNER);
        this.options.addOption(CommandLineOptions.OPTION_SHELL);
        this.options.addOption(CommandLineOptions.OPTION_GENERATE_KEY);
        this.options.addOption(CommandLineOptions.OPTION_GENERATE_JWT);
        this.options.addOption(CommandLineOptions.OPTION_SUBJECT);
        this.parser = new DefaultParser();
    }

    public CommandLine parse(String[] args) {
        try {
            return this.parser.parse(this.options, args);
        }
        catch (Exception e) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(e.getMessage(), (Throwable)e);
            } else {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    public void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(120, "java -jar [cas-server-support-shell-X-Y-Z.jar]", "\nCAS Command-line Shell\n", this.options, "\nThe CAS command-line shell provides the ability to query the CAS server for help on available settings/modules and various other utility functions.The shell engine is presented as both a CLI utility and an interactive shell.\n\nExample use cases include: \n1) Information on a property, such as description, defaults, hints and deprecation.\n2) Generating signing/encryption keys for relevant CAS configuration.\n3) Validating JSON/YAML service definitions for fun and profit.\n4) Retrieving list of available settings for a given module/group.\n5) etc.\n", true);
    }

    public Pattern getProperty(CommandLine line) {
        return RegexUtils.createPattern((String)this.getOptionValue(line, CommandLineOptions.OPTION_PROPERTY, ".+"));
    }

    public String getSubject(CommandLine line) {
        return this.getOptionValue(line, CommandLineOptions.OPTION_SUBJECT, null);
    }

    public String getPropertyValue(CommandLine line) {
        return this.getOptionValue(line, CommandLineOptions.OPTION_PROPERTY, "");
    }

    public boolean isHelp(CommandLine line) {
        return line == null || this.hasOption(line, CommandLineOptions.OPTION_HELP);
    }

    public boolean isGeneratingKey(CommandLine line) {
        return this.hasOption(line, CommandLineOptions.OPTION_GENERATE_KEY);
    }

    public boolean isGeneratingJwt(CommandLine line) {
        return this.hasOption(line, CommandLineOptions.OPTION_GENERATE_JWT);
    }

    public boolean isSummary(CommandLine line) {
        return this.hasOption(line, CommandLineOptions.OPTION_SUMMARY);
    }

    public boolean isStrictMatch(CommandLine line) {
        return this.hasOption(line, CommandLineOptions.OPTION_STRICT_MATCH);
    }

    public boolean isSkippingBanner(CommandLine line) {
        return this.hasOption(line, CommandLineOptions.OPTION_SKIP_BANNER);
    }

    public static boolean isSkippingBanner(Environment env) {
        return env.containsProperty(CommandLineOptions.OPTION_SKIP_BANNER.getOpt());
    }

    public String getOptionValue(CommandLine line, Option opt, String defaultValue) {
        return line.hasOption(opt.getOpt()) ? line.getOptionValue(opt.getOpt()) : defaultValue;
    }

    public boolean getOptionValue(CommandLine line, Option opt, boolean defaultValue) {
        return line.hasOption(opt.getOpt()) ? Boolean.parseBoolean(line.getOptionValue(opt.getOpt())) : defaultValue;
    }

    public boolean hasOption(CommandLine line, Option opt) {
        return line.hasOption(opt.getOpt());
    }

    public Options getOptions() {
        return this.options;
    }

    public static Banner.Mode getBannerMode(String[] args) {
        CasCommandLineParser parser = new CasCommandLineParser();
        CommandLine line = parser.parse(args);
        return line != null && parser.isSkippingBanner(line) || CasCommandLineParser.isShell((String[])args) ? Banner.Mode.OFF : Banner.Mode.CONSOLE;
    }

    public static boolean isShell(String[] args) {
        CasCommandLineParser parser = new CasCommandLineParser();
        CommandLine line = parser.parse(args);
        return line != null && parser.hasOption(line, CommandLineOptions.OPTION_SHELL);
    }

    public static void convertToSystemProperties(String[] args) {
        CasCommandLineParser parser = new CasCommandLineParser();
        CommandLine line = parser.parse(args);
        parser.getOptions().getOptions().forEach(o -> {
            if (parser.hasOption(line, o)) {
                String optionValue = parser.getOptionValue(line, o, null);
                System.setProperty(o.getOpt(), (String)StringUtils.defaultIfBlank((CharSequence)optionValue, (CharSequence)""));
            }
        });
    }
}

